/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RAFInputStreamAdapter
extends InputStream {
    private final RandomAccessFile raf;
    private long markedPos;
    private IOException markException;

    public RAFInputStreamAdapter(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            throw new NullPointerException();
        }
        this.raf = randomAccessFile;
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.raf.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.raf.skipBytes((int)l);
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.markedPos = this.raf.getFilePointer();
            this.markException = null;
        }
        catch (IOException iOException) {
            this.markException = iOException;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markException != null) {
            throw this.markException;
        }
        this.raf.seek(this.markedPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

