/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

import org.dcm4che3.util.ByteUtils;

public class SOSSegment {
    private final byte[] data;
    private final int offset;
    private final int numComponents;

    public SOSSegment(byte[] byArray, int n) {
        this.data = byArray;
        this.offset = n;
        this.numComponents = byArray[n + 3] & 0xFF;
        this.getAl();
    }

    public int offset() {
        return this.offset;
    }

    public int getMarker() {
        return this.data[this.offset] & 0xFF;
    }

    public int getHeaderLength() {
        return ByteUtils.bytesToUShortBE(this.data, this.offset + 1);
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getComponentID(int n) {
        return this.data[this.offset + 4 + n * 2] & 0xFF;
    }

    public int getTa(int n) {
        return this.data[this.offset + 5 + n * 2] >> 4 & 0xF;
    }

    public int getTd(int n) {
        return this.data[this.offset + 5 + n * 2] & 0xF;
    }

    public int getSs() {
        return this.data[this.offset + 4 + this.numComponents * 2] & 0xFF;
    }

    public int getSe() {
        return this.data[this.offset + 5 + this.numComponents * 2] & 0xFF;
    }

    public int getAh() {
        return this.data[this.offset + 6 + this.numComponents * 2] >> 4 & 0xF;
    }

    public int getAl() {
        return this.data[this.offset + 6 + this.numComponents * 2] & 0xF;
    }

    public int getNear() {
        return this.getSs();
    }

    public int getILV() {
        return this.getSe();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SOS=[Ls=").append(this.getHeaderLength()).append(", Ns=").append(this.numComponents);
        int n = 0;
        while (n < this.numComponents) {
            stringBuilder.append(", C").append(n + 1).append('=').append(this.getComponentID(n)).append(", Td").append(n + 1).append('=').append(this.getTd(n)).append(", Ta").append(n + 1).append('=').append(this.getTa(n));
            ++n;
        }
        stringBuilder.append(", Ss=").append(this.getSs()).append(", Se=").append(this.getSe()).append(", Ah=").append(this.getAh()).append(", Al=").append(this.getAl()).append(']');
        return stringBuilder.toString();
    }
}

