/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

public class JPEGLSCodingParam {
    private int offset;
    private final int maxVal;
    private final int t1;
    private final int t2;
    private final int t3;
    private final int reset;

    public JPEGLSCodingParam(int n, int n2, int n3, int n4, int n5) {
        this.maxVal = n;
        this.t1 = n2;
        this.t2 = n3;
        this.t3 = n4;
        this.reset = n5;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public final int getMaxVal() {
        return this.maxVal;
    }

    public final int getT1() {
        return this.t1;
    }

    public final int getT2() {
        return this.t2;
    }

    public final int getT3() {
        return this.t3;
    }

    public final int getReset() {
        return this.reset;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[15];
        byArray[0] = -1;
        byArray[1] = -8;
        byArray[3] = 13;
        byArray[4] = 1;
        byArray[5] = (byte)(this.maxVal >> 8);
        byArray[6] = (byte)this.maxVal;
        byArray[7] = (byte)(this.t1 >> 8);
        byArray[8] = (byte)this.t1;
        byArray[9] = (byte)(this.t2 >> 8);
        byArray[10] = (byte)this.t2;
        byArray[11] = (byte)(this.t3 >> 8);
        byArray[12] = (byte)this.t3;
        byArray[13] = (byte)(this.reset >> 8);
        byArray[14] = (byte)this.reset;
        return byArray;
    }

    private static JPEGLSCodingParam getDefaultJPEGLSEncodingParam(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n2 + 128 >> 8;
        int n7 = n6 + 2 + 3 * n3;
        if (n7 > n || n7 < n3 + 1) {
            n7 = n3 + 1;
        }
        if ((n5 = n6 * 4 + 3 + 5 * n3) > n || n5 < n7) {
            n5 = n7;
        }
        if ((n4 = n6 * 17 + 4 + 7 * n3) > n || n4 < n5) {
            n4 = n5;
        }
        return new JPEGLSCodingParam(n, n7, n5, n4, 64);
    }

    public static JPEGLSCodingParam getDefaultJPEGLSCodingParam(int n, int n2) {
        int n3 = (1 << n) - 1;
        return JPEGLSCodingParam.getDefaultJPEGLSEncodingParam(n3, Math.min(n3, 4095), n2);
    }

    public static JPEGLSCodingParam getJAIJPEGLSCodingParam(int n) {
        int n2 = (1 << n) - 1;
        return JPEGLSCodingParam.getDefaultJPEGLSEncodingParam(n2, n2, 0);
    }

    public String toString() {
        return "JPEGLSCodingParam[MAXVAL=" + this.maxVal + ", T1=" + this.t1 + ", T2=" + this.t2 + ", T3=" + this.t3 + ", RESET=" + this.reset + "]";
    }
}

