/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import org.dcm4che3.data.Attributes;

public abstract class StoredValue {
    public abstract int valueOf(int var1);

    public abstract int minValue();

    public abstract int maxValue();

    public static StoredValue valueOf(Attributes attributes) {
        int n = attributes.getInt(2621697, 0);
        if (n == 0) {
            n = attributes.getInt(2621696, 8);
        }
        return attributes.getInt(2621699, 0) != 0 ? new Signed(n) : new Unsigned(n);
    }

    public static class Signed
    extends StoredValue {
        private final int bitsStored;
        private final int shift;

        public Signed(int n) {
            this.bitsStored = n;
            this.shift = 32 - n;
        }

        @Override
        public int valueOf(int n) {
            return n << this.shift >> this.shift;
        }

        @Override
        public int minValue() {
            return -(1 << this.bitsStored - 1);
        }

        @Override
        public int maxValue() {
            return (1 << this.bitsStored - 1) - 1;
        }
    }

    public static class Unsigned
    extends StoredValue {
        private final int mask;

        public Unsigned(int n) {
            this.mask = (1 << n) - 1;
        }

        @Override
        public int valueOf(int n) {
            return n & this.mask;
        }

        @Override
        public int minValue() {
            return 0;
        }

        @Override
        public int maxValue() {
            return this.mask;
        }
    }
}

