/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import org.dcm4che3.image.StoredValue;

public abstract class LookupTable {
    protected StoredValue inBits;
    protected int outBits;
    protected int offset;

    public LookupTable(StoredValue storedValue, int n, int n2) {
        this.inBits = storedValue;
        this.outBits = n;
        this.offset = n2;
    }

    public abstract int length();

    public void lookup(Raster raster, Raster raster2) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataBuffer dataBuffer2 = raster2.getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 0: {
                switch (dataBuffer2.getDataType()) {
                    case 0: {
                        this.lookup(componentSampleModel, ((DataBufferByte)dataBuffer).getData(), componentSampleModel2, ((DataBufferByte)dataBuffer2).getData());
                        return;
                    }
                    case 1: {
                        this.lookup(componentSampleModel, ((DataBufferByte)dataBuffer).getData(), componentSampleModel2, ((DataBufferUShort)dataBuffer2).getData());
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (dataBuffer2.getDataType()) {
                    case 0: {
                        this.lookup(componentSampleModel, ((DataBufferUShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferByte)dataBuffer2).getData());
                        return;
                    }
                    case 1: {
                        this.lookup(componentSampleModel, ((DataBufferUShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferUShort)dataBuffer2).getData());
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (dataBuffer2.getDataType()) {
                    case 0: {
                        this.lookup(componentSampleModel, ((DataBufferShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferByte)dataBuffer2).getData());
                        return;
                    }
                    case 1: {
                        this.lookup(componentSampleModel, ((DataBufferShort)dataBuffer).getData(), componentSampleModel2, ((DataBufferUShort)dataBuffer2).getData());
                        return;
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Lookup " + dataBuffer.getClass() + " -> " + dataBuffer2.getClass() + " not supported");
    }

    private void lookup(ComponentSampleModel componentSampleModel, byte[] byArray, ComponentSampleModel componentSampleModel2, byte[] byArray2) {
        int n = componentSampleModel.getWidth();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel2.getScanlineStride();
        int n5 = 0;
        while (n5 < n2) {
            this.lookup(byArray, n5 * n3, byArray2, n5 * n4, n);
            ++n5;
        }
    }

    private void lookup(ComponentSampleModel componentSampleModel, short[] sArray, ComponentSampleModel componentSampleModel2, byte[] byArray) {
        int n = componentSampleModel.getWidth();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel2.getScanlineStride();
        int n5 = 0;
        while (n5 < n2) {
            this.lookup(sArray, n5 * n3, byArray, n5 * n4, n);
            ++n5;
        }
    }

    private void lookup(ComponentSampleModel componentSampleModel, byte[] byArray, ComponentSampleModel componentSampleModel2, short[] sArray) {
        int n = componentSampleModel.getWidth();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel2.getScanlineStride();
        int n5 = 0;
        while (n5 < n2) {
            this.lookup(byArray, n5 * n3, sArray, n5 * n4, n);
            ++n5;
        }
    }

    private void lookup(ComponentSampleModel componentSampleModel, short[] sArray, ComponentSampleModel componentSampleModel2, short[] sArray2) {
        int n = componentSampleModel.getWidth();
        int n2 = componentSampleModel.getHeight();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel2.getScanlineStride();
        int n5 = 0;
        while (n5 < n2) {
            this.lookup(sArray, n5 * n3, sArray2, n5 * n4, n);
            ++n5;
        }
    }

    public abstract void lookup(byte[] var1, int var2, byte[] var3, int var4, int var5);

    public abstract void lookup(short[] var1, int var2, byte[] var3, int var4, int var5);

    public abstract void lookup(byte[] var1, int var2, short[] var3, int var4, int var5);

    public abstract void lookup(short[] var1, int var2, short[] var3, int var4, int var5);

    public abstract LookupTable adjustOutBits(int var1);

    public abstract void inverse();

    public abstract LookupTable combine(LookupTable var1);
}

