/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.ColorSubsampling;
import org.dcm4che3.image.PaletteColorModel;
import org.dcm4che3.image.SampledComponentColorModel;
import org.dcm4che3.image.YBR;
import org.dcm4che3.image.YBRColorSpace;

public class ColorModelFactory {
    public static ColorModel createMonochromeColorModel(int n, int n2) {
        return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{n}, false, false, 1, n2);
    }

    public static ColorModel createPaletteColorModel(int n, int n2, Attributes attributes) {
        return new PaletteColorModel(n, n2, ColorModelFactory.createRGBColorSpace(attributes), attributes);
    }

    public static ColorModel createRGBColorModel(int n, int n2, Attributes attributes) {
        return new ComponentColorModel(ColorModelFactory.createRGBColorSpace(attributes), new int[]{n, n, n}, false, false, 1, n2);
    }

    public static ColorModel createYBRFullColorModel(int n, int n2, Attributes attributes) {
        return new ComponentColorModel(new YBRColorSpace(ColorModelFactory.createRGBColorSpace(attributes), YBR.FULL), new int[]{n, n, n}, false, false, 1, n2);
    }

    public static ColorModel createYBRColorModel(int n, int n2, Attributes attributes, YBR yBR, ColorSubsampling colorSubsampling) {
        return new SampledComponentColorModel(new YBRColorSpace(ColorModelFactory.createRGBColorSpace(attributes), yBR), colorSubsampling);
    }

    private static ColorSpace createRGBColorSpace(Attributes attributes) {
        return ColorModelFactory.createRGBColorSpace(attributes.getSafeBytes(0x282000));
    }

    private static ColorSpace createRGBColorSpace(byte[] byArray) {
        if (byArray != null) {
            return new ICC_ColorSpace(ICC_Profile.getInstance(byArray));
        }
        return ColorSpace.getInstance(1000);
    }
}

