/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ItemPointer;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class ValueSelector
implements Serializable {
    private static final long serialVersionUID = 8346808223314626639L;
    private static final ItemPointer[] NO_ITEMPOINTERS = new ItemPointer[0];
    private static final int MIN_ITEM_POINTER_STR_LEN = 43;
    public final int tag;
    public final String privateCreator;
    public final VR vr;
    public final int valueIndex;
    public final ItemPointer[] itemPointers;

    public ValueSelector(int n, String string, VR vR, int n2, ItemPointer ... itemPointerArray) {
        this.tag = n;
        this.privateCreator = string;
        this.vr = vR;
        this.valueIndex = n2;
        this.itemPointers = (ItemPointer[])itemPointerArray.clone();
    }

    public String selectStringValue(Attributes attributes, String string) {
        Attributes attributes2 = attributes.getNestedDataset(this.itemPointers);
        return attributes2 != null ? attributes2.getString(this.privateCreator, this.tag, this.vr, this.valueIndex, string) : string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        ItemPointer[] itemPointerArray = this.itemPointers;
        int n = this.itemPointers.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPointer itemPointer = itemPointerArray[n2];
            this.appendTo(itemPointer.sequenceTag, itemPointer.privateCreator, itemPointer.itemIndex, "\"]/Item[@number=\"", "\"]/", stringBuilder);
            ++n2;
        }
        this.appendTo(this.tag, this.privateCreator, this.valueIndex, "\"]/Value[@number=\"", "\"]", stringBuilder);
        return stringBuilder.toString();
    }

    private void appendTo(int n, String string, int n2, String string2, String string3, StringBuilder stringBuilder) {
        stringBuilder.append("DicomAttribute[@tag=\"").append(TagUtils.toHexString(n));
        if (string != null) {
            stringBuilder.append("\" and @privateCreator=\"").append(string);
        }
        if (this.vr != null) {
            stringBuilder.append("\" and @vr=\"").append((Object)this.vr);
        }
        stringBuilder.append(string2).append(n2 + 1).append(string3);
    }

    public static ValueSelector valueOf(String string) {
        int n = string.lastIndexOf("DicomAttribute");
        try {
            return new ValueSelector(ValueSelector.selectTag(string, n), ValueSelector.selectPrivateCreator(string, n), ValueSelector.selectVR(string, n), ValueSelector.selectNumber(string, n) - 1, ValueSelector.itemPointersOf(string, n));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    private static int selectTag(String string, int n) {
        String string2 = ValueSelector.select("@tag=", string, n);
        return Integer.parseInt(string2, 16);
    }

    private static String selectPrivateCreator(String string, int n) {
        return ValueSelector.select("@privateCreator=", string, n);
    }

    private static int selectNumber(String string, int n) {
        String string2 = ValueSelector.select("@number=", string, n);
        return Integer.parseInt(string2);
    }

    private static VR selectVR(String string, int n) {
        String string2 = ValueSelector.select("@vr=", string, n);
        return string2 != null ? VR.valueOf(string2) : null;
    }

    private static ItemPointer[] itemPointersOf(String string, int n) {
        if (n == 0) {
            return NO_ITEMPOINTERS;
        }
        ArrayList<ItemPointer> arrayList = new ArrayList<ItemPointer>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new ItemPointer(ValueSelector.selectTag(string, n2), ValueSelector.selectPrivateCreator(string, n2), ValueSelector.selectNumber(string, n2) - 1));
            n2 = string.indexOf("DicomAttribute", n2 + 43);
        }
        return arrayList.toArray(new ItemPointer[arrayList.size()]);
    }

    private static String select(String string, String string2, int n) {
        int n2 = string2.indexOf(string, n);
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 + string.length();
        int n4 = n3 + 1;
        return string2.substring(n4, string2.indexOf(string2.charAt(n3), n4));
    }
}

