/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.util.Date;
import java.util.TimeZone;
import org.dcm4che3.data.BinaryValueType;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.DatePrecisions;
import org.dcm4che3.data.SequenceValueType;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.StringValueType;
import org.dcm4che3.data.ValueType;
import org.dcm4che3.io.SAXWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public enum VR {
    AE(16709, 8, 32, StringValueType.ASCII, false),
    AS(16723, 8, 32, StringValueType.ASCII, false),
    AT(16724, 8, 0, BinaryValueType.TAG, false),
    CS(17235, 8, 32, StringValueType.ASCII, false),
    DA(17473, 8, 32, StringValueType.DA, false),
    DS(17491, 8, 32, StringValueType.DS, false),
    DT(17492, 8, 32, StringValueType.DT, false),
    FD(17988, 8, 0, BinaryValueType.DOUBLE, false),
    FL(17996, 8, 0, BinaryValueType.FLOAT, false),
    IS(18771, 8, 32, StringValueType.IS, false),
    LO(19535, 8, 32, StringValueType.STRING, false),
    LT(19540, 8, 32, StringValueType.TEXT, false),
    OB(20290, 12, 0, BinaryValueType.BYTE, true),
    OF(20294, 12, 0, BinaryValueType.FLOAT, true),
    OW(20311, 12, 0, BinaryValueType.SHORT, true),
    PN(20558, 8, 32, StringValueType.PN, false),
    SH(21320, 8, 32, StringValueType.STRING, false),
    SL(21324, 8, 0, BinaryValueType.INT, false),
    SQ(21329, 12, 0, SequenceValueType.SQ, false),
    SS(21331, 8, 0, BinaryValueType.SHORT, false),
    ST(21332, 8, 32, StringValueType.TEXT, false),
    TM(21581, 8, 32, StringValueType.TM, false),
    UI(21833, 8, 0, StringValueType.ASCII, false),
    UL(21836, 8, 0, BinaryValueType.INT, false),
    UN(21838, 12, 0, BinaryValueType.BYTE, true),
    US(21843, 8, 0, BinaryValueType.USHORT, false),
    UT(21844, 12, 32, StringValueType.TEXT, false);

    private static Logger LOG;
    protected final int code;
    protected final int headerLength;
    protected final int paddingByte;
    protected final ValueType valueType;
    protected final boolean inlineBinary;
    private static final VR[] VALUE_OF;

    static {
        LOG = LoggerFactory.getLogger(VR.class);
        VALUE_OF = new VR[5136];
        VR.VALUE_OF[0] = AE;
        VR.VALUE_OF[14] = AS;
        VR.VALUE_OF[15] = AT;
        VR.VALUE_OF[526] = CS;
        VR.VALUE_OF[764] = DA;
        VR.VALUE_OF[782] = DS;
        VR.VALUE_OF[783] = DT;
        VR.VALUE_OF[1279] = FD;
        VR.VALUE_OF[1287] = FL;
        VR.VALUE_OF[2062] = IS;
        VR.VALUE_OF[2826] = LO;
        VR.VALUE_OF[2831] = LT;
        VR.VALUE_OF[3581] = OB;
        VR.VALUE_OF[3585] = OF;
        VR.VALUE_OF[3602] = OW;
        VR.VALUE_OF[3849] = PN;
        VR.VALUE_OF[4611] = SH;
        VR.VALUE_OF[4615] = SL;
        VR.VALUE_OF[4620] = SQ;
        VR.VALUE_OF[4622] = SS;
        VR.VALUE_OF[4623] = ST;
        VR.VALUE_OF[4872] = TM;
        VR.VALUE_OF[5124] = UI;
        VR.VALUE_OF[5127] = UL;
        VR.VALUE_OF[5129] = UN;
        VR.VALUE_OF[5134] = US;
        VR.VALUE_OF[5135] = UT;
    }

    private VR(int n2, int n3, int n4, ValueType valueType, boolean bl) {
        this.code = n2;
        this.headerLength = n3;
        this.paddingByte = n4;
        this.valueType = valueType;
        this.inlineBinary = bl;
    }

    public int code() {
        return this.code;
    }

    public int headerLength() {
        return this.headerLength;
    }

    public int paddingByte() {
        return this.paddingByte;
    }

    public boolean isTemporalType() {
        return this.valueType.isTemporalType();
    }

    public boolean isStringType() {
        return this.valueType.isStringValue();
    }

    public boolean useSpecificCharacterSet() {
        return this.valueType.useSpecificCharacterSet();
    }

    public boolean isIntType() {
        return this.valueType.isIntValue();
    }

    public boolean isInlineBinary() {
        return this.inlineBinary;
    }

    public int numEndianBytes() {
        return this.valueType.numEndianBytes();
    }

    public byte[] toggleEndian(byte[] byArray, boolean bl) {
        return this.valueType.toggleEndian(byArray, bl);
    }

    public byte[] toBytes(Object object, SpecificCharacterSet specificCharacterSet) {
        return this.valueType.toBytes(object, specificCharacterSet);
    }

    Object toStrings(Object object, boolean bl, SpecificCharacterSet specificCharacterSet) {
        return this.valueType.toStrings(object, bl, specificCharacterSet);
    }

    String toString(Object object, boolean bl, int n, String string) {
        return this.valueType.toString(object, bl, n, string);
    }

    int toInt(Object object, boolean bl, int n, int n2) {
        return this.valueType.toInt(object, bl, n, n2);
    }

    int[] toInts(Object object, boolean bl) {
        return this.valueType.toInts(object, bl);
    }

    float toFloat(Object object, boolean bl, int n, float f) {
        return this.valueType.toFloat(object, bl, n, f);
    }

    float[] toFloats(Object object, boolean bl) {
        return this.valueType.toFloats(object, bl);
    }

    double toDouble(Object object, boolean bl, int n, double d) {
        return this.valueType.toDouble(object, bl, n, d);
    }

    double[] toDoubles(Object object, boolean bl) {
        return this.valueType.toDoubles(object, bl);
    }

    public Date toDate(Object object, TimeZone timeZone, int n, boolean bl, Date date, DatePrecision datePrecision) {
        return this.valueType.toDate(object, timeZone, n, bl, date, datePrecision);
    }

    public Date[] toDates(Object object, TimeZone timeZone, boolean bl, DatePrecisions datePrecisions) {
        return this.valueType.toDate(object, timeZone, bl, datePrecisions);
    }

    Object toValue(byte[] byArray) {
        return this.valueType.toValue(byArray);
    }

    Object toValue(String string, boolean bl) {
        return this.valueType.toValue(string, bl);
    }

    Object toValue(String[] stringArray, boolean bl) {
        return this.valueType.toValue(stringArray, bl);
    }

    Object toValue(int[] nArray, boolean bl) {
        return this.valueType.toValue(nArray, bl);
    }

    Object toValue(float[] fArray, boolean bl) {
        return this.valueType.toValue(fArray, bl);
    }

    Object toValue(double[] dArray, boolean bl) {
        return this.valueType.toValue(dArray, bl);
    }

    public Object toValue(Date[] dateArray, TimeZone timeZone, DatePrecision datePrecision) {
        return this.valueType.toValue(dateArray, timeZone, datePrecision);
    }

    public boolean prompt(Object object, boolean bl, SpecificCharacterSet specificCharacterSet, int n, StringBuilder stringBuilder) {
        return this.valueType.prompt(object, bl, specificCharacterSet, n, stringBuilder);
    }

    public void toXML(Object object, boolean bl, SpecificCharacterSet specificCharacterSet, SAXWriter sAXWriter) throws SAXException {
        this.valueType.toXML(object, bl, specificCharacterSet, sAXWriter, this.inlineBinary);
    }

    public int vmOf(Object object) {
        return this.headerLength == 12 ? 1 : this.valueType.vmOf(object);
    }

    public static VR valueOf(String string) {
        return Enum.valueOf(VR.class, string);
    }

    public static class Holder {
        public VR vr;
    }
}

