/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;

public class IDWithIssuer {
    public static final IDWithIssuer[] EMPTY = new IDWithIssuer[0];
    private final String id;
    private Issuer issuer;

    public IDWithIssuer(String string, Issuer issuer) {
        this.id = string;
        this.setIssuer(issuer);
    }

    public IDWithIssuer(String string, String string2) {
        this.id = string;
        this.setIssuer(string2 != null ? new Issuer(string2, '&') : null);
    }

    public IDWithIssuer(String string) {
        String[] stringArray = StringUtils.split(string, '^');
        this.id = stringArray[0];
        this.setIssuer(stringArray.length > 3 ? new Issuer(stringArray[3], '&') : null);
    }

    public final String getID() {
        return this.id;
    }

    public final Issuer getIssuer() {
        return this.issuer;
    }

    public final void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public String toString() {
        return this.getIssuer() == null ? this.id : String.valueOf(this.id) + "^^^" + this.getIssuer().toString('&');
    }

    public Attributes toPatientIDWithIssuer(Attributes attributes) {
        if (attributes == null) {
            attributes = new Attributes(3);
        }
        attributes.setString(0x100020, VR.LO, this.id);
        if (this.getIssuer() == null) {
            return attributes;
        }
        return this.getIssuer().toIssuerOfPatientID(attributes);
    }

    public static IDWithIssuer valueOf(Attributes attributes, int n, int n2) {
        String string = attributes.getString(n);
        if (string == null) {
            return null;
        }
        return new IDWithIssuer(string, Issuer.valueOf(attributes.getNestedDataset(n2)));
    }

    public static IDWithIssuer fromPatientIDWithIssuer(Attributes attributes) {
        String string = attributes.getString(0x100020);
        if (string == null) {
            return null;
        }
        return new IDWithIssuer(string, Issuer.fromIssuerOfPatientID(attributes));
    }
}

