/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.data;

import java.io.Serializable;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class Code
implements Serializable {
    private static final String NO_CODE_MEANING = "<none>";
    private static final long serialVersionUID = 8807594793107889446L;
    private String codeValue;
    private String codingSchemeDesignator;
    private String codingSchemeVersion;
    private String codeMeaning;

    public Code(String string, String string2, String string3, String string4) {
        if (string == null) {
            throw new NullPointerException("Missing Code Value");
        }
        if (string2 == null) {
            throw new NullPointerException("Missing Coding Scheme Designator");
        }
        if (string4 == null) {
            throw new NullPointerException("Missing Code Meaning");
        }
        this.codeValue = string;
        this.codingSchemeDesignator = string2;
        this.codingSchemeVersion = string3;
        this.codeMeaning = string4;
    }

    public Code(String string) {
        int n = string.length();
        if (n < 9 || string.charAt(0) != '(' || string.charAt(n - 2) != '\"' || string.charAt(n - 1) != ')') {
            throw new IllegalArgumentException(string);
        }
        int n2 = string.indexOf(44);
        int n3 = string.indexOf(44, n2 + 1);
        int n4 = string.indexOf(34, n3 + 1) + 1;
        this.codeValue = this.trimsubstring(string, 1, n2);
        this.codingSchemeDesignator = this.trimsubstring(string, n2 + 1, n3);
        this.codeMeaning = this.trimsubstring(string, n4, n - 2);
        if (this.codingSchemeDesignator.endsWith("]")) {
            int n5 = string.lastIndexOf(93, n3 - 1);
            n3 = string.lastIndexOf(91, n5 - 1);
            this.codingSchemeDesignator = this.trimsubstring(string, n2 + 1, n3);
            this.codingSchemeVersion = this.trimsubstring(string, n3 + 1, n5);
        }
    }

    private String trimsubstring(String string, int n, int n2) {
        try {
            String string2 = string.substring(n, n2).trim();
            if (!string2.isEmpty()) {
                return string2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        throw new IllegalArgumentException(string);
    }

    public Code(Attributes attributes) {
        this(attributes.getString(524544, null), attributes.getString(524546, null), attributes.getString(524547, null), attributes.getString(524548, NO_CODE_MEANING));
    }

    protected Code() {
    }

    public final String getCodeValue() {
        return this.codeValue;
    }

    public final String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public final String getCodingSchemeVersion() {
        return this.codingSchemeVersion;
    }

    public final String getCodeMeaning() {
        return this.codeMeaning;
    }

    public int hashCode() {
        return 37 * (37 * (37 * this.codeValue.hashCode() + this.codeMeaning.hashCode()) + this.codingSchemeDesignator.hashCode()) + this.hashCode(this.codingSchemeVersion);
    }

    private int hashCode(String string) {
        return string == null ? 0 : string.hashCode();
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public boolean equalsIgnoreMeaning(Code code) {
        return this.equals(code, true);
    }

    private boolean equals(Object object, boolean bl) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Code)) {
            return false;
        }
        Code code = (Code)object;
        return this.codeValue.equals(code.codeValue) && this.codingSchemeDesignator.equals(code.codingSchemeDesignator) && this.equals(this.codingSchemeVersion, code.codingSchemeVersion) && (bl || this.codeMeaning.equals(code.codeMeaning));
    }

    private boolean equals(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.codeValue).append(", ").append(this.codingSchemeDesignator);
        if (this.codingSchemeVersion != null) {
            stringBuilder.append(" [").append(this.codingSchemeVersion).append(']');
        }
        stringBuilder.append(", \"").append(this.codeMeaning).append("\")");
        return stringBuilder.toString();
    }

    public Attributes toItem() {
        Attributes attributes = new Attributes(this.codingSchemeVersion != null ? 4 : 3);
        attributes.setString(524544, VR.SH, this.codeValue);
        attributes.setString(524546, VR.SH, this.codingSchemeDesignator);
        if (this.codingSchemeVersion != null) {
            attributes.setString(524547, VR.SH, this.codingSchemeVersion);
        }
        attributes.setString(524548, VR.LO, this.codeMeaning);
        return attributes;
    }
}

