/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.sr.contenttree;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.dicomobject.module.sr.SRDocumentContentModule;
import com.agfa.pacs.listtext.dicomobject.sr.content.Content;
import com.agfa.pacs.listtext.dicomobject.sr.content.ContentTemplate;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentContent;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentRelationship;
import com.agfa.pacs.listtext.dicomobject.sr.contenttree.DocumentContentTreeNode;
import com.agfa.pacs.listtext.dicomobject.type.ContinuityOfContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DocumentContentTree {
    private DocumentContentTreeNode root;

    public DocumentContentTree(SRDocumentContentModule sRDocumentContentModule) {
        this.getFrom(sRDocumentContentModule);
    }

    public DocumentContentTree(DocumentContentTreeNode documentContentTreeNode) {
        this.root = documentContentTreeNode;
    }

    public DocumentContentTree() {
        this.root = new DocumentContentTreeNode(new DocumentContent.ContainerContent(), null);
    }

    public DocumentContentTree(Code code, ContinuityOfContent continuityOfContent) {
        this.root = new DocumentContentTreeNode(new DocumentContent.ContainerContent(code, continuityOfContent), null);
    }

    public void getFrom(SRDocumentContentModule sRDocumentContentModule) {
        this.getFrom(sRDocumentContentModule.getDocumentContent(), sRDocumentContentModule.getDocumentRelationship());
    }

    public void getFrom(DocumentContent documentContent, DocumentRelationship documentRelationship) {
        this.getFrom(new Content(null, documentContent, documentRelationship));
    }

    public void getFrom(Content content) {
        if (content.getDocumentRelationship() == null || content.getDocumentContent() == null) {
            return;
        }
        HashMap<Content, DocumentContentTreeNode> hashMap = new HashMap<Content, DocumentContentTreeNode>();
        this.fromContent(null, content, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            ((DocumentContentTreeNode)entry.getValue()).setReferencedNode(this.findNode(((Content)((Object)entry.getKey())).getReferencedContentItemIdentifier()));
        }
    }

    public Content toContent() {
        return this.toContent(this.root);
    }

    public void putTo(SRDocumentContentModule sRDocumentContentModule) {
        Content content = this.toContent();
        sRDocumentContentModule.setDocumentContent(content.getDocumentContent());
        sRDocumentContentModule.setDocumentRelationship(content.getDocumentRelationship());
    }

    public DocumentContentTreeNode getRoot() {
        return this.root;
    }

    private Content toContent(DocumentContentTreeNode documentContentTreeNode) {
        if (documentContentTreeNode.getReferencedNode() != null) {
            return new Content(documentContentTreeNode.getRelationshipType(), this.getContentItemIdentfier(documentContentTreeNode));
        }
        DocumentRelationship documentRelationship = new DocumentRelationship();
        documentRelationship.setObservationDateTime(documentContentTreeNode.getObservationDateTime());
        for (DocumentContentTreeNode documentContentTreeNode2 : documentContentTreeNode.children()) {
            Content content = this.toContent(documentContentTreeNode2);
            documentRelationship.content().add(content);
        }
        return new Content(documentContentTreeNode.getRelationshipType(), documentContentTreeNode.getDocumentContent(), documentRelationship);
    }

    private void fromContent(DocumentContentTreeNode documentContentTreeNode, Content content, Map<Content, DocumentContentTreeNode> map) {
        DocumentContentTreeNode documentContentTreeNode2 = null;
        if (content.getReferencedContentItemIdentifier() != null) {
            documentContentTreeNode2 = new DocumentContentTreeNode();
            map.put(content, documentContentTreeNode2);
        } else {
            documentContentTreeNode2 = new DocumentContentTreeNode(content.getDocumentContent(), content.getRelationshipType());
            DocumentRelationship documentRelationship = content.getDocumentRelationship();
            if (documentRelationship != null) {
                documentContentTreeNode2.setObservationDateTime(documentRelationship.getObservationDateTime());
                for (Content content2 : documentRelationship.content()) {
                    this.fromContent(documentContentTreeNode2, content2, map);
                }
            }
        }
        if (documentContentTreeNode != null) {
            documentContentTreeNode.addChild(documentContentTreeNode2);
        } else {
            this.root = documentContentTreeNode2;
        }
    }

    private int[] getContentItemIdentfier(DocumentContentTreeNode object) {
        int n;
        Object object2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (object != null) {
            object2 = ((DocumentContentTreeNode)object).getParent();
            n = 1;
            if (object2 != null) {
                n = ((DocumentContentTreeNode)object2).children().indexOf(object) + 1;
            }
            arrayList.add(n);
            object = object2;
        }
        object2 = new int[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            object2[n] = (Integer)arrayList.get(arrayList.size() - 1 - n);
            ++n;
        }
        return object2;
    }

    private DocumentContentTreeNode findNode(int[] nArray) {
        DocumentContentTreeNode documentContentTreeNode = null;
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            documentContentTreeNode = documentContentTreeNode == null ? this.root : documentContentTreeNode.children().get(n3 - 1);
            ++n2;
        }
        return documentContentTreeNode;
    }

    public void setContentTemplate(ContentTemplate contentTemplate) {
        if (this.root == null) {
            return;
        }
        DocumentContent documentContent = this.root.getDocumentContent();
        if (documentContent instanceof DocumentContent.ContainerContent) {
            ((DocumentContent.ContainerContent)documentContent).setContentTemplate(contentTemplate);
        }
    }

    public ContentTemplate getContentTemplate() {
        if (this.root == null) {
            return null;
        }
        DocumentContent documentContent = this.root.getDocumentContent();
        if (documentContent instanceof DocumentContent.ContainerContent) {
            return ((DocumentContent.ContainerContent)documentContent).getContentTemplate();
        }
        return null;
    }
}

