/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.sr.content;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentContent;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentRelationship;
import com.agfa.pacs.listtext.dicomobject.type.RelationshipType;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class Content
extends AbstractDatasetSource {
    private RelationshipType relationshipType;
    private DocumentContent documentContent;
    private DocumentRelationship documentRelationship;
    private int[] referencedContentItemIdentifier;

    public Content() {
    }

    public Content(RelationshipType relationshipType, DocumentContent documentContent, DocumentRelationship documentRelationship) {
        this.relationshipType = relationshipType;
        this.documentContent = documentContent;
        this.documentRelationship = documentRelationship;
    }

    public Content(RelationshipType relationshipType, int[] nArray) {
        this.relationshipType = relationshipType;
        this.referencedContentItemIdentifier = nArray;
    }

    public Content(RelationshipType relationshipType, DocumentContent documentContent, DocumentRelationship documentRelationship, int[] nArray) {
        this.relationshipType = relationshipType;
        this.documentContent = documentContent;
        this.documentRelationship = documentRelationship;
        this.referencedContentItemIdentifier = nArray;
    }

    private Content(Attributes attributes) {
        this.relationshipType = RelationshipType.get(this.getString(attributes, 4235280));
        this.documentContent = DocumentContent.create(attributes);
        this.documentRelationship = DocumentRelationship.create(attributes);
        this.referencedContentItemIdentifier = this.getIntegers(attributes, 4250483);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.relationshipType, attributes, 4235280, DatasetAccessor.Type.Mandatory);
        if (this.referencedContentItemIdentifier == null) {
            this.set((DatasetSource)this.documentContent, attributes);
            this.set((DatasetSource)this.documentRelationship, attributes);
        } else {
            this.set(this.referencedContentItemIdentifier, attributes, 4250483, DatasetAccessor.Type.Mandatory);
        }
        return attributes;
    }

    public static Content create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(4235280)) {
            return new Content(attributes);
        }
        return null;
    }

    public static List<Content> createList(Attributes attributes, int n) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            Content content = Content.create((Attributes)sequence.get(n2));
            if (content != null) {
                arrayList.add(content);
            }
            ++n2;
        }
        return arrayList;
    }

    public DocumentContent getDocumentContent() {
        return this.documentContent;
    }

    public DocumentRelationship getDocumentRelationship() {
        return this.documentRelationship;
    }

    public int[] getReferencedContentItemIdentifier() {
        return this.referencedContentItemIdentifier;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public void setDocumentContent(DocumentContent documentContent) {
        this.documentContent = documentContent;
    }

    public void setDocumentRelationship(DocumentRelationship documentRelationship) {
        this.documentRelationship = documentRelationship;
    }

    public void setReferencedContentItemIdentifier(int[] nArray) {
        this.referencedContentItemIdentifier = nArray;
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }
}

