/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.study;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.general.PersonIdentification;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.interfaces.IStudyIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class GeneralStudyModule
extends AbstractModule
implements IStudyIdentifier {
    private String studyInstanceUID;
    private Date studyDate;
    private Date studyTime;
    private String referringPhysiciansName;
    private PersonIdentification referringPhysicianIdentification;
    private String studyID;
    private String accessionNumber;
    private String studyDescription;
    private String[] physiciansOfRecord;
    private List<PersonIdentification> physiciansOfRecordIdentification;
    private String[] physiciansReadingStudy;
    private List<PersonIdentification> physiciansReadingStudyIdentification;
    private List<ReferencedSOP> referencedStudies;
    private List<Code> procedure;

    public GeneralStudyModule() {
        super(Level.Study);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.studyInstanceUID = this.getString(attributes, 0x20000D);
        this.studyDate = this.getDate(attributes, 524320);
        this.studyTime = this.getDate(attributes, 524336);
        this.referringPhysiciansName = this.getString(attributes, 524432);
        this.referringPhysicianIdentification = PersonIdentification.create(attributes.getNestedDataset(524438));
        this.studyID = this.getString(attributes, 0x200010);
        this.accessionNumber = this.getString(attributes, 524368);
        this.studyDescription = this.getString(attributes, 528432);
        this.physiciansOfRecord = this.getStrings(attributes, 528456);
        this.physiciansOfRecordIdentification = PersonIdentification.createList(attributes, 528457);
        this.physiciansReadingStudy = this.getStrings(attributes, 528480);
        this.physiciansReadingStudyIdentification = PersonIdentification.createList(attributes, 528482);
        this.referencedStudies = ReferencedSOP.createList(attributes, 528656);
        this.procedure = Code.createList((Attributes)attributes, (int)528434);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.studyInstanceUID, attributes, 0x20000D, DatasetAccessor.Type.Mandatory);
        this.set(this.studyDate, attributes, 524320, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.studyTime, attributes, 524336, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.referringPhysiciansName, attributes, 524432, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.referringPhysicianIdentification, attributes, 524438, DatasetAccessor.Type.Optional);
        this.set(this.studyID, attributes, 0x200010, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.accessionNumber, attributes, 524368, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.studyDescription, attributes, 528432, DatasetAccessor.Type.Optional);
        this.set(this.physiciansOfRecord, attributes, 528456, DatasetAccessor.Type.Optional);
        this.set(this.physiciansOfRecordIdentification, attributes, 528457, DatasetAccessor.Type.Optional);
        this.set(this.physiciansReadingStudy, attributes, 528480, DatasetAccessor.Type.Optional);
        this.set(this.physiciansReadingStudyIdentification, attributes, 528482, DatasetAccessor.Type.Optional);
        this.set(this.referencedStudies, attributes, 528656, DatasetAccessor.Type.Optional);
        this.set(this.procedure, attributes, 528434, DatasetAccessor.Type.Optional);
    }

    @Override
    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String[] getPhysiciansOfRecord() {
        return this.physiciansOfRecord;
    }

    public List<PersonIdentification> getPhysiciansOfRecordIdentification() {
        return this.physiciansOfRecordIdentification;
    }

    public String[] getPhysiciansReadingStudy() {
        return this.physiciansReadingStudy;
    }

    public List<PersonIdentification> getPhysiciansReadingStudyIdentification() {
        return this.physiciansReadingStudyIdentification;
    }

    public List<Code> procedureCodes() {
        return this.procedure;
    }

    public List<ReferencedSOP> referencedStudies() {
        return this.referencedStudies;
    }

    public PersonIdentification getReferringPhysicianIdentification() {
        return this.referringPhysicianIdentification;
    }

    @Override
    public String getReferringPhysiciansName() {
        return this.referringPhysiciansName;
    }

    @Override
    public Date getStudyDate() {
        return this.studyDate;
    }

    public String getStudyDescription() {
        return this.studyDescription;
    }

    @Override
    public String getStudyID() {
        return this.studyID;
    }

    @Override
    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    @Override
    public Date getStudyTime() {
        return this.studyTime;
    }

    @Override
    public void setAccessionNumber(String string) {
        this.accessionNumber = string;
    }

    public void setPhysiciansOfRecord(String[] stringArray) {
        this.physiciansOfRecord = stringArray;
    }

    public void setPhysiciansOfRecordIdentification(List<PersonIdentification> list) {
        this.physiciansOfRecordIdentification = list;
    }

    public void setPhysiciansReadingStudy(String[] stringArray) {
        this.physiciansReadingStudy = stringArray;
    }

    public void setPhysiciansReadingStudyIdentification(List<PersonIdentification> list) {
        this.physiciansReadingStudyIdentification = list;
    }

    public void setReferringPhysicianIdentification(PersonIdentification personIdentification) {
        this.referringPhysicianIdentification = personIdentification;
    }

    @Override
    public void setReferringPhysiciansName(String string) {
        this.referringPhysiciansName = string;
    }

    @Override
    public void setStudyDate(Date date) {
        this.studyDate = date;
    }

    public void setStudyDescription(String string) {
        this.studyDescription = string;
    }

    @Override
    public void setStudyID(String string) {
        this.studyID = string;
    }

    @Override
    public void setStudyInstanceUID(String string) {
        this.studyInstanceUID = string;
    }

    @Override
    public void setStudyTime(Date date) {
        this.studyTime = date;
    }
}

