/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.sr;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.type.ObserverType;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class IdentifiedPersonOrDevice
extends AbstractDatasetSource {
    private ObserverType observerType;
    private String personName;
    private Code personIdentfication;
    private String stationName;
    private Code institution;
    private String institutionName;
    private String manufacturerModelName;
    private String manufacturer;
    private String deviceUID;

    public IdentifiedPersonOrDevice() {
    }

    private IdentifiedPersonOrDevice(Attributes attributes) {
        this.observerType = ObserverType.get(this.getString(attributes, 4235396));
        this.personName = this.getString(attributes, 4235555);
        this.personIdentfication = Code.create((Attributes)attributes, (int)0x401101);
        this.stationName = this.getString(attributes, 528400);
        this.deviceUID = this.getString(attributes, 1576962);
        this.manufacturer = this.getString(attributes, 524400);
        this.manufacturerModelName = this.getString(attributes, 528528);
        this.institutionName = this.getString(attributes, 524416);
        this.institution = Code.create((Attributes)attributes, (int)524418);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.observerType, attributes, 4235396, DatasetAccessor.Type.Mandatory);
        this.set(this.institutionName, attributes, 524416, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.institution, attributes, 524418, DatasetAccessor.Type.MandatoryOrEmpty);
        switch (this.observerType) {
            case Person: {
                this.set(this.personName, attributes, 4235555, DatasetAccessor.Type.Mandatory);
                this.set((DatasetSource)this.personIdentfication, attributes, 0x401101, DatasetAccessor.Type.MandatoryOrEmpty);
                break;
            }
            case Device: {
                this.set(this.stationName, attributes, 528400, DatasetAccessor.Type.MandatoryOrEmpty);
                this.set(this.deviceUID, attributes, 1576962, DatasetAccessor.Type.Mandatory);
                this.set(this.manufacturer, attributes, 524400, DatasetAccessor.Type.Mandatory);
                this.set(this.manufacturerModelName, attributes, 528528, DatasetAccessor.Type.Mandatory);
            }
        }
        return attributes;
    }

    public static IdentifiedPersonOrDevice create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(4235396)) {
            return new IdentifiedPersonOrDevice(attributes);
        }
        return null;
    }

    public static IdentifiedPersonOrDevice create(Attributes attributes, int n) {
        try {
            return IdentifiedPersonOrDevice.create(attributes.getNestedDataset(n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<IdentifiedPersonOrDevice> createList(Attributes attributes, int n) {
        ArrayList<IdentifiedPersonOrDevice> arrayList = new ArrayList<IdentifiedPersonOrDevice>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            IdentifiedPersonOrDevice identifiedPersonOrDevice = IdentifiedPersonOrDevice.create((Attributes)sequence.get(n2));
            if (identifiedPersonOrDevice != null) {
                arrayList.add(identifiedPersonOrDevice);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getDeviceUID() {
        return this.deviceUID;
    }

    public Code getInstitution() {
        return this.institution;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getManufacturerModelName() {
        return this.manufacturerModelName;
    }

    public ObserverType getObserverType() {
        return this.observerType;
    }

    public Code getPersonIdentfication() {
        return this.personIdentfication;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setDeviceUID(String string) {
        this.deviceUID = string;
    }

    public void setInstitution(Code code) {
        this.institution = code;
    }

    public void setInstitutionName(String string) {
        this.institutionName = string;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public void setManufacturerModelName(String string) {
        this.manufacturerModelName = string;
    }

    public void setObserverType(ObserverType observerType) {
        this.observerType = observerType;
    }

    public void setPersonIdentfication(Code code) {
        this.personIdentfication = code;
    }

    public void setPersonName(String string) {
        this.personName = string;
    }

    public void setStationName(String string) {
        this.stationName = string;
    }
}

