/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.lut.DicomLookupTable;
import com.agfa.pacs.listtext.dicomobject.lut.IColorLookupTableSource;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTable;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import org.dcm4che3.data.Attributes;

public class PaletteColorLUTModule
extends AbstractModule
implements IColorLookupTableSource {
    private String paletteColorLookupTableUID;
    private int[] redPaletteColorLookupTableDescriptor;
    private int[] greenPaletteColorLookupTableDescriptor;
    private int[] bluePaletteColorLookupTableDescriptor;
    private byte[] redPaletteColorLookupTableData;
    private byte[] greenPaletteColorLookupTableData;
    private byte[] bluePaletteColorLookupTableData;
    private byte[] segmentedRedPaletteColorLookupTableData;
    private byte[] segmentedGreenPaletteColorLookupTableData;
    private byte[] segmentedBluePaletteColorLookupTableData;

    public PaletteColorLUTModule() {
        super(Level.Object);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static boolean hasLookupTable(Attributes attributes) {
        if (attributes.contains(2625793)) {
            byte[] byArray = null;
            try {
                byArray = attributes.getBytes(2626049);
            }
            catch (IOException iOException) {
                ALogger.getLogger(PaletteColorLUTModule.class).error("Bulk error data", (Throwable)iOException);
            }
            return byArray != null && byArray.length > 2;
        }
        return false;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.paletteColorLookupTableUID = this.getString(attributes, 2625945);
        this.redPaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625793);
        this.greenPaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625794);
        this.bluePaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625795);
        try {
            this.redPaletteColorLookupTableData = attributes.getBytes(2626049);
            this.greenPaletteColorLookupTableData = attributes.getBytes(2626050);
            this.bluePaletteColorLookupTableData = attributes.getBytes(2626051);
            this.segmentedRedPaletteColorLookupTableData = attributes.getBytes(0x281221);
            this.segmentedGreenPaletteColorLookupTableData = attributes.getBytes(0x281222);
            this.segmentedBluePaletteColorLookupTableData = attributes.getBytes(2626083);
        }
        catch (IOException iOException) {
            ALogger.getLogger(PaletteColorLUTModule.class).error("Bulk data error", (Throwable)iOException);
        }
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.paletteColorLookupTableUID, attributes, 2625945, DatasetAccessor.Type.Optional);
        this.set(this.redPaletteColorLookupTableDescriptor, attributes, 2625793, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.greenPaletteColorLookupTableDescriptor, attributes, 2625794, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.bluePaletteColorLookupTableDescriptor, attributes, 2625795, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.redPaletteColorLookupTableData, attributes, 2626049, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.greenPaletteColorLookupTableData, attributes, 2626050, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.bluePaletteColorLookupTableData, attributes, 2626051, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.segmentedRedPaletteColorLookupTableData, attributes, 0x281221, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.segmentedGreenPaletteColorLookupTableData, attributes, 0x281222, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.segmentedBluePaletteColorLookupTableData, attributes, 2626083, DatasetAccessor.Type.ConditionalMandatory);
    }

    public byte[] getBluePaletteColorLookupTableData() {
        return this.bluePaletteColorLookupTableData;
    }

    public void setBluePaletteColorLookupTableData(byte[] byArray) {
        this.bluePaletteColorLookupTableData = byArray;
    }

    public int[] getBluePaletteColorLookupTableDescriptor() {
        return this.bluePaletteColorLookupTableDescriptor;
    }

    public void setBluePaletteColorLookupTableDescriptor(int[] nArray) {
        this.bluePaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getGreenPaletteColorLookupTableData() {
        return this.greenPaletteColorLookupTableData;
    }

    public void setGreenPaletteColorLookupTableData(byte[] byArray) {
        this.greenPaletteColorLookupTableData = byArray;
    }

    public int[] getGreenPaletteColorLookupTableDescriptor() {
        return this.greenPaletteColorLookupTableDescriptor;
    }

    public void setGreenPaletteColorLookupTableDescriptor(int[] nArray) {
        this.greenPaletteColorLookupTableDescriptor = nArray;
    }

    public String getPaletteColorLookupTableUID() {
        return this.paletteColorLookupTableUID;
    }

    public void setPaletteColorLookupTableUID(String string) {
        this.paletteColorLookupTableUID = string;
    }

    public byte[] getRedPaletteColorLookupTableData() {
        return this.redPaletteColorLookupTableData;
    }

    public void setRedPaletteColorLookupTableData(byte[] byArray) {
        this.redPaletteColorLookupTableData = byArray;
    }

    public int[] getRedPaletteColorLookupTableDescriptor() {
        return this.redPaletteColorLookupTableDescriptor;
    }

    public void setRedPaletteColorLookupTableDescriptor(int[] nArray) {
        this.redPaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getSegmentedBluePaletteColorLookupTableData() {
        return this.segmentedBluePaletteColorLookupTableData;
    }

    public void setSegmentedBluePaletteColorLookupTableData(byte[] byArray) {
        this.segmentedBluePaletteColorLookupTableData = byArray;
    }

    public byte[] getSegmentedGreenPaletteColorLookupTableData() {
        return this.segmentedGreenPaletteColorLookupTableData;
    }

    public void setSegmentedGreenPaletteColorLookupTableData(byte[] byArray) {
        this.segmentedGreenPaletteColorLookupTableData = byArray;
    }

    public byte[] getSegmentedRedPaletteColorLookupTableData() {
        return this.segmentedRedPaletteColorLookupTableData;
    }

    public void setSegmentedRedPaletteColorLookupTableData(byte[] byArray) {
        this.segmentedRedPaletteColorLookupTableData = byArray;
    }

    @Override
    public ILookupTable getLookupTable(IColorLookupTableSource.Channel channel) {
        switch (channel) {
            case Red: {
                return new DicomLookupTable(this.redPaletteColorLookupTableDescriptor, this.redPaletteColorLookupTableData, this.segmentedRedPaletteColorLookupTableData, channel.toString());
            }
            case Green: {
                return new DicomLookupTable(this.greenPaletteColorLookupTableDescriptor, this.greenPaletteColorLookupTableData, this.segmentedGreenPaletteColorLookupTableData, channel.toString());
            }
            case Blue: {
                return new DicomLookupTable(this.bluePaletteColorLookupTableDescriptor, this.bluePaletteColorLookupTableData, this.segmentedBluePaletteColorLookupTableData, channel.toString());
            }
        }
        return null;
    }

    @Override
    public boolean hasLookupTable() {
        return this.redPaletteColorLookupTableDescriptor != null && this.greenPaletteColorLookupTableDescriptor != null && this.bluePaletteColorLookupTableDescriptor != null;
    }

    @Override
    public void setTo(IColorLookupTableSource.Channel channel, ILookupTable iLookupTable) {
        switch (channel) {
            case Red: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.redPaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedRedPaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.redPaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            case Green: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.greenPaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedGreenPaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.greenPaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            case Blue: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.bluePaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedBluePaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.bluePaletteColorLookupTableData = dicomLookupTable.getLUTData();
            }
        }
    }
}

