/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import java.util.HashMap;
import org.dcm4che3.data.Attributes;

public class OverlayCurveActivationModule
extends AbstractModule {
    private HashMap<Integer, String> overlayActivationLayer = new HashMap();
    private HashMap<Integer, String> curveActivationLayer = new HashMap();

    public OverlayCurveActivationModule() {
        super(Level.Object);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2;
            int n3 = n2 << 16;
            if (attributes.contains(0x60001001 + n3)) {
                return true;
            }
            if (attributes.contains(0x50001001 + n3)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void readFrom(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2;
            int n3 = n2 << 16;
            this.overlayActivationLayer.put(n2, this.getString(attributes, 0x60001001 + n3));
            this.curveActivationLayer.put(n2, this.getString(attributes, 0x50001001 + n3));
            ++n;
        }
    }

    @Override
    public void writeTo(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2;
            int n3 = n2 << 16;
            String string = this.overlayActivationLayer.get(n2);
            String string2 = this.curveActivationLayer.get(n2);
            this.set(string, attributes, 0x60001001 + n3, DatasetAccessor.Type.MandatoryOrEmpty);
            this.set(string2, attributes, 0x50001001 + n3, DatasetAccessor.Type.MandatoryOrEmpty);
            ++n;
        }
    }

    public String getOverlayActivationLayer(int n) {
        return this.overlayActivationLayer.get(n);
    }

    public String getCurveActivationLayer(int n) {
        return this.curveActivationLayer.get(n);
    }

    public void setOverlayActivationLayer(int n, String string) {
        this.overlayActivationLayer.put(n, string);
    }

    public void setCurveActivationLayer(int n, String string) {
        this.curveActivationLayer.put(n, string);
    }
}

