/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import java.util.HashMap;
import org.dcm4che3.data.Attributes;

public class MultiframeOverlayPlaneModule
extends AbstractModule {
    private HashMap<Integer, Integer> numberOfFramesInOverlay = new HashMap();
    private HashMap<Integer, Integer> imageFrameOrigin = new HashMap();

    public MultiframeOverlayPlaneModule() {
        super(Level.Object);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2;
            int n3 = n2 << 16;
            if (attributes.contains(1610612757 + n3)) {
                return true;
            }
            if (attributes.contains(1610612817 + n3)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void readFrom(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2;
            int n3 = n2 << 16;
            this.numberOfFramesInOverlay.put(n2, this.getInteger(attributes, 1610612757 + n3));
            this.imageFrameOrigin.put(n2, this.getInteger(attributes, 1610612817 + n3));
            ++n;
        }
    }

    @Override
    public void writeTo(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2;
            int n3 = n2 << 16;
            Integer n4 = this.numberOfFramesInOverlay.get(n2);
            Integer n5 = this.imageFrameOrigin.get(n2);
            this.set(n4, attributes, 1610612757 + n3, DatasetAccessor.Type.Mandatory);
            this.set(n5, attributes, 1610612817 + n3, DatasetAccessor.Type.Optional);
            ++n;
        }
    }

    public Integer getNumberOfFramesInOverlay(int n) {
        return this.numberOfFramesInOverlay.get(n);
    }

    public Integer getImageFrameOrigin(int n) {
        return this.imageFrameOrigin.get(n);
    }
}

