/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.lut.IRescaleSlopeInterceptProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLookupTable;
import com.agfa.pacs.listtext.dicomobject.module.ps.RescaleType;
import com.agfa.pacs.logging.ALogger;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.data.Attributes;

public class ModalityLUT
extends AbstractDatasetSource
implements IRescaleSlopeInterceptProvider {
    private static final ALogger log = ALogger.getLogger(ModalityLUT.class);
    private ModalityLookupTable modalityLookupTable;
    private RescaleType rescaleType;
    private Double rescaleIntercept;
    private Double rescaleSlope;

    public ModalityLUT() {
    }

    public ModalityLUT(IRescaleSlopeInterceptProvider iRescaleSlopeInterceptProvider) {
        this.rescaleIntercept = iRescaleSlopeInterceptProvider.getRescaleIntercept();
        this.rescaleSlope = iRescaleSlopeInterceptProvider.getRescaleSlope();
        this.rescaleType = iRescaleSlopeInterceptProvider.getRescaleType();
    }

    public static ModalityLUT create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.containsValue(2625618) && attributes.containsValue(2625619)) {
            ModalityLUT modalityLUT = new ModalityLUT();
            try {
                modalityLUT.rescaleIntercept = attributes.getDouble(2625618, 0.0);
                modalityLUT.rescaleSlope = attributes.getDouble(2625619, 1.0);
                modalityLUT.rescaleType = RescaleType.get(attributes.getString(2625620));
                return modalityLUT;
            }
            catch (Exception exception) {
                log.error("Could not parse Modality LUT", (Throwable)exception);
                return null;
            }
        }
        if (attributes.contains(2633728)) {
            ModalityLUT modalityLUT;
            block9: {
                String string = attributes.getString(524310);
                if ("1.2.840.10008.5.1.4.1.1.12.1".equals(string) || "1.2.840.10008.5.1.4.1.1.12.2".equals(string) || "1.2.840.10008.5.1.4.1.1.12.3".equals(string)) {
                    return null;
                }
                modalityLUT = new ModalityLUT();
                try {
                    modalityLUT.modalityLookupTable = ModalityLookupTable.create(attributes.getNestedDataset(2633728));
                    modalityLUT.rescaleType = RescaleType.get(attributes.getString(2625620));
                    int n = attributes.getInt(2621697, 16);
                    if (modalityLUT.modalityLookupTable.lutDescriptor[1] <= 1 << n) break block9;
                    log.error("Incorrect modality LUT");
                    return null;
                }
                catch (Exception exception) {
                    log.error("Could not parse Modality LUT", (Throwable)exception);
                    return null;
                }
            }
            return modalityLUT;
        }
        return null;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        if (this.modalityLookupTable != null) {
            this.set((DatasetSource)this.modalityLookupTable, attributes, 2633728, DatasetAccessor.Type.Mandatory);
        } else {
            this.set(this.rescaleIntercept, attributes, 2625618, DatasetAccessor.Type.Mandatory);
            this.set(this.rescaleSlope, attributes, 2625619, DatasetAccessor.Type.Mandatory);
            this.set(this.rescaleType, attributes, 2625620, DatasetAccessor.Type.Mandatory);
        }
        return attributes;
    }

    public ModalityLookupTable getModalityLookupTable() {
        return this.modalityLookupTable;
    }

    @Override
    public Double getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    @Override
    public Double getRescaleSlope() {
        return this.rescaleSlope;
    }

    @Override
    public RescaleType getRescaleType() {
        return this.rescaleType;
    }

    public void setModalityLookupTable(ModalityLookupTable modalityLookupTable) {
        this.modalityLookupTable = modalityLookupTable;
    }

    @Override
    public void setRescaleIntercept(Double d) {
        this.rescaleIntercept = d;
    }

    @Override
    public void setRescaleSlope(Double d) {
        this.rescaleSlope = d;
    }

    @Override
    public void setRescaleType(RescaleType rescaleType) {
        this.rescaleType = rescaleType;
    }

    @Override
    public boolean hasSlopeIntercept() {
        return this.rescaleSlope != null && this.rescaleIntercept != null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ModalityLUT)) {
            return false;
        }
        ModalityLUT modalityLUT = (ModalityLUT)object;
        if (this.modalityLookupTable != null) {
            return this.modalityLookupTable.equals(modalityLUT.modalityLookupTable);
        }
        if (this.rescaleIntercept != null ? !this.rescaleIntercept.equals(modalityLUT.rescaleIntercept) : modalityLUT.rescaleIntercept != null) {
            return false;
        }
        if (this.rescaleSlope != null ? !this.rescaleSlope.equals(modalityLUT.rescaleSlope) : modalityLUT.rescaleSlope != null) {
            return false;
        }
        return !(this.rescaleType != null ? !this.rescaleType.equals(modalityLUT.rescaleType) : modalityLUT.rescaleType != null);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

