/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.ShutterShape;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class DisplayShutterModule
extends AbstractModule {
    private List<ShutterShape> shutterShape = new ArrayList<ShutterShape>();
    private Integer shutterRightVerticalEdge;
    private Integer shutterLeftVerticalEdge;
    private Integer shutterUpperHorizontalEdge;
    private Integer shutterLowerHorizontalEdge;
    private int[] centerOfCircularShutter;
    private Integer radiusOfCircularShutter;
    private int[] verticesOfPolygonalShutter;
    private Integer shutterPresentationValue;
    private int[] shutterPresentationColorCIELabValue;

    @Override
    public boolean isValid() {
        return true;
    }

    public DisplayShutterModule() {
        super(Level.Object);
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return DisplayShutterModule.isModuleAvailable(attributes);
    }

    public static boolean isModuleAvailable(Attributes attributes) {
        if (attributes.containsValue(1578496)) {
            String string = attributes.getString(1578496);
            return string.length() > 0;
        }
        return false;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.shutterShape = ShutterShape.getList(this.getStrings(attributes, 1578496));
        this.shutterLeftVerticalEdge = this.getInteger(attributes, 1578498);
        this.shutterRightVerticalEdge = this.getInteger(attributes, 1578500);
        this.shutterUpperHorizontalEdge = this.getInteger(attributes, 1578502);
        this.shutterLowerHorizontalEdge = this.getInteger(attributes, 1578504);
        this.centerOfCircularShutter = this.getIntegers(attributes, 1578512);
        this.radiusOfCircularShutter = this.getInteger(attributes, 1578514);
        this.verticesOfPolygonalShutter = this.getIntegers(attributes, 1578528);
        this.shutterPresentationValue = this.getInteger(attributes, 1578530);
        this.shutterPresentationColorCIELabValue = this.getIntegers(attributes, 1578532);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.shutterShape, attributes, 1578496, DatasetAccessor.Type.Mandatory);
        if (this.shutterShape.contains((Object)ShutterShape.Rectangular)) {
            this.set(this.shutterLeftVerticalEdge, attributes, 1578498, DatasetAccessor.Type.Mandatory);
            this.set(this.shutterRightVerticalEdge, attributes, 1578500, DatasetAccessor.Type.Mandatory);
            this.set(this.shutterUpperHorizontalEdge, attributes, 1578502, DatasetAccessor.Type.Mandatory);
            this.set(this.shutterLowerHorizontalEdge, attributes, 1578504, DatasetAccessor.Type.Mandatory);
        }
        if (this.shutterShape.contains((Object)ShutterShape.Circular)) {
            this.set(this.centerOfCircularShutter, attributes, 1578512, DatasetAccessor.Type.Mandatory);
            this.set(this.radiusOfCircularShutter, attributes, 1578514, DatasetAccessor.Type.Mandatory);
        }
        if (this.shutterShape.contains((Object)ShutterShape.Polygonal)) {
            this.set(this.verticesOfPolygonalShutter, attributes, 1578528, DatasetAccessor.Type.ConditionalMandatory);
        }
        this.set(this.shutterPresentationValue, attributes, 1578530, DatasetAccessor.Type.Optional);
        this.set(this.shutterPresentationColorCIELabValue, attributes, 1578532, DatasetAccessor.Type.Optional);
    }

    public int[] getCenterOfCircularShutter() {
        return this.centerOfCircularShutter;
    }

    public Integer getRadiusOfCircularShutter() {
        return this.radiusOfCircularShutter;
    }

    public Integer getShutterLeftVerticalEdge() {
        return this.shutterLeftVerticalEdge;
    }

    public Integer getShutterLowerHorizontalEdge() {
        return this.shutterLowerHorizontalEdge;
    }

    public Integer getShutterPresentationValue() {
        return this.shutterPresentationValue;
    }

    public Integer getShutterRightVerticalEdge() {
        return this.shutterRightVerticalEdge;
    }

    public List<ShutterShape> shutterShapes() {
        return this.shutterShape;
    }

    public Integer getShutterUpperHorizontalEdge() {
        return this.shutterUpperHorizontalEdge;
    }

    public int[] getVerticesOfPolygonalShutter() {
        return this.verticesOfPolygonalShutter;
    }

    public int[] getShutterPresentationColorCIELabValue() {
        return this.shutterPresentationColorCIELabValue;
    }

    public void setCenterOfCircularShutter(int[] nArray) {
        this.centerOfCircularShutter = nArray;
    }

    public void setRadiusOfCircularShutter(Integer n) {
        this.radiusOfCircularShutter = n;
    }

    public void setShutterLeftVerticalEdge(Integer n) {
        this.shutterLeftVerticalEdge = n;
    }

    public void setShutterLowerHorizontalEdge(Integer n) {
        this.shutterLowerHorizontalEdge = n;
    }

    public void setShutterPresentationColorCIELabValue(int[] nArray) {
        this.shutterPresentationColorCIELabValue = nArray;
    }

    public void setShutterPresentationValue(Integer n) {
        this.shutterPresentationValue = n;
    }

    public void setShutterRightVerticalEdge(Integer n) {
        this.shutterRightVerticalEdge = n;
    }

    public void setShutterUpperHorizontalEdge(Integer n) {
        this.shutterUpperHorizontalEdge = n;
    }

    public void setVerticesOfPolygonalShutter(int[] nArray) {
        this.verticesOfPolygonalShutter = nArray;
    }
}

