/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.patient;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class PertinentDocument
extends AbstractDatasetSource {
    private String studyInstanceUID;
    private String seriesInstanceUID;
    private List<Code> purposeOfReference;
    private String documentTitle;

    private PertinentDocument(Attributes attributes) {
        this.studyInstanceUID = this.getString(attributes, 0x20000D);
        this.seriesInstanceUID = this.getString(attributes, 0x20000E);
        this.purposeOfReference = Code.createList((Attributes)attributes, (int)4235632);
        this.documentTitle = this.getString(attributes, 4325392);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.studyInstanceUID, attributes, 0x20000D, DatasetAccessor.Type.Mandatory);
        this.set(this.seriesInstanceUID, attributes, 0x20000E, DatasetAccessor.Type.Mandatory);
        this.set(this.purposeOfReference, attributes, 4235632, DatasetAccessor.Type.Mandatory);
        this.set(this.documentTitle, attributes, 4325392, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public static PertinentDocument create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x20000D) && attributes.contains(0x20000E)) {
            return new PertinentDocument(attributes);
        }
        return null;
    }

    public static List<PertinentDocument> createList(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        ArrayList<PertinentDocument> arrayList = new ArrayList<PertinentDocument>();
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            PertinentDocument pertinentDocument = PertinentDocument.create((Attributes)sequence.get(n2));
            if (pertinentDocument != null) {
                arrayList.add(pertinentDocument);
            }
            ++n2;
        }
        return arrayList;
    }

    public List<Code> getPurposeOfReference() {
        return this.purposeOfReference;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }
}

