/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.patient;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.module.patient.PatientIDType;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class PatientID
extends AbstractDatasetSource {
    private String patientID;
    private String issuerOfPatientID;
    private PatientIDType patientIDType;

    public PatientID() {
    }

    public PatientID(Attributes attributes) {
        this.patientID = this.getString(attributes, 0x100020);
        this.issuerOfPatientID = this.getString(attributes, 0x100021);
        this.patientIDType = PatientIDType.get(this.getString(attributes, 0x100022));
    }

    public static PatientID create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new PatientID(attributes);
    }

    public static List<PatientID> createList(Attributes attributes, int n) {
        ArrayList<PatientID> arrayList = new ArrayList<PatientID>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            PatientID patientID = PatientID.create((Attributes)sequence.get(n2));
            if (patientID != null) {
                arrayList.add(patientID);
            }
            ++n2;
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.patientID, attributes, 0x100020, DatasetAccessor.Type.Mandatory);
        this.set(this.issuerOfPatientID, attributes, 0x100021, DatasetAccessor.Type.Mandatory);
        this.set(this.patientIDType, attributes, 0x100022, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public void setIssuerOfPatientID(String string) {
        this.issuerOfPatientID = string;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public void setPatientID(String string) {
        this.patientID = string;
    }

    public PatientIDType getPatientIDType() {
        return this.patientIDType;
    }

    public void setPatientIDType(PatientIDType patientIDType) {
        this.patientIDType = patientIDType;
    }
}

