/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.patient;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import org.dcm4che3.data.Attributes;

public class ClinicalTrialSubjectModule
extends AbstractModule {
    private String sponsorName;
    private String protocolID;
    private String protocolName;
    private String siteID;
    private String siteName;
    private String subjectID;
    private String subjectReadingID;

    public ClinicalTrialSubjectModule() {
        super(Level.Patient);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(0x120010) && attributes.contains(0x120020);
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.sponsorName = this.getString(attributes, 0x120010);
        this.protocolID = this.getString(attributes, 0x120020);
        this.protocolName = this.getString(attributes, 0x120021);
        this.siteID = this.getString(attributes, 1179696);
        this.siteName = this.getString(attributes, 1179697);
        this.subjectID = this.getString(attributes, 1179712);
        this.subjectReadingID = this.getString(attributes, 1179714);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.sponsorName, attributes, 0x120010, DatasetAccessor.Type.Mandatory);
        this.set(this.protocolID, attributes, 0x120020, DatasetAccessor.Type.Mandatory);
        this.set(this.protocolName, attributes, 0x120021, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.siteID, attributes, 1179696, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.siteName, attributes, 1179697, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.subjectID, attributes, 1179712, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.subjectReadingID, attributes, 1179714, DatasetAccessor.Type.MandatoryOrEmpty);
    }

    public String getProtocolID() {
        return this.protocolID;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getSiteID() {
        return this.siteID;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public String getSubjectID() {
        return this.subjectID;
    }

    public String getSubjectReadingID() {
        return this.subjectReadingID;
    }
}

