/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.listtext.dicomobject.general.PersonIdentification;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ScheduledProcedureStepStatus;
import com.agfa.pacs.listtext.dicomobject.module.series.Protocol;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ScheduledProcedureStep
extends AbstractDatasetSource {
    private String stationAETitle;
    private String stationName;
    private String location;
    private Date startDate;
    private Date startTime;
    private Date endDate;
    private Date endTime;
    private String performingPhysiciansName;
    private PersonIdentification performingPhysicianIdentification;
    private String description;
    private List<Protocol> protocol;
    private String id;
    private ScheduledProcedureStepStatus status;
    private String comments;
    private String modality;
    private String requestedContastAgent;
    private String preMedication;

    public ScheduledProcedureStep(Attributes attributes) {
        this.stationAETitle = this.getString(attributes, 0x400001);
        this.stationName = this.getString(attributes, 0x400010);
        this.location = this.getString(attributes, 0x400011);
        this.startDate = this.getDate(attributes, 0x400002);
        this.startTime = this.getDate(attributes, 0x400003);
        this.endDate = this.getDate(attributes, 0x400004);
        this.endTime = this.getDate(attributes, 0x400005);
        this.performingPhysiciansName = this.getString(attributes, 0x400006);
        this.performingPhysicianIdentification = PersonIdentification.create(attributes.getNestedDataset(0x40000B));
        this.description = this.getString(attributes, 0x400007);
        this.protocol = Protocol.createList(attributes, 0x400008);
        this.id = this.getString(attributes, 0x400009);
        this.status = ScheduledProcedureStepStatus.get(this.getString(attributes, 0x400020));
        this.comments = this.getString(attributes, 0x400400);
        this.modality = this.getString(attributes, 524384);
        this.requestedContastAgent = this.getString(attributes, 3281008);
        this.preMedication = this.getString(attributes, 4194322);
    }

    public Attributes toDataset() {
        return null;
    }

    public static ScheduledProcedureStep create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new ScheduledProcedureStep(attributes);
    }

    public static List<ScheduledProcedureStep> createList(Attributes attributes, int n) {
        ArrayList<ScheduledProcedureStep> arrayList = new ArrayList<ScheduledProcedureStep>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ScheduledProcedureStep scheduledProcedureStep = ScheduledProcedureStep.create((Attributes)sequence.get(n2));
            if (scheduledProcedureStep != null) {
                arrayList.add(scheduledProcedureStep);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getComments() {
        return this.comments;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getID() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModality() {
        return this.modality;
    }

    public PersonIdentification getPerformingPhysicianIdentification() {
        return this.performingPhysicianIdentification;
    }

    public String getPerformingPhysiciansName() {
        return this.performingPhysiciansName;
    }

    public String getPreMedication() {
        return this.preMedication;
    }

    public List<Protocol> protocols() {
        return this.protocol;
    }

    public String getRequestedContastAgent() {
        return this.requestedContastAgent;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getStationAETitle() {
        return this.stationAETitle;
    }

    public String getStationName() {
        return this.stationName;
    }

    public ScheduledProcedureStepStatus getStatus() {
        return this.status;
    }
}

