/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.dicomobject.general.PersonIdentification;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ReportingPriority;
import com.agfa.pacs.listtext.dicomobject.module.mwl.RequestedProcedurePriority;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class RequestedProcedureModule
extends AbstractModule {
    private String id;
    private String reason;
    private String comments;
    private Code reasonCode;
    private Code code;
    private String studyInstanceUID;
    private Date studyDate;
    private Date studyTime;
    private List<ReferencedSOP> referencededStudies;
    private String description;
    private RequestedProcedurePriority priority;
    private String patientTransportArrangements;
    private String location;
    private String confidentalityCode;
    private ReportingPriority reportingPriority;
    private String[] namesOfIntendedRecipientsOfResults;
    private List<PersonIdentification> intendedRecipientsOfResultsIdentifications;

    public RequestedProcedureModule() {
        super(null);
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(0x401001);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.id = this.getString(attributes, 0x401001);
        this.reason = this.getString(attributes, 4198402);
        this.comments = this.getString(attributes, 0x401400);
        this.reasonCode = Code.create((Attributes)attributes, (int)4198410);
        this.code = Code.create((Attributes)attributes, (int)3280996);
        this.studyInstanceUID = this.getString(attributes, 0x20000D);
        this.studyDate = this.getDate(attributes, 524320);
        this.studyTime = this.getDate(attributes, 524336);
        this.referencededStudies = ReferencedSOP.createList(attributes, 528656);
        this.description = this.getString(attributes, 3280992);
        this.priority = RequestedProcedurePriority.get(this.getString(attributes, 4198403));
        this.patientTransportArrangements = this.getString(attributes, 0x401004);
        this.location = this.getString(attributes, 4198405);
        this.confidentalityCode = this.getString(attributes, 4198408);
        this.reportingPriority = ReportingPriority.get(this.getString(attributes, 4198409));
        this.namesOfIntendedRecipientsOfResults = this.getStrings(attributes, 0x401010);
        this.intendedRecipientsOfResultsIdentifications = PersonIdentification.createList(attributes, 0x401011);
    }

    @Override
    public void writeTo(Attributes attributes) {
    }

    public Code getCode() {
        return this.code;
    }

    public String getComments() {
        return this.comments;
    }

    public String getConfidentalityCode() {
        return this.confidentalityCode;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public List<PersonIdentification> intendedRecipientsOfResultsIdentifications() {
        return this.intendedRecipientsOfResultsIdentifications;
    }

    public String getLocation() {
        return this.location;
    }

    public String[] getNamesOfIntendedRecipientsOfResults() {
        return this.namesOfIntendedRecipientsOfResults;
    }

    public String getPatientTransportArrangements() {
        return this.patientTransportArrangements;
    }

    public RequestedProcedurePriority getPriority() {
        return this.priority;
    }

    public String getReason() {
        return this.reason;
    }

    public Code getReasonCode() {
        return this.reasonCode;
    }

    public List<ReferencedSOP> referencededStudies() {
        return this.referencededStudies;
    }

    public ReportingPriority getReportingPriority() {
        return this.reportingPriority;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public void setConfidentalityCode(String string) {
        this.confidentalityCode = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setID(String string) {
        this.id = string;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setNamesOfIntendedRecipientsOfResults(String[] stringArray) {
        this.namesOfIntendedRecipientsOfResults = stringArray;
    }

    public void setPatientTransportArrangements(String string) {
        this.patientTransportArrangements = string;
    }

    public void setPriority(RequestedProcedurePriority requestedProcedurePriority) {
        this.priority = requestedProcedurePriority;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public void setReasonCode(Code code) {
        this.reasonCode = code;
    }

    public void setReportingPriority(ReportingPriority reportingPriority) {
        this.reportingPriority = reportingPriority;
    }

    public void setStudyInstanceUID(String string) {
        this.studyInstanceUID = string;
    }

    public Date getStudyDate() {
        return this.studyDate;
    }

    public Date getStudyTime() {
        return this.studyTime;
    }
}

