/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ExposureDose;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class RadiationDoseModule
extends AbstractModule {
    private Code anatomicStructureSpaceOrRegion;
    private Integer totalTimeOfFluoruscopy;
    private Integer totalNumberOfExposures;
    private Double distanceSourceToDetector;
    private Double distanceSourceToEntrance;
    private Integer entranceDose;
    private Double entranceDose_mGy;
    private int[] exposedArea;
    private Double imageAndFluoroscopyAreaDoseProduct;
    private String commentsOnRadiationDose;
    private List<ExposureDose> exposureDose = new ArrayList<ExposureDose>();

    public RadiationDoseModule() {
        super(null);
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.anatomicStructureSpaceOrRegion = Code.create((Attributes)attributes, (int)533033);
        this.totalTimeOfFluoruscopy = this.getInteger(attributes, 0x400300);
        this.totalNumberOfExposures = this.getInteger(attributes, 4195073);
        this.distanceSourceToDetector = this.getDouble(attributes, 0x181110);
        this.distanceSourceToEntrance = this.getDouble(attributes, 4195078);
        this.entranceDose = this.getInteger(attributes, 4195074);
        this.entranceDose_mGy = this.getDouble(attributes, 4227842);
        this.exposedArea = this.getIntegers(attributes, 0x400303);
        this.imageAndFluoroscopyAreaDoseProduct = this.getDouble(attributes, 1577310);
        this.commentsOnRadiationDose = this.getString(attributes, 4195088);
        this.exposureDose = ExposureDose.createList(attributes, 4195086);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set((DatasetSource)this.anatomicStructureSpaceOrRegion, attributes, 533033, DatasetAccessor.Type.Optional);
        this.set(this.totalTimeOfFluoruscopy, attributes, 0x400300, DatasetAccessor.Type.Optional);
        this.set(this.totalNumberOfExposures, attributes, 4195073, DatasetAccessor.Type.Optional);
        this.set(this.distanceSourceToDetector, attributes, 0x181110, DatasetAccessor.Type.Optional);
        this.set(this.distanceSourceToEntrance, attributes, 4195078, DatasetAccessor.Type.Optional);
        this.set(this.entranceDose, attributes, 4195074, DatasetAccessor.Type.Optional);
        this.set(this.entranceDose_mGy, attributes, 4227842, DatasetAccessor.Type.Optional);
        this.set(this.exposedArea, attributes, 0x400303, DatasetAccessor.Type.Optional);
        this.set(this.imageAndFluoroscopyAreaDoseProduct, attributes, 1577310, DatasetAccessor.Type.Optional);
        this.set(this.commentsOnRadiationDose, attributes, 4195088, DatasetAccessor.Type.Optional);
        this.set(this.exposureDose, attributes, 4195086, DatasetAccessor.Type.Optional);
    }

    public Code getAnatomicStructureSpaceOrRegion() {
        return this.anatomicStructureSpaceOrRegion;
    }

    public void setAnatomicStructureSpaceOrRegion(Code code) {
        this.anatomicStructureSpaceOrRegion = code;
    }

    public String getCommentsOnRadiationDose() {
        return this.commentsOnRadiationDose;
    }

    public void setCommentsOnRadiationDose(String string) {
        this.commentsOnRadiationDose = string;
    }

    public Double getDistanceSourceToDetector() {
        return this.distanceSourceToDetector;
    }

    public void setDistanceSourceToDetector(Double d) {
        this.distanceSourceToDetector = d;
    }

    public Double getDistanceSourceToEntrance() {
        return this.distanceSourceToEntrance;
    }

    public void setDistanceSourceToEntrance(Double d) {
        this.distanceSourceToEntrance = d;
    }

    public Integer getEntranceDose() {
        return this.entranceDose;
    }

    public void setEntranceDose(Integer n) {
        this.entranceDose = n;
    }

    public Double getEntranceDose_mGy() {
        return this.entranceDose_mGy;
    }

    public void setEntranceDose_mGy(Double d) {
        this.entranceDose_mGy = d;
    }

    public int[] getExposedArea() {
        return this.exposedArea;
    }

    public void setExposedArea(int[] nArray) {
        this.exposedArea = nArray;
    }

    public List<ExposureDose> exposureDoses() {
        return this.exposureDose;
    }

    public Double getImageAndFluoroscopyAreaDoseProduct() {
        return this.imageAndFluoroscopyAreaDoseProduct;
    }

    public void setImageAndFluoroscopyAreaDoseProduct(Double d) {
        this.imageAndFluoroscopyAreaDoseProduct = d;
    }

    public Integer getTotalNumberOfExposures() {
        return this.totalNumberOfExposures;
    }

    public void setTotalNumberOfExposures(Integer n) {
        this.totalNumberOfExposures = n;
    }

    public Integer getTotalTimeOfFluoruscopy() {
        return this.totalTimeOfFluoruscopy;
    }

    public void setTotalTimeOfFluoruscopy(Integer n) {
        this.totalTimeOfFluoruscopy = n;
    }
}

