/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ko;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ReferencedRequest
extends AbstractDatasetSource {
    private String studyInstanceUID;
    private ReferencedSOP referencedStudy;
    private String accessionNumber;
    private String placerOrderNumber;
    private String fillerOrderNumber;
    private String requestedProcedureID;
    private String requestedProcedureDescription;
    private Code requestedProcedureCode;

    public ReferencedRequest(Attributes attributes) {
        this.studyInstanceUID = this.getString(attributes, 0x20000D);
        this.referencedStudy = ReferencedSOP.create(attributes.getNestedDataset(528656));
        this.accessionNumber = this.getString(attributes, 524368);
        this.placerOrderNumber = this.getString(attributes, 4202518);
        this.fillerOrderNumber = this.getString(attributes, 4202519);
        this.requestedProcedureID = this.getString(attributes, 0x401001);
        this.requestedProcedureDescription = this.getString(attributes, 3280992);
        this.requestedProcedureCode = Code.create((Attributes)attributes, (int)3280996);
    }

    public static ReferencedRequest create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x20000D) && attributes.contains(528656)) {
            return new ReferencedRequest(attributes);
        }
        return null;
    }

    public static List<ReferencedRequest> createList(Attributes attributes, int n) {
        ArrayList<ReferencedRequest> arrayList = new ArrayList<ReferencedRequest>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ReferencedRequest referencedRequest = ReferencedRequest.create((Attributes)sequence.get(n2));
            if (referencedRequest != null) {
                arrayList.add(referencedRequest);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public ReferencedSOP getReferencedStudy() {
        return this.referencedStudy;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String getPlacerOrderNumber() {
        return this.placerOrderNumber;
    }

    public String getFillerOrderNumber() {
        return this.fillerOrderNumber;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public String getRequestedProcedureDescription() {
        return this.requestedProcedureDescription;
    }

    public Code requestedProcedureCode() {
        return this.requestedProcedureCode;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.studyInstanceUID, attributes, 0x20000D, DatasetAccessor.Type.Mandatory);
        this.set((DatasetSource)this.referencedStudy, attributes, 528656, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.accessionNumber, attributes, 524368, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.placerOrderNumber, attributes, 4202518, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.fillerOrderNumber, attributes, 4202519, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.requestedProcedureID, attributes, 0x401001, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.requestedProcedureDescription, attributes, 3280992, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.requestedProcedureCode, attributes, 3280996, DatasetAccessor.Type.MandatoryOrEmpty);
        return attributes;
    }
}

