/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.image;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.util.ImageUtils;
import com.agfa.pacs.listtext.dicomobject.lut.DicomLookupTable;
import com.agfa.pacs.listtext.dicomobject.lut.IColorLookupTableSource;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTable;
import com.agfa.pacs.logging.ALogger;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Fragments;

public class ImagePixel
extends AbstractDatasetSource
implements IColorLookupTableSource {
    private Integer samplesPerPixel;
    private PhotometricInterpretation photometricInterpretation;
    private Integer rows;
    private Integer bitsAllocated;
    private Integer columns;
    private Integer largestImagePixelValue;
    private Integer smallestImagePixelValue;
    private int[] pixelAspectRatio;
    private Integer planarConfiguration;
    private Integer pixelRepresentation;
    private Integer highBit;
    private Integer originalHighBit;
    private Integer bitsStored;
    private Integer originalBitsStored;
    private int[] redPaletteColorLookupTableDescriptor;
    private int[] greenPaletteColorLookupTableDescriptor;
    private int[] bluePaletteColorLookupTableDescriptor;
    private byte[] redPaletteColorLookupTableData;
    private byte[] bluePaletteColorLookupTableData;
    private byte[] greenPaletteColorLookupTableData;
    private byte[] segmentedRedPaletteColorLookupTableData;
    private byte[] segmentedGreenPaletteColorLookupTableData;
    private byte[] segmentedBluePaletteColorLookupTableData;
    private byte[] pixelData;
    private List<byte[]> pixelDataFragments;
    private String transferSyntaxUID;
    private IImagePixel imagePixel;
    private String pixelDataProviderURL;

    public ImagePixel() {
    }

    private ImagePixel(Attributes attributes, boolean bl) {
        this.originalBitsStored = this.getInteger(attributes, 2686994, "AgilityRuntime");
        this.originalHighBit = this.getInteger(attributes, 2686995, "AgilityRuntime");
        this.samplesPerPixel = this.getInteger(attributes, 0x280002);
        this.photometricInterpretation = PhotometricInterpretation.get((String)this.getString(attributes, 2621444));
        this.rows = this.getInteger(attributes, 2621456);
        this.columns = this.getInteger(attributes, 2621457);
        this.bitsStored = this.getInteger(attributes, 2621697);
        this.bitsAllocated = this.getInteger(attributes, 2621696);
        this.highBit = this.getInteger(attributes, 2621698);
        this.pixelRepresentation = this.getInteger(attributes, 2621699);
        this.planarConfiguration = this.getInteger(attributes, 2621446);
        this.pixelAspectRatio = this.getIntegers(attributes, 2621492);
        this.smallestImagePixelValue = this.getInteger(attributes, 2621702);
        this.largestImagePixelValue = this.getInteger(attributes, 2621703);
        try {
            this.redPaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625793);
            this.greenPaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625794);
            this.bluePaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625795);
            this.redPaletteColorLookupTableData = attributes.getBytes(2626049);
            this.greenPaletteColorLookupTableData = attributes.getBytes(2626050);
            this.bluePaletteColorLookupTableData = attributes.getBytes(2626051);
            this.segmentedRedPaletteColorLookupTableData = attributes.getBytes(0x281221);
            this.segmentedGreenPaletteColorLookupTableData = attributes.getBytes(0x281222);
            this.segmentedBluePaletteColorLookupTableData = attributes.getBytes(2626083);
            this.pixelDataProviderURL = this.getString(attributes, 2654176);
            Attributes attributes2 = attributes;
            while (attributes2.getParent() != null) {
                attributes2 = attributes2.getParent();
            }
            this.transferSyntaxUID = this.getString(attributes2, 131088);
            if (bl) {
                Object object = attributes.getValue(2145386512);
                if (object instanceof Fragments) {
                    Fragments fragments = (Fragments)object;
                    this.pixelDataFragments = new ArrayList<byte[]>();
                    int n = 0;
                    while (n < fragments.size()) {
                        this.pixelDataFragments.add((byte[])fragments.get(n));
                        ++n;
                    }
                } else {
                    this.pixelData = attributes.getBytes(2145386512);
                }
            }
        }
        catch (Exception exception) {
            ALogger.getLogger(ImagePixel.class).error("Bulk data error", (Throwable)exception);
        }
    }

    public ImagePixel(IImagePixel iImagePixel) {
        this.bitsAllocated = iImagePixel.getBitsAllocated();
        this.bitsStored = iImagePixel.getBitsStored();
        this.columns = iImagePixel.getColumns();
        this.highBit = iImagePixel.getHighBit();
        this.photometricInterpretation = iImagePixel.getPhotometricInterpretation();
        this.pixelRepresentation = iImagePixel.getPixelRepresentation();
        this.rows = iImagePixel.getRows();
        this.samplesPerPixel = iImagePixel.getSamplesPerPixel();
        this.pixelDataProviderURL = iImagePixel.getPixelDataProviderURL();
        if (this.samplesPerPixel > 1) {
            this.planarConfiguration = iImagePixel.getPlanarConfiguration();
        }
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.samplesPerPixel, attributes, 0x280002, DatasetAccessor.Type.Mandatory);
        this.set((DicomEnum)this.photometricInterpretation, attributes, 2621444, DatasetAccessor.Type.Mandatory);
        this.set(this.rows, attributes, 2621456, DatasetAccessor.Type.Mandatory);
        this.set(this.columns, attributes, 2621457, DatasetAccessor.Type.Mandatory);
        this.set(this.bitsStored, attributes, 2621697, DatasetAccessor.Type.Mandatory);
        this.set(this.bitsAllocated, attributes, 2621696, DatasetAccessor.Type.Mandatory);
        this.set(this.highBit, attributes, 2621698, DatasetAccessor.Type.Mandatory);
        this.set(this.pixelRepresentation, attributes, 2621699, DatasetAccessor.Type.Mandatory);
        this.set(this.planarConfiguration, attributes, 2621446, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.pixelAspectRatio, attributes, 2621492, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.smallestImagePixelValue, attributes, 2621702, DatasetAccessor.Type.Optional);
        this.set(this.largestImagePixelValue, attributes, 2621703, DatasetAccessor.Type.Optional);
        this.set(this.redPaletteColorLookupTableDescriptor, attributes, 2625793, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.greenPaletteColorLookupTableDescriptor, attributes, 2625794, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.bluePaletteColorLookupTableDescriptor, attributes, 2625795, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.redPaletteColorLookupTableData, attributes, 2626049, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.greenPaletteColorLookupTableData, attributes, 2626050, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.bluePaletteColorLookupTableData, attributes, 2626051, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.segmentedRedPaletteColorLookupTableData, attributes, 0x281221, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.segmentedGreenPaletteColorLookupTableData, attributes, 0x281222, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.segmentedBluePaletteColorLookupTableData, attributes, 2626083, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.pixelData, attributes, 2145386512, DatasetAccessor.Type.ConditionalMandatory);
        this.setFragments(this.pixelDataFragments, attributes, 2145386512);
        this.set(this.pixelDataProviderURL, attributes, 2654176, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public static ImagePixel create(BufferedImage bufferedImage) {
        return ImagePixel.create(ImageUtils.readImageAttributes((BufferedImage)bufferedImage), false);
    }

    public static ImagePixel create(Attributes attributes, boolean bl) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(2621456) && attributes.contains(2621457)) {
            return new ImagePixel(attributes, bl);
        }
        return null;
    }

    public Integer getBitsAllocated() {
        return this.bitsAllocated;
    }

    public Integer getColumns() {
        return this.columns;
    }

    public Integer getHighBit() {
        return this.highBit;
    }

    public Integer getLargestImagePixelValue() {
        return this.largestImagePixelValue;
    }

    public PhotometricInterpretation getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public int[] getPixelAspectRatio() {
        return this.pixelAspectRatio;
    }

    public Integer getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public Integer getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    public Integer getRows() {
        return this.rows;
    }

    public Integer getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public Integer getBitsStored() {
        return this.bitsStored;
    }

    public byte[] getPixelData() {
        return this.pixelData;
    }

    public void setBitsAllocated(Integer n) {
        this.bitsAllocated = n;
    }

    public void setBitsStored(Integer n) {
        this.bitsStored = n;
    }

    public void setColumns(Integer n) {
        this.columns = n;
    }

    public void setHighBit(Integer n) {
        this.highBit = n;
    }

    public void setLargestImagePixelValue(Integer n) {
        this.largestImagePixelValue = n;
    }

    public void setPhotometricInterpretation(PhotometricInterpretation photometricInterpretation) {
        this.photometricInterpretation = photometricInterpretation;
    }

    public void setPixelAspectRatio(int[] nArray) {
        this.pixelAspectRatio = nArray;
    }

    public void setPixelRepresentation(int n) {
        this.pixelRepresentation = n;
    }

    public void setPlanarConfiguration(Integer n) {
        this.planarConfiguration = n;
    }

    public void setRows(Integer n) {
        this.rows = n;
    }

    public void setSamplesPerPixel(Integer n) {
        this.samplesPerPixel = n;
    }

    public void setSmallestImagePixelValue(Integer n) {
        this.smallestImagePixelValue = n;
    }

    public void setPixelData(byte[] byArray) {
        this.pixelData = byArray;
    }

    public List<byte[]> pixelDataFragments() {
        return this.pixelDataFragments;
    }

    public byte[] getBluePaletteColorLookupTableData() {
        return this.bluePaletteColorLookupTableData;
    }

    public void setBluePaletteColorLookupTableData(byte[] byArray) {
        this.bluePaletteColorLookupTableData = byArray;
    }

    public int[] getBluePaletteColorLookupTableDescriptor() {
        return this.bluePaletteColorLookupTableDescriptor;
    }

    public void setBluePaletteColorLookupTableDescriptor(int[] nArray) {
        this.bluePaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getGreenPaletteColorLookupTableData() {
        return this.greenPaletteColorLookupTableData;
    }

    public void setGreenPaletteColorLookupTableData(byte[] byArray) {
        this.greenPaletteColorLookupTableData = byArray;
    }

    public int[] getGreenPaletteColorLookupTableDescriptor() {
        return this.greenPaletteColorLookupTableDescriptor;
    }

    public void setGreenPaletteColorLookupTableDescriptor(int[] nArray) {
        this.greenPaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getRedPaletteColorLookupTableData() {
        return this.redPaletteColorLookupTableData;
    }

    public void setRedPaletteColorLookupTableData(byte[] byArray) {
        this.redPaletteColorLookupTableData = byArray;
    }

    public int[] getRedPaletteColorLookupTableDescriptor() {
        return this.redPaletteColorLookupTableDescriptor;
    }

    public void setRedPaletteColorLookupTableDescriptor(int[] nArray) {
        this.redPaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getSegmentedBluePaletteColorLookupTableData() {
        return this.segmentedBluePaletteColorLookupTableData;
    }

    public void setSegmentedBluePaletteColorLookupTableData(byte[] byArray) {
        this.segmentedBluePaletteColorLookupTableData = byArray;
    }

    public byte[] getSegmentedGreenPaletteColorLookupTableData() {
        return this.segmentedGreenPaletteColorLookupTableData;
    }

    public void setSegmentedGreenPaletteColorLookupTableData(byte[] byArray) {
        this.segmentedGreenPaletteColorLookupTableData = byArray;
    }

    public byte[] getSegmentedRedPaletteColorLookupTableData() {
        return this.segmentedRedPaletteColorLookupTableData;
    }

    public void setSegmentedRedPaletteColorLookupTableData(byte[] byArray) {
        this.segmentedRedPaletteColorLookupTableData = byArray;
    }

    @Override
    public ILookupTable getLookupTable(IColorLookupTableSource.Channel channel) {
        switch (channel) {
            case Red: {
                return new DicomLookupTable(this.redPaletteColorLookupTableDescriptor, this.redPaletteColorLookupTableData, this.segmentedRedPaletteColorLookupTableData, channel.toString());
            }
            case Green: {
                return new DicomLookupTable(this.greenPaletteColorLookupTableDescriptor, this.greenPaletteColorLookupTableData, this.segmentedGreenPaletteColorLookupTableData, channel.toString());
            }
            case Blue: {
                return new DicomLookupTable(this.bluePaletteColorLookupTableDescriptor, this.bluePaletteColorLookupTableData, this.segmentedBluePaletteColorLookupTableData, channel.toString());
            }
        }
        return null;
    }

    @Override
    public boolean hasLookupTable() {
        return this.redPaletteColorLookupTableDescriptor != null && this.greenPaletteColorLookupTableDescriptor != null && this.bluePaletteColorLookupTableDescriptor != null;
    }

    @Override
    public void setTo(IColorLookupTableSource.Channel channel, ILookupTable iLookupTable) {
        switch (channel) {
            case Red: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.redPaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedRedPaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.redPaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            case Green: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.greenPaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedGreenPaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.greenPaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            case Blue: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.bluePaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedBluePaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.bluePaletteColorLookupTableData = dicomLookupTable.getLUTData();
            }
        }
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    public void setTransferSyntaxUID(String string) {
        this.transferSyntaxUID = string;
    }

    public IImagePixel imagePixel() {
        if (this.imagePixel == null) {
            this.imagePixel = new PrivateImagePixel();
        }
        return this.imagePixel;
    }

    private class PrivateImagePixel
    implements IImagePixel {
        private PrivateImagePixel() {
        }

        public int getBitsAllocated() {
            return ImagePixel.this.bitsAllocated;
        }

        public int getBitsStored() {
            return ImagePixel.this.bitsStored;
        }

        public int getOriginalBitsStored() {
            return ImagePixel.this.originalBitsStored;
        }

        public int getColumns() {
            return ImagePixel.this.columns;
        }

        public int getHighBit() {
            return ImagePixel.this.highBit;
        }

        public int getOriginalHighBit() {
            return ImagePixel.this.originalHighBit;
        }

        public PhotometricInterpretation getPhotometricInterpretation() {
            return ImagePixel.this.photometricInterpretation;
        }

        public int getPixelRepresentation() {
            return ImagePixel.this.pixelRepresentation;
        }

        public int getPlanarConfiguration() {
            return ImagePixel.this.planarConfiguration;
        }

        public int getRows() {
            return ImagePixel.this.rows;
        }

        public int getSamplesPerPixel() {
            return ImagePixel.this.samplesPerPixel;
        }

        public String getPixelDataProviderURL() {
            return ImagePixel.this.pixelDataProviderURL;
        }

        public String getGroupID() {
            return "";
        }

        public boolean isLossy() {
            if (ImagePixel.this.transferSyntaxUID != null) {
                return UIDConfiguration.getInstance().getLossyTransferSyntaxUIDs().contains(ImagePixel.this.transferSyntaxUID);
            }
            return false;
        }

        public boolean isColor() {
            return ImagePixel.this.samplesPerPixel == 3;
        }

        public boolean isSigned() {
            return ImagePixel.this.pixelRepresentation == 1;
        }
    }
}

