/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.equipment;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class GeneralEquipmentModule
extends AbstractModule {
    private String manufacturer;
    private String institutionName;
    private String stationName;
    private String institutionalDepartmentName;
    private String institutionAddress;
    private String manufacturerModelName;
    private String deviceSerialNumber;
    private Double spatialResolution;
    private Date dateOfLastCalibration;
    private Date timeOfLastCalibration;
    private Integer pixelPaddingValue;
    private String[] softwareVersions;

    public GeneralEquipmentModule() {
        super(Level.Series);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(524400);
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.manufacturer = this.getString(attributes, 524400);
        this.institutionName = this.getString(attributes, 524416);
        this.institutionAddress = this.getString(attributes, 524417);
        this.stationName = this.getString(attributes, 528400);
        this.institutionalDepartmentName = this.getString(attributes, 528448);
        this.manufacturerModelName = this.getString(attributes, 528528);
        this.deviceSerialNumber = this.getString(attributes, 0x181000);
        this.softwareVersions = this.getStrings(attributes, 1576992);
        this.spatialResolution = this.getDouble(attributes, 1577040);
        this.dateOfLastCalibration = this.getDate(attributes, 1577472);
        this.timeOfLastCalibration = this.getDate(attributes, 1577473);
        this.pixelPaddingValue = this.getInteger(attributes, 2621728);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.manufacturer, attributes, 524400, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.institutionName, attributes, 524416, DatasetAccessor.Type.Optional);
        this.set(this.institutionAddress, attributes, 524417, DatasetAccessor.Type.Optional);
        this.set(this.stationName, attributes, 528400, DatasetAccessor.Type.Optional);
        this.set(this.institutionalDepartmentName, attributes, 528448, DatasetAccessor.Type.Optional);
        this.set(this.manufacturerModelName, attributes, 528528, DatasetAccessor.Type.Optional);
        this.set(this.deviceSerialNumber, attributes, 0x181000, DatasetAccessor.Type.Optional);
        this.set(this.softwareVersions, attributes, 1576992, DatasetAccessor.Type.Optional);
        this.set(this.spatialResolution, attributes, 1577040, DatasetAccessor.Type.Optional);
        this.set(this.dateOfLastCalibration, attributes, 1577472, DatasetAccessor.Type.Optional);
        this.set(this.timeOfLastCalibration, attributes, 1577473, DatasetAccessor.Type.Optional);
        this.set(this.pixelPaddingValue, attributes, 2621728, DatasetAccessor.Type.Optional);
    }

    public Date getDateOfLastCalibration() {
        return this.dateOfLastCalibration;
    }

    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public String getInstitutionAddress() {
        return this.institutionAddress;
    }

    public String getInstitutionalDepartmentName() {
        return this.institutionalDepartmentName;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getManufacturerModelName() {
        return this.manufacturerModelName;
    }

    public Integer getPixelPaddingValue() {
        return this.pixelPaddingValue;
    }

    public String[] getSoftwareVersions() {
        return this.softwareVersions;
    }

    public Double getSpatialResolution() {
        return this.spatialResolution;
    }

    public String getStationName() {
        return this.stationName;
    }

    public Date getTimeOfLastCalibration() {
        return this.timeOfLastCalibration;
    }

    public void setDateOfLastCalibration(Date date) {
        this.dateOfLastCalibration = date;
    }

    public void setDeviceSerialNumber(String string) {
        this.deviceSerialNumber = string;
    }

    public void setInstitutionAddress(String string) {
        this.institutionAddress = string;
    }

    public void setInstitutionalDepartmentName(String string) {
        this.institutionalDepartmentName = string;
    }

    public void setInstitutionName(String string) {
        this.institutionName = string;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public void setManufacturerModelName(String string) {
        this.manufacturerModelName = string;
    }

    public void setPixelPaddingValue(Integer n) {
        this.pixelPaddingValue = n;
    }

    public void setSoftwareVersions(String[] stringArray) {
        this.softwareVersions = stringArray;
    }

    public void setSpatialResolution(Double d) {
        this.spatialResolution = d;
    }

    public void setStationName(String string) {
        this.stationName = string;
    }

    public void setTimeOfLastCalibration(Date date) {
        this.timeOfLastCalibration = date;
    }
}

