/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.lut;

import com.agfa.pacs.listtext.dicomobject.lut.AbstractLookupTable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DicomLookupTable
extends AbstractLookupTable {
    private int[] lutDescriptor;
    private byte[] lutData;
    private int numEntries;
    private String description;
    private byte[] lutSegmentedData;

    public DicomLookupTable(int[] nArray, byte[] byArray, byte[] byArray2, String string) {
        this.lutDescriptor = nArray;
        this.lutData = byArray;
        this.lutSegmentedData = byArray2;
        this.description = string;
        this.numEntries = nArray[0];
        if (this.numEntries == 0) {
            this.numEntries = 65536;
        }
    }

    @Override
    public int[] getLUT() {
        if (this.lutData != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.lutData);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int[] nArray = new int[this.numEntries];
            switch (byteBuffer.limit() / this.numEntries) {
                case 1: {
                    int n = 0;
                    while (n < this.numEntries) {
                        nArray[n] = byteBuffer.get(n) & 0xFF;
                        ++n;
                    }
                    break;
                }
                case 2: {
                    int n = 0;
                    while (n < this.numEntries) {
                        nArray[n] = byteBuffer.getShort(n * 2) & 0xFFFF;
                        ++n;
                    }
                    break;
                }
            }
            return nArray;
        }
        if (this.lutSegmentedData != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.lutSegmentedData);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int[] nArray = new int[this.numEntries];
            int n = 0;
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                n = this.expandSegment(byteBuffer, nArray, n);
            }
            return nArray;
        }
        return null;
    }

    private int expandSegment(ByteBuffer byteBuffer, int[] nArray, int n) {
        int n2 = byteBuffer.getShort() & 0xFFFF;
        switch (n2) {
            case 0: {
                int n3 = byteBuffer.getShort() & 0xFFFF;
                int n4 = 0;
                while (n4 < n3) {
                    if (n < nArray.length) {
                        nArray[n] = byteBuffer.getShort() & 0xFFFF;
                    }
                    ++n;
                    ++n4;
                }
                break;
            }
            case 1: {
                int n5;
                int n6 = byteBuffer.getShort() & 0xFFFF;
                int n7 = n5 = byteBuffer.getShort() & 0xFFFF;
                if (n < nArray.length) {
                    n7 = nArray[n - 1];
                }
                int n8 = n5 - n7;
                int n9 = 1;
                while (n9 <= n6) {
                    if (n < nArray.length) {
                        nArray[n] = n7 + n8 * n9 / n6;
                    }
                    ++n;
                    ++n9;
                }
                break;
            }
            case 2: {
                int n10 = byteBuffer.getShort() & 0xFFFF;
                int n11 = byteBuffer.getInt();
                int n12 = byteBuffer.position();
                byteBuffer.position(n11);
                int n13 = 0;
                while (n13 < n10) {
                    this.expandSegment(byteBuffer, nArray, n);
                    ++n13;
                }
                byteBuffer.position(n12);
            }
        }
        return n;
    }

    @Override
    public int[] getLUTInputRange(boolean bl) {
        if (bl) {
            return new int[]{(short)this.lutDescriptor[1], (short)this.lutDescriptor[1] + this.numEntries};
        }
        return new int[]{this.lutDescriptor[1], this.lutDescriptor[1] + this.numEntries - 1};
    }

    @Override
    public int[] getLUTOutputRange() {
        int[] nArray = new int[2];
        nArray[1] = (1 << this.lutDescriptor[2]) - 1;
        return nArray;
    }

    @Override
    public String getLUTDescription() {
        return this.description;
    }

    @Override
    public int getOutputBits() {
        return this.lutDescriptor[2];
    }

    @Override
    public int[] getLUTDescriptor() {
        return this.lutDescriptor;
    }

    public byte[] getLUTData() {
        return this.lutData;
    }

    public byte[] getLUTSegmentedData() {
        return this.lutSegmentedData;
    }
}

