/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReferencedSOP;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class SOPInstanceReferencedSeries
extends AbstractDatasetSource {
    private String seriesInstanceUID;
    private String[] retrieveAETs;
    private String storageMediaFileSetID;
    private String storageMediaFileSetUID;
    private List<SOPInstanceReferencedSOP> referencedSOP;

    public SOPInstanceReferencedSeries(String string) {
        this.seriesInstanceUID = string;
        this.referencedSOP = new ArrayList<SOPInstanceReferencedSOP>();
    }

    public SOPInstanceReferencedSeries(String string, String string2, String string3) {
        this(string);
        this.referencedSOP.add(new SOPInstanceReferencedSOP(string3, string2));
    }

    private SOPInstanceReferencedSeries(Attributes attributes) {
        this.seriesInstanceUID = this.getString(attributes, 0x20000E);
        this.retrieveAETs = this.getStrings(attributes, 524372);
        this.storageMediaFileSetID = this.getString(attributes, 8913200);
        this.storageMediaFileSetUID = this.getString(attributes, 8913216);
        this.referencedSOP = SOPInstanceReferencedSOP.createList(attributes, 528793);
    }

    public static SOPInstanceReferencedSeries create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x20000E) && attributes.contains(528793)) {
            return new SOPInstanceReferencedSeries(attributes);
        }
        return null;
    }

    public static List<SOPInstanceReferencedSeries> createList(Attributes attributes, int n) {
        ArrayList<SOPInstanceReferencedSeries> arrayList = new ArrayList<SOPInstanceReferencedSeries>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            SOPInstanceReferencedSeries sOPInstanceReferencedSeries = SOPInstanceReferencedSeries.create((Attributes)sequence.get(n2));
            if (sOPInstanceReferencedSeries != null) {
                arrayList.add(sOPInstanceReferencedSeries);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String[] getRetrieveAETs() {
        return this.retrieveAETs;
    }

    public String getStorageMediaFileSetID() {
        return this.storageMediaFileSetID;
    }

    public String getStorageMediaFileSetUID() {
        return this.storageMediaFileSetUID;
    }

    public List<SOPInstanceReferencedSOP> getReferencedSOP() {
        return this.referencedSOP;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.seriesInstanceUID, attributes, 0x20000E, DatasetAccessor.Type.Mandatory);
        this.set(this.retrieveAETs, attributes, 524372, DatasetAccessor.Type.Optional);
        this.set(this.storageMediaFileSetID, attributes, 8913200, DatasetAccessor.Type.Optional);
        this.set(this.storageMediaFileSetUID, attributes, 8913216, DatasetAccessor.Type.Optional);
        this.set(this.referencedSOP, attributes, 528793, DatasetAccessor.Type.Mandatory);
        return attributes;
    }
}

