/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.data.shared.dicom.YesNo;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class RelatedSourceImage
extends AbstractDatasetSource {
    private String sopInstanceUID;
    private String sopClassUID;
    private int[] referencedFrameNumber;
    private Code purposeOfReferenceCode;
    private YesNo spatialLocationsPreserved;

    public RelatedSourceImage(String string, String string2) {
        this.sopClassUID = string;
        this.sopInstanceUID = string2;
    }

    private RelatedSourceImage(Attributes attributes) {
        this.sopClassUID = this.getString(attributes, 528720);
        this.sopInstanceUID = this.getString(attributes, 528725);
        this.referencedFrameNumber = this.getIntegers(attributes, 528736);
        this.purposeOfReferenceCode = Code.create((Attributes)attributes, (int)4235632);
        this.spatialLocationsPreserved = YesNo.get((String)this.getString(attributes, 2626394));
    }

    public static RelatedSourceImage create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(528720) && attributes.contains(528725)) {
            return new RelatedSourceImage(attributes);
        }
        return null;
    }

    public static List<RelatedSourceImage> createList(Attributes attributes, int n) {
        ArrayList<RelatedSourceImage> arrayList = new ArrayList<RelatedSourceImage>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            RelatedSourceImage relatedSourceImage = RelatedSourceImage.create((Attributes)sequence.get(n2));
            if (relatedSourceImage != null) {
                arrayList.add(relatedSourceImage);
            }
            ++n2;
        }
        return arrayList;
    }

    public int[] getFrameNumbers() {
        return this.referencedFrameNumber;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public Code getPurposeOfReferenceCode() {
        return this.purposeOfReferenceCode;
    }

    public void setPurposeOfReferenceCode(Code code) {
        this.purposeOfReferenceCode = code;
    }

    public void setReferencedFrameNumber(int[] nArray) {
        this.referencedFrameNumber = nArray;
    }

    public void setSOPClassUID(String string) {
        this.sopClassUID = string;
    }

    public void setSOPInstanceUID(String string) {
        this.sopInstanceUID = string;
    }

    public void setSpatialLocationsPreserved(YesNo yesNo) {
        this.spatialLocationsPreserved = yesNo;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassUID, attributes, 528720, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 528725, DatasetAccessor.Type.Mandatory);
        this.set(this.referencedFrameNumber, attributes, 528736, DatasetAccessor.Type.ConditionalMandatory);
        this.set((DatasetSource)this.purposeOfReferenceCode, attributes, 4235632, DatasetAccessor.Type.Optional);
        this.set((DicomEnum)this.spatialLocationsPreserved, attributes, 2626394, DatasetAccessor.Type.Optional);
        return attributes;
    }
}

