/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ReferencedImage
extends AbstractDatasetSource {
    private String sopInstanceUID;
    private String sopClassUID;
    private BitSet referencedFrameNumber = null;

    public ReferencedImage() {
    }

    public ReferencedImage(ReferencedImage referencedImage) {
        this.sopClassUID = referencedImage.sopClassUID;
        this.sopInstanceUID = referencedImage.sopInstanceUID;
        if (referencedImage.referencedFrameNumber != null) {
            this.referencedFrameNumber = (BitSet)referencedImage.referencedFrameNumber.clone();
        }
    }

    private ReferencedImage(Attributes attributes) {
        this.sopClassUID = this.getString(attributes, 528720);
        this.sopInstanceUID = this.getString(attributes, 528725);
        int[] nArray = attributes.getInts(528736);
        if (nArray != null) {
            this.referencedFrameNumber = new BitSet();
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                this.referencedFrameNumber.set(n3);
                ++n2;
            }
        }
    }

    public static ReferencedImage create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(528720) && attributes.contains(528725)) {
            return new ReferencedImage(attributes);
        }
        return null;
    }

    public static Map<String, ReferencedImage> createMap(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return new LinkedHashMap<String, ReferencedImage>(1);
        }
        LinkedHashMap<String, ReferencedImage> linkedHashMap = new LinkedHashMap<String, ReferencedImage>(sequence.size());
        int n2 = 0;
        while (n2 < sequence.size()) {
            ReferencedImage referencedImage = ReferencedImage.create((Attributes)sequence.get(n2));
            if (referencedImage != null) {
                linkedHashMap.put(referencedImage.getSOPInstanceUID(), referencedImage);
            }
            ++n2;
        }
        return linkedHashMap;
    }

    public boolean hasFrame(int n) {
        if (this.referencedFrameNumber == null || this.referencedFrameNumber.isEmpty()) {
            return true;
        }
        return this.referencedFrameNumber.get(n + 1);
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public void setSOPClassUID(String string) {
        this.sopClassUID = string;
    }

    public void setSOPInstanceUID(String string) {
        this.sopInstanceUID = string;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassUID, attributes, 528720, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 528725, DatasetAccessor.Type.Mandatory);
        this.set(this.getFrames(), attributes, 528736, DatasetAccessor.Type.ConditionalMandatory);
        return attributes;
    }

    public int[] getFrames() {
        if (this.referencedFrameNumber == null || this.referencedFrameNumber.isEmpty()) {
            return null;
        }
        int[] nArray = new int[this.referencedFrameNumber.cardinality()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.referencedFrameNumber.nextSetBit(n == 0 ? 0 : nArray[n - 1] + 1);
            ++n;
        }
        return nArray;
    }

    public void setFrame(int n) {
        if (this.referencedFrameNumber == null) {
            this.referencedFrameNumber = new BitSet();
        }
        this.referencedFrameNumber.set(n);
    }

    public void setFrames(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            this.setFrame(n3);
            ++n2;
        }
    }

    public static void addReference(Map<String, ReferencedImage> map, ReferencedImage referencedImage) {
        String string = referencedImage.getSOPInstanceUID();
        ReferencedImage referencedImage2 = map.get(string);
        if (referencedImage2 != null) {
            ReferencedImage referencedImage3 = new ReferencedImage(referencedImage2);
            referencedImage3.referencedFrameNumber.or(referencedImage.referencedFrameNumber);
            map.put(string, referencedImage3);
            return;
        }
        map.put(string, referencedImage);
    }
}

