/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.curve;

import com.agfa.pacs.listtext.dicomobject.module.curve.Curve;
import com.agfa.pacs.listtext.dicomobject.module.curve.TypeOfData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class CurveContainer {
    private List<double[]> points;
    private Curve curve;
    private Integer num;
    private Integer dim;

    public CurveContainer(Curve curve) {
        int n;
        this.curve = curve;
        this.num = curve.getNumberOfPoints();
        this.dim = curve.getCurveDimensions();
        int[] nArray = curve.getCurveDataDescriptor();
        ByteBuffer byteBuffer = ByteBuffer.wrap(curve.getCurveData());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int[] nArray2 = curve.getCoordinateStartValue();
        int[] nArray3 = curve.getCoordinateStepValue();
        int n2 = curve.getDataValueRepresentation();
        this.points = new ArrayList<double[]>();
        if (nArray == null) {
            nArray = new int[this.dim.intValue()];
            n = 0;
            while (n < this.dim) {
                nArray[n] = 1;
                ++n;
            }
        }
        n = 0;
        while (n < this.num) {
            double[] dArray = new double[this.dim.intValue()];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.dim) {
                block0 : switch (nArray[n4]) {
                    case 0: {
                        dArray[n4] = nArray2[n3] + nArray3[n3] * n;
                        ++n3;
                        break;
                    }
                    case 1: {
                        switch (n2) {
                            case 0: {
                                dArray[n4] = byteBuffer.getShort() & 0xFFFF;
                                break block0;
                            }
                            case 1: {
                                dArray[n4] = byteBuffer.getShort();
                                break block0;
                            }
                            case 2: {
                                dArray[n4] = byteBuffer.getFloat();
                                break block0;
                            }
                            case 3: {
                                dArray[n4] = byteBuffer.getDouble();
                                break block0;
                            }
                            case 4: {
                                dArray[n4] = byteBuffer.getInt();
                            }
                        }
                    }
                }
                ++n4;
            }
            this.points.add(dArray);
            ++n;
        }
    }

    public List<double[]> points() {
        return this.points;
    }

    public double[] getData() {
        double[] dArray = new double[this.dim * this.points.size()];
        int n = 0;
        for (double[] dArray2 : this.points) {
            System.arraycopy(dArray2, 0, dArray, n, this.dim);
            n += this.dim.intValue();
        }
        return dArray;
    }

    public int getCurveDimensions() {
        return this.dim;
    }

    public String[] getAxisLabels() {
        return this.curve.getAxisLabels();
    }

    public String[] getAxisUnits() {
        return this.curve.getAxisUnits();
    }

    public String getCurveDescription() {
        return this.curve.getCurveDescription();
    }

    public String getCurveLabel() {
        return this.curve.getCurveLabel();
    }

    public int[] getMaximumCoordinateValue() {
        return this.curve.getMaximumCoordinateValue();
    }

    public int[] getMinimumCoordinateValue() {
        return this.curve.getMinimumCoordinateValue();
    }

    public TypeOfData getTypeOfData() {
        return this.curve.getTypeOfData();
    }
}

