/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.local;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationCache;
import com.agfa.pacs.config.IConfigurationCacheVisitor;
import com.agfa.pacs.config.IConfigurationSource;
import com.agfa.pacs.config.PacsConfigParser;
import com.agfa.pacs.logging.ALogger;
import com.sun.org.apache.xml.internal.serialize.BaseMarkupSerializer;
import com.sun.org.apache.xml.internal.serialize.EncodingInfo;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Bundle;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocalConfigurationSource
implements IConfigurationSource {
    private static String CONFIG_NAME = "Config";
    private static String CONFIG_LIST_NAME = "ConfigList";
    private static String SEQUENCE_NAME = "Sequence";
    public static final String CONFIG_FILE_NAME = "pacsconfig.xml";
    private static ALogger log = ALogger.getLogger(LocalConfigurationSource.class);
    private Object mutex = new Object();
    private boolean stored = false;
    private boolean initialised = false;
    private String base;
    private boolean asResource;
    private IConfigurationCache myCache = null;

    public LocalConfigurationSource() {
        if (Platform.isRunning()) {
            Location location = Platform.getConfigurationLocation();
            try {
                this.base = String.valueOf(new File(new URL(location.getURL(), "pacs/").getPath()).getAbsolutePath()) + File.separatorChar;
                log.info("Base path:" + this.base);
                this.asResource = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.base = "/resources/pacs/";
            this.asResource = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestKey(IConfigurationCache iConfigurationCache, String string, String string2, String string3) {
        if (this.initialised) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (!this.initialised) break block5;
                return true;
            }
            long l = System.currentTimeMillis();
            this.init(iConfigurationCache);
            System.out.println("Config Ini time:" + (System.currentTimeMillis() - l));
            this.initialised = true;
            return true;
        }
    }

    public boolean valueModified(String string, ConfigLevel configLevel, String string2, Object object, ConfigType configType) {
        return false;
    }

    public void markAsStored() {
        log.warn("Marking as Stored,no changes will be stored");
        this.stored = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfig() {
        if (this.stored) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.stored) {
                return;
            }
            log.warn("Start saving XML COnfiguration");
            HashMap<ConfigLevel, Document> hashMap = new HashMap<ConfigLevel, Document>();
            HashMap<ConfigLevel, File> hashMap2 = new HashMap<ConfigLevel, File>();
            try {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6 = ConfigLevel.values();
                int n = ((ConfigLevel[])object6).length;
                int n2 = 0;
                while (n2 < n) {
                    ConfigLevel object7 = object6[n2];
                    if (object7 != ConfigLevel.Manufacturer) {
                        object5 = this.ensurePath(new File(this.base, this.getRealConfigFileName(object7, ".tmp")));
                        hashMap2.put(object7, (File)object5);
                        object4 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        object3 = ((DocumentBuilder)object4).newDocument();
                        object2 = object3.createElement("PacsConfiguration");
                        object3.appendChild((Node)object2);
                        hashMap.put(object7, (Document)object3);
                    }
                    ++n2;
                }
                this.myCache.scanCache((IConfigurationCacheVisitor)new CacheXmlVisitor(hashMap), false, true);
                for (Map.Entry entry : hashMap2.entrySet()) {
                    File file = (File)entry.getValue();
                    object6 = (Document)hashMap.get(entry.getKey());
                    object5 = new OutputFormat((Document)object6);
                    ((OutputFormat)object5).setIndenting(true);
                    ((OutputFormat)object5).setIndent(2);
                    object4 = new EncodingInfo("UTF-8", "UTF8", 0x10FFFF);
                    ((OutputFormat)object5).setEncoding((EncodingInfo)object4);
                    object3 = new FileOutputStream(file);
                    object2 = new XMLSerializer((OutputStream)object3, (OutputFormat)object5);
                    ((BaseMarkupSerializer)object2).serialize((Document)object6);
                    ((FileOutputStream)object3).close();
                }
                for (Map.Entry entry : hashMap2.entrySet()) {
                    File file = (File)entry.getValue();
                    object6 = this.getRealConfigFileName((ConfigLevel)entry.getKey(), ".xml");
                    new File(this.base, (String)object6).delete();
                    file.renameTo(new File(this.base, (String)object6));
                }
                this.stored = true;
                log.warn("Finished saving XML COnfiguration");
            }
            catch (Exception exception) {
                log.error("Could not store config data", (Throwable)exception);
            }
        }
    }

    private String getRealConfigFileName(ConfigLevel configLevel, String string) {
        String string2 = String.valueOf(configLevel.toString()) + string;
        return string2;
    }

    private File ensurePath(File file) {
        file = file.getAbsoluteFile();
        file.getParentFile().mkdirs();
        return file;
    }

    public String concatOrder(ConfigLevel[] configLevelArray) {
        StringBuilder stringBuilder = new StringBuilder(150);
        int n = 0;
        while (n < configLevelArray.length) {
            stringBuilder.append(configLevelArray[n].name());
            if (n < configLevelArray.length - 1) {
                stringBuilder.append('.');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private String getLocalName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            File file = new File(this.base, String.valueOf(string) + ".properties");
            if (file.exists()) {
                return string;
            }
        }
        catch (Exception exception) {}
        return "Local";
    }

    private void init(IConfigurationCache iConfigurationCache) {
        this.myCache = iConfigurationCache;
        log.warn("Start XML scanning");
        if (!this.asResource) {
            this.scanUpdatedModules(iConfigurationCache, false);
        }
        if (!this.readLocalConfig(iConfigurationCache) && !this.asResource) {
            this.scanUpdatedModules(iConfigurationCache, true);
        }
        log.warn("XML finished");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readLocalConfig(IConfigurationCache iConfigurationCache) {
        try {
            ConfigLevel[] configLevelArray = ConfigLevel.values();
            int n = configLevelArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                ConfigLevel configLevel = configLevelArray[n2];
                if (configLevel != ConfigLevel.Manufacturer && !this.loadLocalConfig(String.valueOf(this.base) + this.getRealConfigFileName(configLevel, ".xml"), configLevel, iConfigurationCache)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            log.error("Could not read local config xml", (Throwable)exception);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean loadLocalConfig(String var1_1, ConfigLevel var2_2, IConfigurationCache var3_3) {
        block29: {
            block30: {
                block31: {
                    block27: {
                        block28: {
                            var4_4 = null;
                            if (!this.asResource) ** GOTO lbl18
                            var4_4 = LocalConfigurationSource.class.getResourceAsStream(var1_1);
                            if (var4_4 != null) break block27;
                            if (var4_4 == null) break block28;
                            try {
                                var4_4.close();
                            }
                            catch (Exception v0) {}
                        }
                        return false;
                    }
                    PacsConfigParser.readModuleConfig(null, (InputStream)var4_4, (IConfigurationCache)var3_3);
                    break block29;
lbl18:
                    // 1 sources

                    var5_5 = new File(var1_1);
                    if (var5_5.exists()) break block30;
                    if (var4_4 == null) break block31;
                    try {
                        var4_4.close();
                    }
                    catch (Exception v1) {}
                }
                return false;
            }
            try {
                PacsConfigParser.readModuleConfig(null, (File)var5_5, (IConfigurationCache)var3_3);
            }
            catch (IOException v2) {
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (Exception v3) {}
                }
                return false;
            }
            catch (IllegalArgumentException var5_6) {
                LocalConfigurationSource.log.error("Parsing error on level " + var2_2, (Throwable)var5_6);
                var5_6.printStackTrace();
                if (var4_4 == null) ** GOTO lbl72
                try {
                    var4_4.close();
                }
                catch (Exception v4) {}
            }
            catch (Exception var5_7) {
                LocalConfigurationSource.log.error("Other error on local config:" + var2_2, (Throwable)var5_7);
                if (var4_4 == null) ** GOTO lbl72
                {
                    catch (Throwable var6_8) {
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (Exception v5) {}
                        }
                        throw var6_8;
                    }
                }
                try {
                    var4_4.close();
                }
                catch (Exception v6) {}
            }
        }
        if (var4_4 != null) {
            try {
                var4_4.close();
            }
            catch (Exception v7) {}
        }
lbl72:
        // 10 sources

        return true;
    }

    private void scanUpdatedModules(IConfigurationCache iConfigurationCache, boolean bl) {
        BundleDescription[] bundleDescriptionArray;
        BundleDescription[] bundleDescriptionArray2 = bundleDescriptionArray = Platform.getPlatformAdmin().getState().getBundles();
        int n = bundleDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundleDescription = bundleDescriptionArray2[n2];
            if (bundleDescription.getSymbolicName() == null) {
                log.warn("SymbolicName for BundleDescription=" + bundleDescription + " is null!");
            } else {
                Bundle bundle = Platform.getBundle((String)bundleDescription.getSymbolicName());
                if (bundle == null) {
                    System.out.println("no bundle found for " + bundleDescription.getSymbolicName());
                } else {
                    String string = bundle.getSymbolicName();
                    URL uRL = bundle.getEntry(CONFIG_FILE_NAME);
                    if (uRL != null) {
                        try {
                            InputStream inputStream = uRL.openStream();
                            PacsConfigParser.readModuleConfig(null, (InputStream)inputStream, (IConfigurationCache)iConfigurationCache);
                            inputStream.close();
                        }
                        catch (Exception exception) {
                            log.error("Could not read pacsconfig.xml from bundle " + string, (Throwable)exception);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public IConfigurationSource.ConfigSourcePriority getPriority() {
        return IConfigurationSource.ConfigSourcePriority.MediumHigh;
    }

    public boolean requestKeyUpdate(IConfigurationCache iConfigurationCache, String string, List<String> list, String string2) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPluginNotCached(String string, List<String> list, String string2) {
        Object object = this.mutex;
        synchronized (object) {
            this.initialised = false;
        }
    }

    public boolean requestKeyUpdate(IConfigurationCache iConfigurationCache, String string, String string2, String string3) {
        return this.requestKeyUpdate(iConfigurationCache, string, Collections.singletonList(string2), string3);
    }

    public void notifyPluginNotCached(String string, String string2, String string3) {
        this.notifyPluginNotCached(string, Collections.singletonList(string2), string3);
    }

    public boolean isSupportingRoles() {
        return false;
    }

    public void storeForRole(String string) {
    }

    static class CacheXmlVisitor
    implements IConfigurationCacheVisitor {
        Map<ConfigLevel, Document> docs;

        public CacheXmlVisitor(Map<ConfigLevel, Document> map) {
            this.docs = map;
        }

        public void visitEntry(ConfigLevel configLevel, long l, String string, ConfigType configType, Object object) {
            try {
                if (configLevel == null || configLevel == ConfigLevel.Manufacturer) {
                    return;
                }
                Document document = this.docs.get(configLevel);
                Element element = document.getDocumentElement();
                Node node = element.getFirstChild();
                while (node != null && !node.getNodeName().equals(configLevel.toString())) {
                    node = node.getNextSibling();
                }
                if (node == null) {
                    node = document.createElement(configLevel.toString());
                    element.appendChild(node);
                }
                Element element2 = this.findConfig((Element)node, "", string);
                if (ConfigType.Text == configType) {
                    CDATASection cDATASection = document.createCDATASection(object.toString());
                    element2.appendChild(cDATASection);
                } else {
                    element2.setTextContent(object.toString());
                }
                if (configType != null) {
                    element2.setAttribute("Type", configType.name());
                }
            }
            catch (Exception exception) {
                log.error("Could not visit/merge config entry: " + string, (Throwable)exception);
            }
        }

        private Element findConfig(Element element, String string, String string2) {
            Element element2 = this.findConfigElement(element, string, string2, false);
            if (element2 != null) {
                return element2;
            }
            element2 = this.findConfigElement(element, string, string2, true);
            if (element2 != null) {
                return element2;
            }
            String string3 = "";
            String string4 = "";
            String string5 = "";
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            boolean bl2 = false;
            while (stringTokenizer.hasMoreElements()) {
                string4 = (String)stringTokenizer.nextElement();
                boolean bl3 = bl = string4.indexOf(35) >= 0;
                if (bl) {
                    string5 = string4.substring(string4.indexOf(35) + 1);
                    string4 = string4.substring(0, string4.indexOf(35));
                }
                String string6 = string3 = string3.length() == 0 ? string4 : String.valueOf(string3) + "." + string4;
                if (string.length() == 0 || bl2) break;
                if (!string3.equalsIgnoreCase(string)) continue;
                bl2 = true;
                if (bl) {
                    NodeList nodeList = element.getChildNodes();
                    Element element3 = null;
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Element element4;
                        String string7;
                        if (nodeList.item(n).getNodeName().equals(CONFIG_NAME) && (string7 = (element4 = (Element)nodeList.item(n)).getAttribute("Order")).equals(string5)) {
                            element3 = element4;
                        }
                        ++n;
                    }
                    if (element3 == null) {
                        element3 = element.getOwnerDocument().createElement(CONFIG_NAME);
                        element3.setAttribute("Order", string5);
                        element.appendChild(element3);
                    }
                    StringBuilder stringBuilder = new StringBuilder(string3);
                    while (stringTokenizer.hasMoreElements()) {
                        stringBuilder.append('.').append(stringTokenizer.nextElement());
                    }
                    return this.findConfig(element3, string3, stringBuilder.toString());
                }
                if (stringTokenizer.hasMoreElements()) continue;
                return element;
            }
            Element element5 = bl ? element.getOwnerDocument().createElement(CONFIG_LIST_NAME) : element.getOwnerDocument().createElement(CONFIG_NAME);
            element5.setAttribute("Key", string4);
            element.appendChild(element5);
            if (bl && string3.concat("#").equals(string2)) {
                return element5;
            }
            return this.findConfig(element5, string3, string2);
        }

        private Element findLookupSequence(Element element, String string, String string2) {
            Element element2 = this.findSequenceElement(element, string, string2);
            if (element2 != null) {
                return element2;
            }
            StringBuilder stringBuilder = new StringBuilder("");
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                boolean bl2;
                string3 = (String)stringTokenizer.nextElement();
                boolean bl3 = bl2 = string3.indexOf(35) >= 0;
                if (bl2) {
                    string3 = string3.substring(0, string3.indexOf(35));
                }
                if (stringBuilder.length() != 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(string3);
                if (string.length() == 0 || bl) break;
                if (!stringBuilder.toString().equalsIgnoreCase(string)) continue;
                bl = true;
                if (stringTokenizer.hasMoreElements() && !bl2) continue;
                Element element3 = (Element)element.getParentNode();
                element3.removeChild(element);
                return element3;
            }
            Element element4 = element.getOwnerDocument().createElement(SEQUENCE_NAME);
            element4.setAttribute("Key", string3);
            element.appendChild(element4);
            return this.findLookupSequence(element4, stringBuilder.toString(), string2);
        }

        private Element findConfigElement(Element element, String string, String string2, boolean bl) {
            NodeList nodeList = element.getChildNodes();
            String string3 = bl ? CONFIG_LIST_NAME : CONFIG_NAME;
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n).getNodeName().equals(string3)) {
                    String string4;
                    String string5;
                    Element element2 = (Element)nodeList.item(n);
                    String string6 = element2.getAttribute("Key");
                    String string7 = string5 = string.length() == 0 ? string6 : String.valueOf(string) + "." + string6;
                    if (string2.equalsIgnoreCase(string5)) {
                        return element2;
                    }
                    String string8 = string4 = bl ? String.valueOf(string5) + "#" : String.valueOf(string5) + ".";
                    if (string2.indexOf(string4) == 0) {
                        return this.findConfig(element2, string5, string2);
                    }
                }
                ++n;
            }
            return null;
        }

        private Element findSequenceElement(Element element, String string, String string2) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals(SEQUENCE_NAME)) {
                    String string3;
                    Element element2 = (Element)node;
                    String string4 = element2.getAttribute("Key");
                    String string5 = string3 = string.length() == 0 ? string4 : String.valueOf(string) + "." + string4;
                    if (string2.equalsIgnoreCase(string3)) {
                        return element2;
                    }
                    if (string2.indexOf(String.valueOf(string3) + ".") != 0) continue;
                    return this.findLookupSequence(element2, string3, string2);
                }
                node = node.getNextSibling();
            }
            return null;
        }
    }
}

