/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.provider.internal;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationCache;
import com.agfa.pacs.config.IConfigurationCacheVisitor;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.config.provider.internal.ConfigTree;
import com.agfa.pacs.config.provider.internal.MissingLookupSequence;
import com.agfa.pacs.config.provider.internal.ValueModificationReturn;
import com.agfa.pacs.logging.ALogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ConfigNode
implements IConfigurationCache {
    private static final ALogger logger = ALogger.getLogger(ConfigNode.class);
    public static final String LIST_TYPE = "List";
    public static final char LIST_MARKER = '#';
    public static final char PATH_SEPARATOR = '.';
    protected boolean dirty;
    protected static Map<String, byte[]> lookupSequences = new HashMap<String, byte[]>();

    protected abstract Object getValue(Iterator<String> var1);

    protected abstract String getRole(Iterator<String> var1);

    protected abstract Map<String, String> getLocalizedValues(Iterator<String> var1);

    protected abstract Map<ConfigLevel, Object> getMap(Iterator<String> var1);

    public abstract IConfigurationProvider getNode(ConfigTree var1, String var2, Iterator<String> var3);

    public abstract IConfigurationList getList(ConfigTree var1, String var2, Iterator<String> var3);

    abstract ConfigNode getNode(Iterator<String> var1);

    public abstract IConfigurationList createList(ConfigTree var1, String var2, Iterator<String> var3, String var4);

    public abstract ValueModificationReturn setValue(String[] var1, int var2, String var3, ConfigType var4, Object var5, String var6) throws MissingLookupSequence;

    public abstract ValueModificationReturn removeValue(Iterator<String> var1);

    abstract void removeNode(Iterator<String> var1);

    protected abstract void initValue(ConfigLevel var1, String[] var2, int var3, ConfigType var4, String var5, String var6);

    protected abstract void internalScanCache(String var1, IConfigurationCacheVisitor var2, boolean var3, boolean var4);

    protected static byte[] getLookupSequence(String[] stringArray) {
        String string = ConfigNode.composePath(stringArray);
        byte[] byArray;
        while ((byArray = lookupSequences.get(string)) == null) {
            int n = string.lastIndexOf(46);
            int n2 = string.lastIndexOf(35);
            if ((n = Math.max(n, n2)) < 0) {
                return null;
            }
            string = string.substring(0, n);
        }
        return byArray;
    }

    @Override
    public void putLookupSequence(byte[] byArray, String string) {
        lookupSequences.put(string, byArray);
    }

    protected static String composePath(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuilder.append(stringArray[n]).append('.');
            ++n;
        }
        stringBuilder.append(stringArray[stringArray.length - 1]);
        return stringBuilder.toString();
    }

    @Override
    public void initValue(ConfigLevel configLevel, String[] stringArray, ConfigType configType, String string, String string2) {
        try {
            this.initValue(configLevel, stringArray, 0, configType, string, string2);
        }
        catch (Exception exception) {
            logger.error("failed to initialize config value:" + ConfigNode.composePath(stringArray), (Throwable)exception);
        }
    }

    @Override
    public void scanCache(IConfigurationCacheVisitor iConfigurationCacheVisitor, boolean bl, boolean bl2) {
        this.internalScanCache("", iConfigurationCacheVisitor, bl, bl2);
    }
}

