/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.code;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;

public class SimpleACRCode
implements ACRCode {
    private ACRCode.ACRCodeType acrCodeType;
    private String id;
    private String description;

    public SimpleACRCode(ACRCode.ACRCodeType aCRCodeType, String string, String string2) {
        this.acrCodeType = aCRCodeType;
        this.id = string;
        this.description = string2;
    }

    @Override
    public ACRCode.ACRCodeType getACRCodeType() {
        return this.acrCodeType;
    }

    @Override
    public boolean isCompositeCode() {
        return false;
    }

    @Override
    public boolean isAnatomyCode() {
        return ACRCode.ACRCodeType.ANATOMY_CODE.equals((Object)this.acrCodeType);
    }

    @Override
    public boolean isPathologyCode() {
        return ACRCode.ACRCodeType.PATHOLOGY_CODE.equals((Object)this.acrCodeType);
    }

    @Override
    public ACRCode getPathologyCode() {
        return this.isPathologyCode() ? this : null;
    }

    @Override
    public ACRCode getAnatomyCode() {
        return this.isAnatomyCode() ? this : null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Code getAsDicomCode() {
        return new Code("ACR", this.getId(), this.getDescription());
    }

    public ACRCode[] getSubCodes() {
        return new ACRCode[0];
    }

    @Override
    public boolean hasSubCodes() {
        return false;
    }

    public int getIntegerId() {
        return Integer.parseInt(this.id);
    }

    public static boolean isSimpleId(String string) {
        return string.split(".").length < 2;
    }

    public String toString(boolean bl) {
        String string = this.getId();
        String string2 = this.getDescription();
        return bl ? String.valueOf(string2) + " (" + string + ")" : this.id;
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean equals(Object object) {
        if (object instanceof ACRCode) {
            return this.getId().equals(((ACRCode)object).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

