/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.code;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;

public class CompositeACRCode
implements ACRCode {
    private ACRCode anatomyCode;
    private ACRCode pathologyCode;

    public CompositeACRCode(ACRCode aCRCode, ACRCode aCRCode2) {
        this.anatomyCode = aCRCode;
        this.pathologyCode = aCRCode2;
    }

    @Override
    public ACRCode.ACRCodeType getACRCodeType() {
        return ACRCode.ACRCodeType.COMPOSITE_CODE;
    }

    @Override
    public boolean isCompositeCode() {
        return true;
    }

    @Override
    public boolean isPathologyCode() {
        return false;
    }

    @Override
    public boolean isAnatomyCode() {
        return false;
    }

    @Override
    public ACRCode getAnatomyCode() {
        return this.anatomyCode;
    }

    @Override
    public ACRCode getPathologyCode() {
        return this.pathologyCode;
    }

    public ACRCode[] getSubCodes() {
        if (this.anatomyCode != null && this.pathologyCode != null) {
            return new ACRCode[]{this.anatomyCode, this.pathologyCode};
        }
        if (this.anatomyCode != null) {
            return new ACRCode[]{this.anatomyCode};
        }
        if (this.pathologyCode != null) {
            return new ACRCode[]{this.pathologyCode};
        }
        return new ACRCode[0];
    }

    @Override
    public String getId() {
        String string;
        String string2 = this.anatomyCode != null ? this.anatomyCode.getId() : null;
        String string3 = string = this.pathologyCode != null ? this.pathologyCode.getId() : null;
        if (string2 != null && string != null) {
            return String.valueOf(string2) + "." + string;
        }
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        return "";
    }

    @Override
    public String getDescription() {
        String string;
        String string2 = "";
        String string3 = this.anatomyCode != null ? this.anatomyCode.getDescription() : null;
        String string4 = string = this.pathologyCode != null ? this.pathologyCode.getDescription() : null;
        if (string3 != null && string != null) {
            string2 = String.valueOf(string3) + "." + string;
        } else if (string3 == null) {
            string2 = string;
        } else if (string == null) {
            string2 = string3;
        }
        return string2;
    }

    @Override
    public Code getAsDicomCode() {
        return new Code("ACR", this.getId(), this.getDescription());
    }

    @Override
    public boolean hasSubCodes() {
        return this.anatomyCode != null || this.pathologyCode != null;
    }

    public static boolean isCompositeId(String string) {
        return string.split("\\.").length == 2;
    }

    public static String[] getSimpleIds(String string) {
        return string.split("\\.");
    }

    public boolean equals(Object object) {
        if (object instanceof ACRCode) {
            return this.getId().equals(((ACRCode)object).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        String string = this.getId();
        String string2 = bl ? this.getDescription() : "";
        return bl ? String.valueOf(string2) + " (" + string + ")" : string;
    }
}

