/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCode;
import com.agfa.pacs.listtext.clinicalcode.IClinicalCodeScheme;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.ACRNode;
import com.agfa.pacs.listtext.clinicalcode.acr.code.ACRCodeFactory;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRNodeFactory;

public class ACRClinicalCodeScheme
implements IClinicalCodeScheme {
    public static final String ID = "ACR";
    public static final String NAME = "ACR Coding Scheme";
    private ACRNode rootNode = ACRNodeFactory.createAnatomyRoot();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ACRNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public ACRNode findNodeForCode(IClinicalCode iClinicalCode) {
        return this.rootNode.findNodeForCode((ACRCode)iClinicalCode);
    }

    @Override
    public ACRNode findNodeForCode(String string) {
        ACRCode aCRCode = ACRCodeFactory.createInstance(string);
        if (aCRCode != null) {
            return this.rootNode.findNodeForCode(aCRCode);
        }
        return null;
    }

    @Override
    public ACRNode findNodeForCode(Code code) {
        return this.findNodeForCode(code.getCodeValue());
    }
}

