/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.retriever;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.hw.manager.InputStreamDicomDataReader;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.impaxee.cdviewer.CDLauncher;
import com.agfa.pacs.impaxee.cdviewer.cache.NonPersistentCache;
import com.agfa.pacs.impaxee.cdviewer.retriever.CDDiskPixelDataInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;

public class CDDicomReader
extends InputStreamDicomDataReader {
    private static final NonPersistentCache CD_CACHE = (NonPersistentCache)DataCacheProviderFactory.getCache();
    private static final Set<String> nonCompressedTSUIDs = UIDConfiguration.getInstance().getDefaultTransferSyntaxUIDs();
    private URL originalURL;

    static {
        nonCompressedTSUIDs.add("1.2.840.10008.1.2.2");
    }

    public CDDicomReader(InputStream inputStream, URL uRL, String string, String string2, IDicomDataListener iDicomDataListener) {
        super(inputStream, string, iDicomDataListener, true);
        this.cacheHeaderData = false;
        this.originalURL = uRL;
    }

    private boolean isCompressed(DicomInputStream dicomInputStream, Attributes attributes) {
        if (this.transferSyntaxUID != null) {
            return !nonCompressedTSUIDs.contains(this.transferSyntaxUID);
        }
        return !nonCompressedTSUIDs.contains(attributes.getString(131088));
    }

    protected void readSingleFrame(DicomInputStream dicomInputStream, Attributes attributes, int n, boolean bl) throws IOException {
        if (this.isCompressed(dicomInputStream, attributes)) {
            CDLauncher.errorDialog(CDLauncher.ErrorState.UNSUPPORTED_COMPRESSION, true);
        }
        CDDiskPixelDataInfo cDDiskPixelDataInfo = new CDDiskPixelDataInfo(this.originalURL, dicomInputStream.getPosition(), n, attributes, dicomInputStream.bigEndian() && dicomInputStream.vr() == VR.OW);
        dicomInputStream.skipFully((long)n);
        CD_CACHE.registerPixels(cDDiskPixelDataInfo, this.instanceUID, this.frame);
        this.listener.pixelDataAvailable(this.instanceUID, (IPixelDataInfo)cDDiskPixelDataInfo, this.frame);
    }

    protected void readOWMultiframe(DicomInputStream dicomInputStream, Attributes attributes, int n) throws IOException {
        CDLauncher.errorDialog(CDLauncher.ErrorState.UNSUPPORTED_COMPRESSION, true);
        throw new UnsupportedOperationException("OW Encoding not supported");
    }

    protected void readMultiframe(DicomInputStream dicomInputStream, Attributes attributes, int n) throws IOException {
        if (this.fragmentedData != null && this.fragmentedData.offsetTable != null) {
            CDLauncher.errorDialog(CDLauncher.ErrorState.UNSUPPORTED_COMPRESSION, true);
            throw new UnsupportedOperationException("Not supported format");
        }
        if (this.frame == 0 && this.isCompressed(dicomInputStream, attributes)) {
            CDLauncher.errorDialog(CDLauncher.ErrorState.UNSUPPORTED_COMPRESSION, true);
        }
        CDDiskPixelDataInfo cDDiskPixelDataInfo = new CDDiskPixelDataInfo(this.originalURL, dicomInputStream.getPosition(), n, attributes, dicomInputStream.bigEndian() && dicomInputStream.vr() == VR.OW);
        CD_CACHE.registerPixels(cDDiskPixelDataInfo, this.instanceUID, this.frame);
        dicomInputStream.skipFully((long)n);
        this.listener.pixelDataAvailable(this.instanceUID, (IPixelDataInfo)cDDiskPixelDataInfo, this.frame);
        ++this.frame;
    }
}

