/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.cdviewer.IReportVisualizer;
import com.agfa.pacs.impaxee.cdviewer.Messages;
import com.agfa.pacs.impaxee.cdviewer.ReportPanel;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.listtext.lta.base.PrintRenderer;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.IReportListener;
import com.agfa.pacs.listtext.lta.reports.ReportFactory;
import com.agfa.pacs.listtext.lta.reports.ReportType;
import com.agfa.pacs.listtext.lta.reports.ui.IReportView;
import com.agfa.pacs.listtext.lta.reports.ui.IReportsView;
import com.agfa.pacs.listtext.lta.reports.ui.ReportViewFactory;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.IconLoader;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class CDUI
implements IReportVisualizer {
    private static final float PRINT_FONT_SIZE = 10.0f;
    private static final double MAX_RELATIVE_DIALOG_SIZE = 0.6;
    private static final String ICON_PATH = "/icons/";
    private static final ALogger log = ALogger.getLogger(CDUI.class);
    private List<IReport> reports = null;
    private Map<String, List<IReport>> reportsByPatientKey = null;
    private IReport actualReport = null;
    private IReportView actualReportView = null;
    private IStudyInfo study;
    private JDialog dlg = null;
    private ReportPanel panel;

    public CDUI(List<IPatientInfo> list) {
        this.study = (IStudyInfo)list.get(0).children().get(0);
        this.initReports(list);
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!CDUI.this.reports.isEmpty()) {
                    CDUI.this.panel = new ReportPanel(CDUI.this);
                    JVision2.getMainFrame().setSeriesPaletteToolBarPanel((JPanel)((Object)CDUI.this.panel));
                    DataSelectionManager.getInstance().addListener((IDataSelectionListener)new DataSelectionListenerAdapter(){

                        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
                            CDUI.this.setCurrentPatient(iPatientRepresentation2);
                        }
                    });
                }
            }
        });
    }

    private synchronized void initReports(List<IPatientInfo> list) {
        Object object2;
        this.reports = new ArrayList<IReport>();
        this.reportsByPatientKey = new HashMap<String, List<IReport>>(list.size());
        List list2 = DataInfoUtilities.getLevel(list, IObjectInfo.class);
        LoadingListener loadingListener = new LoadingListener();
        for (Object object2 : list2) {
            if (!ReportFactory.supportsReport((IObjectInfo)object2)) continue;
            try {
                IReport iReport = ReportFactory.createReport((IObjectInfo)object2, (boolean)false);
                if (iReport.getType().equals((Object)ReportType.MammoPreprocessingReport)) continue;
                iReport.addReportListener((IReportListener)loadingListener);
                this.reports.add(iReport);
                String string = object2.getSeries().getStudy().getPatient().getKey();
                List<IReport> list3 = this.reportsByPatientKey.get(string);
                if (list3 == null) {
                    list3 = new ArrayList<IReport>();
                    this.reportsByPatientKey.put(string, list3);
                }
                list3.add(iReport);
            }
            catch (Exception exception) {
                log.error("SR could not be loaded: " + object2);
            }
        }
        object2 = new ReportDateComparator();
        Collections.sort(this.reports, object2);
        for (List list4 : this.reportsByPatientKey.values()) {
            Collections.sort(list4, object2);
        }
    }

    protected void setCurrentPatient(IPatientRepresentation iPatientRepresentation) {
        List<IReport> list = iPatientRepresentation == null ? null : this.reportsByPatientKey.get(iPatientRepresentation.getPatientKey());
        if (list == null || list.isEmpty()) {
            this.panel.setReports(null);
            if (this.dlg != null && this.dlg.isVisible()) {
                this.dlg.setVisible(false);
            }
            this.dlg = null;
        } else {
            this.panel.setReports(list.toArray(new IReport[list.size()]));
            this.selectReport(list.get(0));
        }
    }

    @Override
    public void display() {
        if (this.dlg == null && this.actualReport != null) {
            Component component = this.getActualView().getAWTRootComponent();
            if (component == null) {
                return;
            }
            MainFrame2 mainFrame2 = JVision2.getMainFrame();
            this.dlg = new JDialog((Frame)mainFrame2, Messages.getString("StructuredReports.ReportsTitle"));
            this.dlg.addWindowListener(new MyWindowListener());
            this.dlg.setModal(false);
            this.dlg.getContentPane().add(this.createContentPane(component));
            this.dlg.pack();
            int n = (int)((double)mainFrame2.getWidth() * 0.6);
            int n2 = (int)((double)mainFrame2.getHeight() * 0.6);
            Rectangle rectangle = null;
            if (this.dlg.getBounds().height > n2) {
                rectangle = new Rectangle(this.dlg.getBounds());
                rectangle.height = n2;
            }
            if (this.dlg.getBounds().width > n) {
                if (rectangle == null) {
                    rectangle = new Rectangle(this.dlg.getBounds());
                }
                rectangle.width = n;
            }
            if (rectangle != null) {
                this.dlg.setBounds(rectangle);
            }
            SwingUtilities2.centerOnFrame((Frame)JVision2.getMainFrame(), (Window)this.dlg);
            this.dlg.setVisible(true);
        }
    }

    private JPanel createContentPane(Component component) {
        JButton jButton = SwingUtilities2.createButton((Action)new PrintAction());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "East");
        jPanel.add((Component)new JSeparator(0), "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add(component, "Center");
        return jPanel2;
    }

    public IStudyInfo getAssociatedStudy() {
        return this.study;
    }

    public Iterable<IReport> getReports() {
        return this.reports;
    }

    public Component getVisibleComponent() {
        return this.dlg;
    }

    public void selectReport(IReport iReport) {
        if (this.actualReport != iReport) {
            this.actualReport = iReport;
            if (this.dlg != null) {
                this.dlg.getContentPane().removeAll();
                this.dlg.getContentPane().add(this.createContentPane(this.getActualView().getAWTRootComponent()));
                this.dlg.getContentPane().validate();
                this.dlg.repaint();
            }
        }
    }

    private IReportView getActualView() {
        this.actualReportView = ReportViewFactory.createView((IReportsView)this, (IReport)this.actualReport);
        return this.actualReportView;
    }

    private static class LoadingListener
    implements IReportListener {
        private LoadingListener() {
        }

        public synchronized void loadingReportObjectFinished(IReport iReport) {
            this.notifyAll();
        }

        public void loadingReportObjectStarted(IReport iReport) {
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            CDUI.this.dlg = null;
        }
    }

    private class PrintAction
    extends AbstractAction {
        private static final int ICON_SIZE = 21;

        PrintAction() {
            super("", IconLoader.getScaledIcon((String)"/icons/print.gif", (ClassLoader)PrintAction.class.getClassLoader(), (int)GUI.getScaledInt((int)21), (int)GUI.getScaledInt((int)21)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            JComponent jComponent2;
            String string = null;
            if (CDUI.this.actualReport.getCreationDate() == null) {
                string = Messages.getString("CDUI.NoDateAvailable");
            } else {
                for (JComponent jComponent2 : CDUI.this.reports) {
                    object = jComponent2.getCreationDate();
                    if (object == null || !((Date)object).after(CDUI.this.actualReport.getCreationDate())) continue;
                    string = Messages.getString("CDUI.NotMostRecentReport");
                    break;
                }
            }
            jComponent2 = CDUI.this.actualReportView.getPrintComponent();
            Font font = jComponent2.getFont().deriveFont(10.0f);
            jComponent2.setFont(font);
            object = PrinterJob.getPrinterJob();
            ((PrinterJob)object).setPrintable((Printable)new PrintRenderer(jComponent2, string));
            boolean bl = ((PrinterJob)object).printDialog();
            if (bl) {
                try {
                    ((PrinterJob)object).print();
                }
                catch (PrinterException printerException) {
                    log.error("Printing report failed.", (Throwable)printerException);
                }
            }
        }
    }

    private static class ReportDateComparator
    implements Comparator<IReport> {
        private ReportDateComparator() {
        }

        @Override
        public int compare(IReport iReport, IReport iReport2) {
            Date date = iReport.getCreationDate();
            Date date2 = iReport2.getCreationDate();
            return CompareUtils.compareAdvanced((Comparable)date, (Comparable)date2);
        }
    }
}

