/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.pacs.base.swing.StartupLFCheckpoint;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationSourceFactory;
import com.agfa.pacs.config.IConfigurationSource;
import com.agfa.pacs.config.local.LocalConfigurationSource;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.lw.dicomdir.DicomDirDataInfoNode;
import com.agfa.pacs.data.lw.dicomdir.DicomDirDataInfoNodeIdentifier;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.cdviewer.CDUI;
import com.agfa.pacs.impaxee.cdviewer.CDViewerPreparation;
import com.agfa.pacs.impaxee.cdviewer.CDViewerStudyChooserDialog;
import com.agfa.pacs.impaxee.cdviewer.Messages;
import com.agfa.pacs.impaxee.cdviewer.actions.StudySelectAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.listtext.lta.filter.SimpleFilter;
import com.agfa.pacs.listtext.lta.search.DefaultSearchListener;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import com.agfa.pacs.listtext.swingx.plaf.LookAndFeelManager;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.launcher.ILauncher;
import com.agfa.pacs.login.launcher.LaunchException;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.main.JVision2;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.equinox.app.IApplication;

public class CDLauncher
implements ILauncher {
    private static final ALogger log = ALogger.getLogger(CDLauncher.class);
    private static final boolean CD_CHECK = false;
    public static final String ID = "CD-VIEWER";

    public String getId() {
        return ID;
    }

    public String getDescription() {
        return "CDViewer";
    }

    public ILauncher.LauncherType getType() {
        return ILauncher.LauncherType.Normal;
    }

    public Integer launch() throws LaunchException {
        Object object;
        LookAndFeelManager.getInstance().initLookAndFeel();
        StartupLFCheckpoint.setLFReady();
        if (LayoutConfig.getInstance().getImageAreaWidth() > 1200) {
            Config.impaxee.jvision.TOPTOOLBAR.IconScaleFactor.set((double)1.5);
        }
        DicomDirDataInfoNode dicomDirDataInfoNode = ConfigurationSourceFactory.getConfig();
        int n = ((IConfigurationSource[])dicomDirDataInfoNode).length;
        int n2 = 0;
        while (n2 < n) {
            object = dicomDirDataInfoNode[n2];
            if (object instanceof LocalConfigurationSource) {
                ((LocalConfigurationSource)object).markAsStored();
            }
            ++n2;
        }
        object = new File("DICOMDIR");
        if (!((File)object).exists()) {
            CDLauncher.errorDialog(ErrorState.NO_DICOM_DIR, true);
        }
        try {
            Properties properties = new Properties();
            properties.put("dicomdirURL", ((File)object).toURI().toURL().toString());
            properties.put("read_dicom_files", Boolean.toString(CDViewerPreparation.hasAdvancedHangingProtocols()));
            DicomDirDataInfoNodeIdentifier dicomDirDataInfoNodeIdentifier = new DicomDirDataInfoNodeIdentifier("CD", properties);
            dicomDirDataInfoNode = new DicomDirDataInfoNode(dicomDirDataInfoNodeIdentifier);
            SearchHandler searchHandler = new SearchHandler();
            searchHandler.addDataInfoSource((IDataInfoSource)dicomDirDataInfoNode);
            SimpleFilter simpleFilter = new SimpleFilter("CD");
            DefaultSearchListener defaultSearchListener = new DefaultSearchListener();
            searchHandler.search((IFilter)simpleFilter, (SearchHandlerListener)defaultSearchListener, false);
            final List list = DataInfoUtilities.getLevel((IDataInfo)defaultSearchListener.getRoot(), IPatientInfo.class);
            final Window window = CDLauncher.waitUntilVisible();
            DicomCFindConst.searchLock.await();
            int n3 = 0;
            for (IPatientInfo iPatientInfo : list) {
                n3 += iPatientInfo.getStudies().size();
            }
            boolean bl = true;
            if (Product.isCDViewer()) {
                bl = this.showDialogNotForDiagnost(window);
            }
            if (bl) {
                if (n3 == 1) {
                    ((StudySelectAction)PActionRegistry.getAction((String)"STUDY_SELECT")).setEnabled(false);
                    CycleListProviderFactory.getInstance().getCycleListProvider().addToCycleListAndDisplay(list, false);
                } else {
                    EventUtil.invokeSynchronous((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CDViewerStudyChooserDialog cDViewerStudyChooserDialog = new CDViewerStudyChooserDialog(list, window);
                            GUIMessageHandler.centerSizedWindow((Window)cDViewerStudyChooserDialog);
                            cDViewerStudyChooserDialog.setVisible(true);
                            ((StudySelectAction)PActionRegistry.getAction((String)"STUDY_SELECT")).setEnabled(true);
                        }
                    });
                }
                if (list.size() > 0) {
                    new CDUI(list);
                }
            }
        }
        catch (Exception exception) {
            log.error("Error adding study to cycle list.", (Throwable)exception);
        }
        return IApplication.EXIT_OK;
    }

    private boolean showDialogNotForDiagnost(Window window) {
        JPanel jPanel = ComponentFactory.instance.createPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        JLabel jLabel = ComponentFactory.instance.createLabel(Messages.getString("DialogNotForDiagnost.Title"));
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getSize2D() + 6.0f));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(GUI.getScaledDiagnosticDimension((Dimension)new Dimension(0, 20))));
        JLabel jLabel2 = ComponentFactory.instance.createLabel(Messages.getString("DialogNotForDiagnost.Text"));
        jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getSize2D() + 2.0f));
        jPanel.add(jLabel2);
        Image image = new TIcon("/icons/vendor_image.gif").getImage();
        ImageIcon imageIcon = new ImageIcon(image.getScaledInstance(GUI.getScaledDiagnosticInt((int)(image.getWidth(null) / 2)), GUI.getScaledDiagnosticInt((int)(image.getHeight(null) / 2)), 2));
        Object[] objectArray = new String[]{Messages.getString("DialogNotForDiagnost.Accept"), Messages.getString("DialogNotForDiagnost.Quit")};
        int n = JOptionPane.showOptionDialog(window, jPanel, Product.getProductName(), 2, 2, imageIcon, objectArray, objectArray[1]);
        if (n != 0) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    JVision2.getInstance().exit();
                }
            });
            return false;
        }
        return true;
    }

    public static void errorDialog(ErrorState errorState, boolean bl) {
        CDLauncher.errorDialog(errorState.toString(), bl);
    }

    private static Window waitUntilVisible() {
        List list = null;
        do {
            list = CycleListProviderFactory.getInstance().getCycleListProvider().getAllWindows();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        } while (list == null || list.size() == 0);
        Window window = (Window)list.get(0);
        int n = 0;
        while (!window.isVisible()) {
            try {
                ++n;
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("Waited cycles:" + n);
        return window;
    }

    public static void errorDialog(String string, boolean bl) {
        Window window = CDLauncher.waitUntilVisible();
        JOptionPane.showMessageDialog(window, string, "Error", 0);
        if (bl) {
            System.exit(1);
        }
    }

    public static enum ErrorState {
        NO_DICOM_DIR,
        UNSUPPORTED_COMPRESSION,
        NO_CD;


        public String toString() {
            return Messages.getString(this.name());
        }
    }
}

