/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config.xml.minijaxb;

import com.tiani.config.xml.minijaxb.AbstractXmlElement;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class XmlSaver {
    private static final String newline = "\n";
    private XmlSaveable element;
    private String indent = "";

    public XmlSaver(XmlSaveable xmlSaveable) {
        this.element = xmlSaveable;
    }

    private XmlSaver(XmlSaveable xmlSaveable, String string) {
        this(xmlSaveable);
        this.indent = string;
    }

    public void save(OutputStream outputStream) throws MarshalException, IOException {
        this.save(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    public String toXmlString() throws MarshalException, IOException {
        StringWriter stringWriter = new StringWriter();
        this.save(stringWriter);
        return stringWriter.toString();
    }

    public void save(Writer writer) throws MarshalException, IOException {
        try {
            this.indent.length();
            writer.write(String.valueOf(this.indent) + "<" + this.element.tagName());
            XmlSaveable.NamedValue[] namedValueArray = this.element.attributeValues();
            int n = 0;
            while (namedValueArray != null && n < namedValueArray.length) {
                writer.write(" " + namedValueArray[n].getName() + "='" + namedValueArray[n].getValue() + "'");
                ++n;
            }
            String string = this.element.elementText();
            XmlSaveable.NamedElements[] namedElementsArray = this.element.elementValues();
            if (string != null || namedElementsArray != null && namedElementsArray.length > 0) {
                writer.write(">");
                if (string != null) {
                    writer.write(string);
                } else {
                    writer.write(newline);
                }
                if (namedElementsArray != null) {
                    int n2 = 0;
                    while (n2 < namedElementsArray.length) {
                        XmlSaveable[] xmlSaveableArray = namedElementsArray[n2].getElements();
                        int n3 = 0;
                        while (n3 < xmlSaveableArray.length) {
                            if (xmlSaveableArray[n3] instanceof AbstractXmlElement) {
                                ((AbstractXmlElement)xmlSaveableArray[n3]).defineTagName(namedElementsArray[n2].getName());
                            }
                            new XmlSaver(xmlSaveableArray[n3], String.valueOf(this.indent) + "\t").save(writer);
                            ++n3;
                        }
                        ++n2;
                    }
                }
                writer.write(String.valueOf(string != null ? "" : this.indent) + "</" + this.element.tagName() + ">" + newline);
            } else {
                writer.write(" />\n");
            }
        }
        finally {
            if (this.indent.length() <= 0) {
                writer.close();
            }
        }
    }
}

