/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.config.xml.minijaxb;

import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoadable;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

public abstract class AbstractXmlElement
implements XmlLoadable,
XmlSaveable {
    private static final ALogger log = ALogger.getLogger(AbstractXmlElement.class);
    private static Map<Class<?>, Map<String, MethodRef>> methodCache = new Hashtable(32);

    @Override
    public void defineTagName(String string) {
    }

    @Override
    public void defineAttribute(String string, String string2) throws MarshalException {
        try {
            MethodRef methodRef;
            Class<?> clazz = this.getClass();
            Map<String, MethodRef> map = methodCache.get(clazz);
            if (map == null) {
                map = new Hashtable<String, MethodRef>(16);
                methodCache.put(clazz, map);
            }
            if ((methodRef = map.get(string)) == null) {
                String string3 = this.xmlNameToJavaBaseName(string);
                Method method = clazz.getMethod("get" + string3, new Class[0]);
                Class<?> clazz2 = method.getReturnType();
                Method method2 = clazz.getMethod("set" + string3, clazz2);
                methodRef = new MethodRef(method2, clazz2);
                map.put(string, methodRef);
            }
            methodRef.method.invoke((Object)this, this.convertXmlToObject(string2, methodRef.returnType));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.debug("Resolving XML name failed: " + string);
        }
        catch (Exception exception) {
            throw new MarshalException(exception);
        }
    }

    @Override
    public void appendText(String string) throws MarshalException {
        try {
            String string2 = AbstractXmlElement.classBaseName(this.getClass());
            Method method = this.getClass().getMethod("get" + string2, new Class[0]);
            Class<?> clazz = method.getReturnType();
            Method method2 = this.getClass().getMethod("set" + string2, clazz);
            Object object = this.convertXmlToObject(string, clazz);
            method2.invoke((Object)this, object);
        }
        catch (Exception exception) {
            throw new MarshalException("Receiving text >" + string + "<, exception was: " + exception.toString());
        }
    }

    @Override
    public void appendChild(String string, XmlLoadable xmlLoadable) throws MarshalException {
        this.addToAllChildren(xmlLoadable, false);
        String string2 = this.xmlNameToJavaBaseName(string);
        try {
            Method method = this.getClass().getMethod("add" + string2, xmlLoadable.getClass());
            method.invoke((Object)this, xmlLoadable);
        }
        catch (Exception exception) {
            try {
                Method method = this.getClass().getMethod("set" + string2, xmlLoadable.getClass());
                method.invoke((Object)this, xmlLoadable);
            }
            catch (Exception exception2) {
                throw new MarshalException(exception2);
            }
        }
    }

    protected void addToAllChildren(XmlLoadable xmlLoadable, boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected void addToAllChildren(XmlLoadable xmlLoadable) {
        this.addToAllChildren(xmlLoadable, true);
    }

    protected static String classBaseName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf("$");
        if (n < 0) {
            n = string.lastIndexOf(".");
        }
        return string.substring(n >= 0 ? n + 1 : 0);
    }

    protected String xmlNameToJavaBaseName(String string) {
        return XmlUtil.xmlNameToJavaBaseName(string);
    }

    protected Object convertXmlToObject(String string, Class<?> clazz) throws MarshalException {
        if (clazz.equals(String.class)) {
            return string;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.valueOf(string);
        }
        if (clazz.equals(Double.class)) {
            return Double.valueOf(string);
        }
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            return method.invoke(null, string);
        }
        catch (Exception exception) {
            try {
                Method method = clazz.getMethod("parse", String.class);
                return method.invoke(null, string);
            }
            catch (Exception exception2) {
                log.error("AbstractReflectionXmlElement", (Throwable)exception);
                throw new MarshalException(exception);
            }
        }
    }

    @Override
    public abstract String tagName();

    @Override
    public XmlSaveable.NamedValue[] attributeValues() throws MarshalException {
        String[] stringArray = this.attributeNames();
        ArrayList<ReflectionNameValue> arrayList = new ArrayList<ReflectionNameValue>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = "get" + this.xmlNameToJavaBaseName(stringArray[n]);
            try {
                String string2;
                Method method = this.getClass().getMethod(string, new Class[0]);
                Object object = method.invoke((Object)this, new Object[0]);
                if (object != null && (string2 = this.convertObjectToXml(object)) != null && string2.length() > 0) {
                    arrayList.add(new ReflectionNameValue(stringArray[n], string2));
                }
            }
            catch (MarshalException marshalException) {
                throw marshalException;
            }
            catch (Exception exception) {
                throw new MarshalException(exception);
            }
            ++n;
        }
        return arrayList.toArray(new XmlSaveable.NamedValue[arrayList.size()]);
    }

    protected String[] attributeNames() {
        Method[] methodArray = this.getClass().getMethods();
        ArrayList<String> arrayList = new ArrayList<String>(methodArray.length);
        String string = AbstractXmlElement.classBaseName(this.getClass());
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string2 = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            if (!(!string2.startsWith("get") || string2.equals("getClass") || clazz.isArray() || method.isBridge() && method.isSynthetic() || string2.equals("get" + string) || XmlLoadable.class.isAssignableFrom(clazz) || classArray != null && classArray.length > 0)) {
                String string3 = string2.substring("get".length());
                arrayList.add(this.javaBaseNameToXmlName(string3));
            }
            if (method.isBridge() && !method.isSynthetic()) {
                log.warn("Found a method that is a bridge but not synthetic: " + method);
            }
            ++n;
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public XmlSaveable.NamedElements[] elementValues() throws MarshalException {
        String[] stringArray = this.elementNames();
        ArrayList<ReflectionNameElements> arrayList = new ArrayList<ReflectionNameElements>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            XmlSaveable[] xmlSaveableArray;
            Object object;
            String string = "get" + this.xmlNameToJavaBaseName(stringArray[n]);
            int n2 = 0;
            try {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                do {
                    xmlSaveableArray = this.getClass().getMethod(string, Integer.TYPE);
                    object = (XmlSaveable)xmlSaveableArray.invoke((Object)this, new Integer(n2));
                    if (object != null) {
                        arrayList2.add(object);
                    }
                    ++n2;
                } while (object != null);
                xmlSaveableArray = arrayList2.toArray(new XmlSaveable[arrayList2.size()]);
                arrayList.add(new ReflectionNameElements(stringArray[n], xmlSaveableArray));
            }
            catch (Exception exception) {
                if (exception instanceof IndexOutOfBoundsException) {
                    log.warn("You should implement a index-safe " + string + "(int) method!");
                }
                if (n2 <= 0) {
                    try {
                        object = this.getClass().getMethod(string, new Class[0]);
                        xmlSaveableArray = (XmlSaveable)((Method)object).invoke((Object)this, new Object[0]);
                        if (xmlSaveableArray != null) {
                            arrayList.add(new ReflectionNameElements(stringArray[n], new XmlSaveable[]{xmlSaveableArray}));
                        }
                    }
                    catch (Exception exception2) {
                        throw new MarshalException(exception2);
                    }
                }
                throw new MarshalException(exception);
            }
            ++n;
        }
        return arrayList.toArray(new XmlSaveable.NamedElements[arrayList.size()]);
    }

    protected String[] elementNames() {
        Method[] methodArray = this.getClass().getMethods();
        ArrayList<String> arrayList = new ArrayList<String>(methodArray.length);
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            if (string.startsWith("get") && !clazz.isArray() && XmlLoadable.class.isAssignableFrom(clazz) && (classArray == null || classArray.length <= 0 || classArray.length == 1 && classArray[0].equals(Integer.TYPE))) {
                String string2 = string.substring("get".length());
                arrayList.add(this.javaBaseNameToXmlName(string2));
            }
            ++n;
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String elementText() {
        try {
            String string = AbstractXmlElement.classBaseName(this.getClass());
            Method method = this.getClass().getMethod("get" + string, new Class[0]);
            if (method.getReturnType().equals(String.class)) {
                return this.convertObjectToXml(method.invoke((Object)this, new Object[0]));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected String javaBaseNameToXmlName(String string) {
        return XmlUtil.javaBaseNameToXmlName(string);
    }

    protected String convertObjectToXml(Object object) throws MarshalException {
        return object == null ? "" : XmlUtil.textToXml(object.toString());
    }

    private static class MethodRef {
        public final Method method;
        public final Class<?> returnType;

        public MethodRef(Method method, Class<?> clazz) {
            this.method = method;
            this.returnType = clazz;
        }
    }

    private static class ReflectionNameElements
    implements XmlSaveable.NamedElements {
        private String name;
        private XmlSaveable[] elements;

        ReflectionNameElements(String string, XmlSaveable[] xmlSaveableArray) {
            this.name = string;
            this.elements = xmlSaveableArray;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public XmlSaveable[] getElements() {
            return this.elements;
        }
    }

    private static class ReflectionNameValue
    implements XmlSaveable.NamedValue {
        private String name;
        private String value;

        ReflectionNameValue(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

