/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.util.Product;
import com.sun.jna.platform.KeyboardUtils;
import java.awt.MouseInfo;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class ModifierKeys {
    public static final boolean disableFastImageInteraction = Boolean.parseBoolean(System.getProperty("disableFastInteraction"));
    private static final int MAX_MOUSE_BUTTONS = Product.isHeadless() ? -1 : MouseInfo.getNumberOfButtons();
    private static final int FOURTH_BUTTON_MASK = MAX_MOUSE_BUTTONS > 3 ? MouseEvent.getMaskForButton(4) : -1;
    private static final int FIFTH_BUTTON_MASK = MAX_MOUSE_BUTTONS > 4 ? MouseEvent.getMaskForButton(5) : -1;

    public static final boolean isLMB(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isSpacePressed() {
        return KeyboardUtils.isPressed((int)32) && !disableFastImageInteraction;
    }

    public static boolean isSpaceOr4thMButton(MouseEvent mouseEvent) {
        if (ModifierKeys.isSpacePressed()) {
            return true;
        }
        return FOURTH_BUTTON_MASK > 0 && (mouseEvent.getModifiersEx() & FOURTH_BUTTON_MASK) == FOURTH_BUTTON_MASK || mouseEvent.getButton() == 4;
    }

    public static final boolean is5MButton(MouseEvent mouseEvent) {
        return FIFTH_BUTTON_MASK > 0 && (mouseEvent.getButton() == 5 || (mouseEvent.getModifiersEx() & FIFTH_BUTTON_MASK) == FIFTH_BUTTON_MASK);
    }

    public static final boolean isRMB(MouseEvent mouseEvent) {
        return mouseEvent != null && (mouseEvent.getModifiers() & 4) != 0;
    }

    public static final boolean isMMB(MouseEvent mouseEvent) {
        return mouseEvent != null && (mouseEvent.getModifiers() & 8) != 0 && !ModifierKeys.isLMB(mouseEvent) && !ModifierKeys.isRMB(mouseEvent);
    }

    public static boolean isAlt() {
        return KeyboardUtils.isPressed((int)18);
    }

    public static boolean isCtrl() {
        return KeyboardUtils.isPressed((int)17);
    }

    public static boolean isCtrl(InputEvent inputEvent) {
        return (inputEvent.getModifiersEx() & 0x80) == 128;
    }

    public static boolean isScrollLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(145);
    }
}

