/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.logging.ALogger;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class IconFactory {
    private static final ALogger log = ALogger.getLogger(IconFactory.class);
    public static final String ICON_CANCEL_PRESSED = "CANCEL_PRESSED";
    public static final String ICON_CANCEL = "CANCEL";
    public static final String ICON_EXIT = "EXIT";
    private static volatile boolean initialised = false;

    private static void init() {
        try {
            EventUtil.invokeSynchronous(new Runnable(){

                @Override
                public void run() {
                    if (!initialised) {
                        IconFactory.initIcons();
                        initialised = true;
                    }
                }
            });
        }
        catch (Exception exception) {
            log.warn("Error", (Throwable)exception);
        }
    }

    public static Icon getIcon(String string) {
        if (!initialised) {
            IconFactory.init();
        }
        return IconFactory.getScaledIcon(string, -1);
    }

    public static Icon getScaledIcon(String string, int n) {
        Icon icon;
        if (!initialised) {
            IconFactory.init();
        }
        if ((icon = UIManager.getIcon(string)) instanceof ImageIcon && n > 0) {
            icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(n, n, 2));
        }
        return icon;
    }

    public static Icon[] getIcons(String string) {
        if (!initialised) {
            IconFactory.init();
        }
        return IconFactory.getScaledIcons(string, -1);
    }

    public static Icon[] getScaledIcons(String string, int n) {
        if (!initialised) {
            IconFactory.init();
        }
        ArrayList<Icon> arrayList = new ArrayList<Icon>();
        Icon icon = IconFactory.getIcon(string);
        if (icon != null) {
            arrayList.add(icon);
        }
        int n2 = 0;
        while (n2 < 100) {
            Icon icon2;
            String string2 = String.valueOf(string) + "." + Integer.toString(n2);
            Icon icon3 = icon2 = n <= 0 ? IconFactory.getIcon(string2) : IconFactory.getScaledIcon(string2, n);
            if (icon2 == null) break;
            arrayList.add(icon2);
            ++n2;
        }
        return arrayList.toArray(new Icon[arrayList.size()]);
    }

    protected static void initIcons() {
        String string = "/icons/";
        IconFactory.initIcon(ICON_EXIT, String.valueOf(string) + "exit.gif");
        IconFactory.initIcon(ICON_CANCEL, String.valueOf(string) + "cancel.gif");
        IconFactory.initIcon(ICON_CANCEL_PRESSED, String.valueOf(string) + "cancel_pressed.gif");
    }

    protected static void initIcon(String string, String string2) {
        try {
            Icon icon = IconFactory.loadIcon(string2);
            UIManager.put(string, icon);
        }
        catch (Exception exception) {
            log.warn("Loading icon failed! (" + string2 + ")");
        }
    }

    protected static Icon loadIcon(String string) throws InterruptedException, IOException {
        try {
            URL uRL = IconFactory.class.getResource(string);
            Image image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
            MediaTracker mediaTracker = new MediaTracker(new Panel());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            return new ImageIcon(image);
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }
}

