/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.MenuElement;

public abstract class ComponentUtil {
    public static Component getTopLevelParentOrWindow(Component component) {
        if (component == null) {
            return component;
        }
        Component component2;
        while (!((component2 = ComponentUtil.getParentExtended(component)) instanceof Window)) {
            if (component2 == null) {
                return component;
            }
            component = component2;
        }
        return component2;
    }

    public static Window getWindowForActionSource(Object object) {
        if (object instanceof Component) {
            return ComponentUtil.getWindowForComponent((Component)object);
        }
        return null;
    }

    public static Window getWindowForComponent(Component component) {
        Component component2 = ComponentUtil.getTopClassForComponent(component, Window.class);
        if (component2 instanceof Window) {
            return (Window)component2;
        }
        return null;
    }

    public static Component getTopClassForComponent(Component component, Class<?> clazz) {
        Component component2 = component;
        while (!(component == null || clazz != null && clazz.isAssignableFrom(component.getClass()))) {
            component2 = component;
            component = ComponentUtil.getParentExtended(component);
        }
        Component component3 = component == null ? component2 : component;
        return clazz == null || component3 != null && clazz.isAssignableFrom(component3.getClass()) ? component3 : null;
    }

    private static Component getParentExtended(Component component) {
        if (component instanceof MenuElement) {
            component = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : ((MenuElement)((Object)component)).getComponent();
        }
        return component == null ? null : component.getParent();
    }

    public static Component getDeepComponentAt(Container container, Point point) {
        int n = point.x;
        int n2 = point.y;
        Container container2 = container;
        Component component = null;
        while (container2 != null) {
            JTabbedPane jTabbedPane;
            int n3;
            component = container2 instanceof JRootPane ? ((JRootPane)container2).getContentPane() : (container2 instanceof JTabbedPane ? ((n3 = (jTabbedPane = (JTabbedPane)container2).indexAtLocation(n, n2)) < 0 || n3 >= jTabbedPane.getTabCount() ? jTabbedPane.getSelectedComponent() : jTabbedPane.getComponentAt(n3)) : container2.getComponentAt(n -= container2.getX(), n2 -= container2.getY()));
            if (component instanceof Container && container2 != component) {
                container2 = component;
                continue;
            }
            if (component == null && container2.getParent() instanceof JTabbedPane) {
                return container2;
            }
            container2 = null;
        }
        return component;
    }

    public static int getComponentIndex(Container container, Component component) {
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component2 = container.getComponent(n);
            if (component2 == component) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void replaceComponent(Container container, Component component, Component component2) {
        int n = ComponentUtil.getComponentIndex(container, component);
        container.remove(n);
        container.add(component2, n);
    }

    public static void invalidateRecursive(Component component) {
        component.invalidate();
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                ComponentUtil.invalidateRecursive(component2);
                ++n2;
            }
        }
    }
}

