/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.imagednd;

import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public abstract class AbstractImageDragAndDropTransferHandler
extends TransferHandler {
    private static SwingDragGestureRecognizer recognizer;

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        int n2 = this.getSourceActions(jComponent);
        if (!(inputEvent instanceof MouseEvent) || n != 1 && n != 2 && n != 0x40000000 || (n2 & n) == 0) {
            n = 0;
        }
        if (n != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new SwingDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(jComponent, (MouseEvent)inputEvent, n2, n);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    protected abstract void startImageDragAndDrop(JComponent var1, DragSource var2, Point var3, Transferable var4);

    private class DragHandler
    extends DragSourceAdapter
    implements DragGestureListener {
        private boolean scrolls;

        private DragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
            AbstractImageDragAndDropTransferHandler abstractImageDragAndDropTransferHandler = (AbstractImageDragAndDropTransferHandler)jComponent.getTransferHandler();
            Transferable transferable = abstractImageDragAndDropTransferHandler.createTransferable(jComponent);
            if (transferable != null) {
                this.scrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
                try {
                    dragGestureEvent.startDrag(null, transferable, this);
                    AbstractImageDragAndDropTransferHandler.this.startImageDragAndDrop(jComponent, dragGestureEvent.getDragSource(), dragGestureEvent.getDragOrigin(), transferable);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    jComponent.setAutoscrolls(this.scrolls);
                }
            }
            abstractImageDragAndDropTransferHandler.exportDone(jComponent, transferable, 0);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JComponent jComponent = (JComponent)dragSourceContext.getComponent();
            AbstractImageDragAndDropTransferHandler abstractImageDragAndDropTransferHandler = (AbstractImageDragAndDropTransferHandler)jComponent.getTransferHandler();
            if (dragSourceDropEvent.getDropSuccess()) {
                abstractImageDragAndDropTransferHandler.exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                abstractImageDragAndDropTransferHandler.exportDone(jComponent, dragSourceContext.getTransferable(), 0);
            }
            jComponent.setAutoscrolls(this.scrolls);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dragGestureListener) {
            super(DragSource.getDefaultDragSource(), null, 0, dragGestureListener);
        }

        void gestured(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }
}

