/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.busylabel;

import com.agfa.pacs.base.swing.busylabel.Contract;
import com.agfa.pacs.base.swing.busylabel.Painter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Shape;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class UIManagerExt {
    private static UIDefaultsExt uiDefaultsExt = new UIDefaultsExt();

    private UIManagerExt() {
    }

    public static void addResourceBundle(String string) {
        uiDefaultsExt.addResourceBundle(string);
    }

    public static void removeResourceBundle(String string) {
        uiDefaultsExt.removeResourceBundle(string);
    }

    public static String getString(Object object) {
        return UIManagerExt.getString(object, null);
    }

    public static String getString(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof String) {
            return (String)object2;
        }
        if (object2 == null && (object2 = UIManagerExt.uiDefaultsExt.getFromResourceBundle(object, locale)) instanceof String) {
            return (String)object2;
        }
        return null;
    }

    public static int getInt(Object object) {
        return UIManagerExt.getInt(object, null);
    }

    public static int getInt(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 == null) {
            object2 = UIManagerExt.uiDefaultsExt.getFromResourceBundle(object, locale);
            if (object2 instanceof Integer) {
                return (Integer)object2;
            }
            if (object2 instanceof String) {
                try {
                    return Integer.decode((String)object2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return 0;
    }

    public static boolean getBoolean(Object object) {
        return UIManagerExt.getBoolean(object, null);
    }

    public static boolean getBoolean(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        if (object2 == null) {
            object2 = UIManagerExt.uiDefaultsExt.getFromResourceBundle(object, locale);
            if (object2 instanceof Boolean) {
                return (Boolean)object2;
            }
            if (object2 instanceof String) {
                return Boolean.valueOf((String)object2);
            }
        }
        return false;
    }

    public static Color getColor(Object object) {
        return UIManagerExt.getColor(object, null);
    }

    public static Color getColor(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Color) {
            return (Color)object2;
        }
        if (object2 == null) {
            object2 = UIManagerExt.uiDefaultsExt.getFromResourceBundle(object, locale);
            if (object2 instanceof Color) {
                return (Color)object2;
            }
            if (object2 instanceof String) {
                try {
                    return Color.decode((String)object2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return null;
    }

    public static Shape getShape(Object object) {
        Object object2 = UIManager.getDefaults().get(object);
        return object2 instanceof Shape ? (Shape)object2 : null;
    }

    public static Shape getShape(Object object, Locale locale) {
        Object object2 = UIManager.getDefaults().get(object, locale);
        return object2 instanceof Shape ? (Shape)object2 : null;
    }

    public static Painter<?> getPainter(Object object) {
        Object object2 = UIManager.getDefaults().get(object);
        return object2 instanceof Painter ? (Painter)object2 : null;
    }

    public static Painter<?> getPainter(Object object, Locale locale) {
        Object object2 = UIManager.getDefaults().get(object, locale);
        return object2 instanceof Painter ? (Painter)object2 : null;
    }

    public static Border getSafeBorder(Object object, Border border) {
        Contract.asNotNull(border, "defaultBorder cannot be null");
        Border border2 = UIManager.getBorder(object);
        if (border2 == null) {
            border2 = border;
        }
        if (!(border2 instanceof UIResource)) {
            border2 = new BorderUIResource(border2);
        }
        return border2;
    }

    public static Color getSafeColor(Object object, Color color) {
        Contract.asNotNull(color, "defaultColor cannot be null");
        Color color2 = UIManager.getColor(object);
        if (color2 == null) {
            color2 = color;
        }
        if (!(color2 instanceof UIResource)) {
            color2 = new ColorUIResource(color2);
        }
        return color2;
    }

    public static Dimension getSafeDimension(Object object, Dimension dimension) {
        Contract.asNotNull(dimension, "defaultDimension cannot be null");
        Dimension dimension2 = UIManager.getDimension(object);
        if (dimension2 == null) {
            dimension2 = dimension;
        }
        if (!(dimension2 instanceof UIResource)) {
            dimension2 = new DimensionUIResource(dimension2.width, dimension2.height);
        }
        return dimension2;
    }

    public static Font getSafeFont(Object object, Font font) {
        Contract.asNotNull(font, "defaultFont cannot be null");
        Font font2 = UIManager.getFont(object);
        if (font2 == null) {
            font2 = font;
        }
        if (!(font2 instanceof UIResource)) {
            font2 = new FontUIResource(font2);
        }
        return font2;
    }

    public static Icon getSafeIcon(Object object, Icon icon) {
        Contract.asNotNull(icon, "defaultIcon cannot be null");
        Icon icon2 = UIManager.getIcon(object);
        if (icon2 == null) {
            icon2 = icon;
        }
        if (!(icon2 instanceof UIResource)) {
            icon2 = new IconUIResource(icon2);
        }
        return icon2;
    }

    public static Insets getSafeInsets(Object object, Insets insets) {
        Contract.asNotNull(insets, "defaultInsets cannot be null");
        Insets insets2 = UIManager.getInsets(object);
        if (insets2 == null) {
            insets2 = insets;
        }
        if (!(insets2 instanceof UIResource)) {
            insets2 = new InsetsUIResource(insets2.top, insets2.left, insets2.bottom, insets2.right);
        }
        return insets2;
    }

    private static class UIDefaultsExt {
        private Vector<String> resourceBundles;
        private Map<Locale, Map<String, String>> resourceCache = new HashMap<Locale, Map<String, String>>();

        UIDefaultsExt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getFromResourceBundle(Object object, Locale locale) {
            if (this.resourceBundles == null || this.resourceBundles.isEmpty() || !(object instanceof String)) {
                return null;
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            UIDefaultsExt uIDefaultsExt = this;
            synchronized (uIDefaultsExt) {
                return this.getResourceCache(locale).get((String)object);
            }
        }

        private Map<String, String> getResourceCache(Locale locale) {
            Map<String, String> map = this.resourceCache.get(locale);
            if (map == null) {
                map = new HashMap<String, String>();
                int n = this.resourceBundles.size() - 1;
                while (n >= 0) {
                    String string = this.resourceBundles.get(n);
                    try {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, UIManagerExt.class.getClassLoader());
                        Enumeration<String> enumeration = resourceBundle.getKeys();
                        while (enumeration.hasMoreElements()) {
                            String string2 = enumeration.nextElement();
                            if (map.get(string2) != null) continue;
                            Object object = resourceBundle.getObject(string2);
                            map.put(string2, (String)object);
                        }
                    }
                    catch (MissingResourceException missingResourceException) {}
                    --n;
                }
                this.resourceCache.put(locale, map);
            }
            return map;
        }

        public synchronized void addResourceBundle(String string) {
            if (string == null) {
                return;
            }
            if (this.resourceBundles == null) {
                this.resourceBundles = new Vector(5);
            }
            if (!this.resourceBundles.contains(string)) {
                this.resourceBundles.add(string);
                this.resourceCache.clear();
            }
        }

        public synchronized void removeResourceBundle(String string) {
            if (this.resourceBundles != null) {
                this.resourceBundles.remove(string);
            }
            this.resourceCache.clear();
        }
    }
}

