/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic;

import com.agfa.pacs.base.lic.ILicense;
import com.agfa.pacs.base.lic.impl.LicenseImpl;
import com.agfa.pacs.base.lic.impl.LicenseUtilities;
import com.agfa.pacs.base.lic.impl.LocalLicenseChecker;
import com.agfa.pacs.base.lic.impl.MACReader;
import com.agfa.pacs.base.lic.xml.License;
import com.agfa.pacs.base.lic.xml.LicenseFileType;
import com.agfa.pacs.base.lic.xml.LicenseTicket;
import com.agfa.pacs.base.lic.xml.LicensesType;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.IURLProvider;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.StreamUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class LicenseManager {
    private static final ALogger log = ALogger.getLogger(LicenseManager.class);
    private static final String CHARSET = "UTF8";
    private static final String OFFLINE_LICENSE_FILE = ".offlineLic.xml";
    private static boolean isOffline = false;
    private static boolean useSession = true;
    private static LicenseManager instance = null;
    private String server;
    private String role;
    private String ip;
    private String mac;
    private String sessionID;
    private Set<String> supportedIDs = Collections.emptySet();
    private String user;
    private HashMap<String, LicenseImpl> licenses = new HashMap();

    public static void setDoNotUseSession() {
        useSession = false;
    }

    public static synchronized LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    private LicenseManager() {
        this.ip = LicenseUtilities.determineMachine();
        this.mac = MACReader.getInstance().getMAC();
        this.user = URLProviderFactory.getProvider().getLoginInformation().getUserID();
        long l = ThreadLocalRandom.current().nextLong();
        if (useSession) {
            this.sessionID = Long.toHexString(l);
        }
        if (isOffline) {
            File file = LicenseManager.getOfflineLicenseFile();
            if (file.exists()) {
                this.initOffline(file);
            }
        } else if (!ConfigurationProviderFactory.getConfig().isSupportingRoles() || this.isLocalLicenseActivated() || Product.isInEmergencyMode()) {
            this.server = null;
            this.initLocal();
        } else {
            IURLProvider iURLProvider = URLProviderFactory.getProvider();
            this.role = iURLProvider.getLoginInformation().getRole();
            this.server = String.valueOf(iURLProvider.getServerUrl()) + "Licensing/licensing";
            this.supportedIDs = LicenseUtilities.querySupported(this.server, this.mac, this.role);
            if (this.sessionID != null) {
                LicenseUtilities.startPinging(this.server, this.sessionID);
            }
        }
    }

    public static boolean existsOfflineLicenseFile() {
        return LicenseManager.getOfflineLicenseFile().exists();
    }

    private static File getOfflineLicenseFile() {
        File file = new File(Platform.getConfigurationLocation().getURL().getFile(), "pacs");
        File file2 = new File(file, OFFLINE_LICENSE_FILE);
        return file2;
    }

    private void initOffline(File file) {
        ObjectInputStream objectInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(fileInputStream);
            this.supportedIDs = new HashSet<String>();
            while (true) {
                Object object;
                if (!((object = objectInputStream.readObject()) instanceof LicenseImpl)) {
                    continue;
                }
                LicenseImpl licenseImpl = (LicenseImpl)object;
                this.licenses.put(licenseImpl.getLicense().getId(), licenseImpl);
                this.supportedIDs.add(licenseImpl.getLicense().getId());
            }
        }
        catch (EOFException eOFException) {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
            return;
        }
        catch (Exception exception) {
            try {
                log.error("Problem reading licenses", (Throwable)exception);
            }
            catch (Throwable throwable) {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isLocalLicenseActivated() {
        return "true".equals(System.getProperty("preferLocalLicense"));
    }

    private void initLocal() {
        File file = new File("License.xml");
        if (!file.exists()) {
            log.error("No local license available");
            return;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, CHARSET);
            String string = StreamUtil.readStream((Reader)inputStreamReader);
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            LicenseFileType licenseFileType = new LicenseFileType(document.getDocumentElement());
            HashSet<String> hashSet = new HashSet<String>();
            Calendar calendar = Calendar.getInstance();
            if (LocalLicenseChecker.checkLicense(string, licenseFileType)) {
                LicensesType licensesType = licenseFileType.getLicenses();
                for (License license : licensesType.getLicense()) {
                    if (license.getDueDate() != null && license.getDueDate().toGregorianCalendar().before(calendar)) continue;
                    this.licenses.put(license.getId(), new LicenseImpl(licensesType.getIssuer(), license, null));
                    hashSet.add(license.getId());
                }
                this.supportedIDs = Collections.unmodifiableSet(hashSet);
            } else {
                log.error("Found no valid license file");
            }
        }
        catch (Exception exception) {
            log.error("Could not parse license file", (Throwable)exception);
        }
    }

    public synchronized void synchronizeLicenses(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(this.licenses.keySet());
        for (String string : hashSet) {
            if (set.contains(string)) continue;
            this.releaseLicense(string);
        }
        for (String string : set) {
            if (this.licenses.containsKey(string)) continue;
            this.getLicense(string);
        }
    }

    public synchronized ILicense getLicense(String string) {
        LicenseImpl licenseImpl = this.licenses.get(string);
        if (licenseImpl != null) {
            return licenseImpl;
        }
        LicenseTicket licenseTicket = LicenseUtilities.query(this.server, string, this.ip, this.mac, this.role, this.sessionID, this.user);
        if (licenseTicket == null) {
            log.debug("License could not be obtained for:" + string);
            return null;
        }
        if (!LicenseUtilities.checkLicense(licenseTicket)) {
            ALogger.getLogger(LicenseManager.class).error("Tampered ticket");
            return null;
        }
        if (!string.equals(licenseTicket.getLicense().getId())) {
            return null;
        }
        licenseImpl = new LicenseImpl(licenseTicket.getIssuer(), licenseTicket.getLicense(), licenseTicket.getTicket());
        this.licenses.put(string, licenseImpl);
        return licenseImpl;
    }

    public synchronized void releaseLicense(ILicense iLicense) {
        if (this.server == null) {
            return;
        }
        this.licenses.remove(iLicense.getLicense().getId());
        LicenseUtilities.unregister(this.server, ((LicenseImpl)iLicense).getTicket(), iLicense.getLicense().getId());
    }

    public synchronized void releaseLicense(String string) {
        LicenseImpl licenseImpl;
        if (!isOffline && (licenseImpl = this.licenses.get(string)) != null) {
            this.releaseLicense(licenseImpl);
        }
    }

    public synchronized void releaseAllLicenses() {
        File file = LicenseManager.getOfflineLicenseFile();
        if (!isOffline) {
            LinkedList<LicenseImpl> linkedList = new LinkedList<LicenseImpl>(this.licenses.values());
            for (LicenseImpl licenseImpl : linkedList) {
                this.releaseLicense(licenseImpl);
            }
            if (file.exists()) {
                file.delete();
            }
        } else {
            LinkedList<LicenseImpl> linkedList = new LinkedList<LicenseImpl>(this.licenses.values());
            if (!file.exists()) {
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                    for (LicenseImpl licenseImpl : linkedList) {
                        objectOutputStream.writeObject(licenseImpl);
                    }
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    log.error("Could not store licenses", (Throwable)exception);
                }
            }
        }
        this.licenses.clear();
    }

    public static void setOffline(boolean bl) {
        isOffline = bl;
    }

    public Iterable<String> getSupportedLicenseIDs() {
        return this.supportedIDs;
    }

    public boolean isLicenseIDSupported(String string) {
        if (this.supportedIDs == null) {
            return true;
        }
        return this.supportedIDs.contains(string);
    }

    public boolean isLicensePresent(String string) {
        if (this.supportedIDs == null) {
            return false;
        }
        return this.supportedIDs.contains(string);
    }
}

