<?xml version="1.0" encoding="UTF-8"?>
<!--
"ELGA Referenz-Stylesheet" - Hinweise zur Nutzung

Das "ELGA Referenz-Stylesheet" ermöglicht eine allgemeine, einheitliche und benutzerfreundliche Darstellung von medizinischen CDA-Dokumenten (HL7 CDA Release 2.0),
die als gemäß der Vorgaben der ELGA CDA Implementierungsleitfäden erstellt wurden. Das "ELGA Referenz-Stylesheet" wurde auf Grundlage von Vorarbeiten der Firmen
"USECON The Usability Consultants" und "NETCONOMY Software & Consulting GmbH" unter Leitung der ELGA GmbH von Arbeitsgruppen zur Harmonisierung
der CDA Implementierungsleitfäden gemäß dem Stand der Technik und unter Anwendung der größtmöglichen Sorgfalt auf seine Anwendbarkeit getestet und überprüft.

Das "ELGA Referenz-Stylesheet" wird von der ELGA GmbH bis auf Widerruf unentgeltlich und nicht-exklusiv sowie zeitlich und örtlich unbegrenzt, jedoch beschränkt auf
Verwendungen für die Zwecke der "Clinical Document Architecture" (CDA) zur Verfügung gestellt. Veränderungen des "ELGA Referenz-Stylesheet" für die lokale
Verwendung sind zulässig. Derartige Veränderungen (sogenannte bearbeitete Fassungen) dürfen ihrerseits publiziert und Dritten zur Weiterverwendung und Bearbeitung zur Verfügung
gestellt werden. Bei der Veröffentlichung von bearbeiteten Fassungen ist darauf hinzuweisen, dass diese auf Grundlage des von der ELGA GmbH publizierten
"ELGA Referenz-Stylesheet" erstellt wurden.

Die Anwendung sowie die allfällige Bearbeitung des "ELGA Referenz-Stylesheet" erfolgt in ausschließlicher Verantwortung der AnwenderInnen.
Aus der Veröffentlichung, Verwendung und/oder Bearbeitung können keinerlei Rechtsansprüche gegen die ELGA GmbH erhoben oder abgeleitet werden.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" id="ELGA Referenzstylesheet 1.01.009 RC">
  <xsl:output method="html" omit-xml-declaration="yes" indent="yes" version="1.0" encoding="utf-8" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

  <!--
  global variables for the document
  (document title, language, patient sex, gendered patient title)
   -->
  <xsl:variable name="title">
    <xsl:choose>
      <xsl:when test="/n1:ClinicalDocument/n1:title">
        <xsl:value-of select="/n1:ClinicalDocument/n1:title"/>
      </xsl:when>
      <xsl:otherwise>Clinical Document</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="language"><xsl:value-of select="/n1:ClinicalDocument/n1:languageCode/@code" /></xsl:variable>
  <xsl:variable name="sex" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:administrativeGenderCode/@code"/>
  <xsl:variable name="genderedpatient">
    <xsl:choose>
      <xsl:when test="$sex='M'"><xsl:text>Patient</xsl:text></xsl:when>
      <xsl:when test="$sex='F'"><xsl:text>Patientin</xsl:text></xsl:when>
      <xsl:otherwise><xsl:text>Patient(in)</xsl:text></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:template match="/">
    <xsl:apply-templates select="n1:ClinicalDocument"/>
  </xsl:template>

  <xsl:template match="n1:ClinicalDocument">

    <html xmlns="http://www.w3.org/1999/xhtml" lang="{$language}" xml:lang="{$language}">
    <!--
      HTML Head
      Document title and patient name is shown in browser tab
    -->
      <head>
        <meta http-equiv="X-UA-Compatible" content="IE=8; chrome=1" />
        <xsl:comment> Do NOT edit this HTML directly, it was generated via an XSL transformation from the original release 2 CDA Document. </xsl:comment>
        <title>
          <xsl:value-of select="$title"/> | <xsl:value-of select="$genderedpatient" />:
          <xsl:call-template name="getName">
            <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name"/>
          </xsl:call-template>
        </title>
        <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
        <style type="text/css" media="screen,print">
body {
  font-family: Arial, sans-serif;
  font-size: 100%;
  line-height: 130%;
  color: black;
  background-color: white;


}

.outerContainer {

}

.bodyContentContainer {
  width: 900px;
  margin: 0 auto 0 auto;
}

img {
  border: none;
}

a {
  color: #004A8D;
}

a:hover {
  text-decoration: none;
}

a.collapseHide,a.collapseShow {
  text-decoration: none;
  color: black;
  background-color: transparent;
}

a.collapseHide:hover,a.collapseShow:hover {
  background-color: black;
  color: white;
}

p {
  margin: 0;
}

.clearer {
  clear: both;
}

.header {
  padding: 1em 0 1em 0;
}

.header h1 {
  margin: 0;
  font-size: 180%;
}

.header p {
  padding-top: 0.7em;
}

.header .logo {
  float: right;
  height: 80px;
  overflow: hidden;
  text-align: right;
  width: 270px;
}
.header .logo img {
  max-width: 270px;
  max-height: 80px;
}

.print {
  margin-left: 2em;
  vertical-align: top;
}

.tableofcontents {
  margin-bottom: 1em;
}
.tableofcontents .left {
  float: left;
  width: 50%;
  background-color: #DDDDDD;
}
.tableofcontents .right {
  float: left;
  width: 50%;
}
.tableofcontents .right .container,
.tableofcontents .left .container {
  padding: 1em;
}

.tableofcontents .information {
  padding-bottom: 1em;
  font-weight: bold;
}
.tableofcontents .subtitle_create {
  padding-bottom: 0.5em;
}

h1 {
  font-size: 140%;
}

h2 {
  font-size: 130%;
}

.section_indent h2,
h3 {
  font-size: 120%;
}

.section_indent .section_indent  h2,
h4 {
  font-size: 110%;
}
h4 .backlink {
  display: none;
}

.backlink {
  display: inline-block;
    float: right;
    font-size: 80%;
  text-decoration: none;
}
.backlink:hover {
  background-color: black;
  color: white;
}

.caption {
  font-size: 120%;
  padding: 0.5em 0 0.5em 0;
  display: block;
}
.paragraph {
  padding: 0.5em 0 0.5em 0;
}

h4 {
  font-size: 110%;
}

.error {
  color: red;
}

.risk {
  border-top: 0.2em solid red;
  border-right: 1em solid red;
  border-bottom: 0.2em solid red;
  border-left: 1em solid red;
  padding-left: 1em;
  padding-bottom: 1em;
  margin-top: 1em;
  background-color: yellow;
}

.risk .section_text {
  padding-left: 0;
}
.risk .backlink {
  display: none;
}

.xred {
  color: red;
  font-weight: bold;
}

.lighter {
  color: #666666;
}

.hideCreatedByTo,
.createdbyto,
.collapseTrigger,
.bottomline .element {
  cursor: pointer;
}
.hideCreatedByTo:hover,
.createdbyto:hover,
.collapseTrigger:hover,
.bottomline .element:hover {
  background-color: yellow !important;
}

.hideCreatedByTo,.createdbyto {
  border: 0.2em solid black;
  background-color: #dddddd;
  margin-bottom: 1em;
  padding: 0.5em;
}

.hideCreatedByTo .created,.hideCreatedByTo .to,.createdbyto .to,.createdbyto .created
  {
  font-weight: bold;
  padding-right: 1em;
}

.collapseLinks {

}

.leftsmall {
  float: left;
  width: 15%;
}

.leftwide {
  float: left;
  width: 35%;
}

.hideCreatedByTo .leftsmall,.createdbyto .leftsmall {
  text-align: right;
  width: auto;
  padding-left: 2em;
}

.hideCreatedByTo .leftwide,.createdbyto .leftwide {
  width: auto;
}

.body_section {

}

.body_section h1 {
  background-color: #99CCFF;
  padding: 0.3em 0 0.3em 0.5em;
}

h1.body_section_header {
  margin-bottom: 0;
}

.header_anchors {
  background-color: #dddddd;
  margin-bottom: 1em;
  padding: 0.3em 0 0.3em 0.5em;
  line-height: 150%;
  border: 0.2em solid black;
  font-size: 80%;
}

.salutation {
  padding-top: 1em;
  padding-bottom: 1em;
  font-weight: normal;
}
.salutation .section_text {
  padding: 0;
}

.section_indent {
  padding-left: 2em;
}

.section_text {
  padding-left: 2em;
}

.section_table {
  border: 0.2em solid black;
  width: 100%;
}

.section_table td ul {
  margin-top: 0;
  margin-bottom: 0;
}

.section_table th {
  text-align: left;
  background-color: #C6C7C8;
  border-bottom: 0.2em solid white;
}

.section_table tr:nth-child(2n+1),
.section_table .odd td {
  background-color: #eceded;
}

.section_table th,.section_table td {
  padding: 0.3em;
}

/* Addresses */
.address {
  margin-bottom: 1em;
}

.recipient {
  margin-top: 1em;
}

div.collapseTrigger {
  background-color: #99CCFF;
  padding: 0.5em 0.5em 0.5em 0.5em;
}

div.collapseTrigger h1 {
  float: left;
  margin: 0;
  padding-right: 0.5em;
}

div.collapseTrigger .authenticatorShortInfo,
div.collapseTrigger .clientShortInfo,
div.collapseTrigger .stayShortInfo,
div.collapseTrigger .patientShortInfo,
.authenticatorShortInfo
  {
  float: left;
}

.patientTitle {
  float: left;
  width: 18%;
}
.patientTitle h1 {
  padding: 0;
}
.patientShortInfo {
  float: left;
  width: 82%;
}

div.collapseTrigger .authenticatorShortInfo .name,div.collapseTrigger .clientShortInfo .name,div.collapseTrigger .stayShortInfo .name,div.collapseTrigger .patientShortInfo .name
  {
  font-size: 140%;
}

div.collapseTrigger .collapseLinks {
  padding-right: 0.5em;
  width: auto;
}

.collapseLinks {
  float: left;
  display: block;
  font-weight: bold;
}

/* patient container */
.patientContainer {
  margin-bottom: 1em;
}

.patientContainer .date, .patientContainer .addresses,.patientContainer .guardian,
.patientContainer .data, .patientContainer .collapsableStay
  {
  padding: 1em 0 1em 0;
}

.patientContainer h2 {
  margin: 0;
  padding-right: 1em;
  padding-bottom: 1em;
}

.patientContainer .leftsmall {
  width: 30%;
}

.patientContainer .leftwide {
  width: 70%;
}

.patientContainer td {
  vertical-align: top;
}

.patientContainer .firstrow {
  padding-right: 1em;
  font-weight: bold;
}

tr.spacer td {
  padding-bottom: 1em;
}

.contactAddress .address {
  float: left;
    padding-right: 1em;
  width: 12em;
}

.addressRegion {
  font-weight: bold;
}

.guardianContact {
  padding-bottom: 1em;
}

.guardianContact .address {
  margin: 0;
}

.guardianContact .organisationName {
  padding-top: 0.5em;
  font-weight: bold;
}

.guardianName {
  font-weight: bold;
}

/* stay container */
.stayShortInfo {
  margin-top: 0.7em;
}

.stayShortInfo h1 {
  font-weight: normal;
}

.collapsableStay .leftsmall {
  float: left;
  width: 35%;
  padding-left: 4em;
}

.collapsableStay .leftwide {
  float: left;
  width: 42%;
  padding-left: 8%;
}

.collapsableStay .medic {

}

.collapsableStay .medicName {
  font-weight: bold;
}
.collapsableStay .organisationName {
  font-weight: bold;
}

.collapsableStay .az {
  margin-bottom: 1em;
  padding-left: 4em;
}

/* client container */
.clientContainer {
  margin-bottom: 1em;
}

.clientContainer .leftsmall {
  float: left;
  width: 35%;
  padding-left: 4em;
}

.clientContainer .leftwide {
  float: left;
  width: 42%;
  padding-left: 8%;
}

.clientContainer .collapsable {
  padding-top: 1em;
  padding-bottom: 1em;
}

.clientContainer .clientdata,
.clientContainer .collapseable .name {
  font-weight: bold;
}

/* authenticatorContainer */
.authenticatorContainer {
  padding-bottom: 1em;
}

.authenticatorContainer .collapsed .name,
.authenticatorContainer .organisationName {
  font-weight: bold;
}

.authenticatorContainer .leftsmall {
  float: left;
  width: 35%;
  padding-left: 4em;
}

.authenticatorContainer .leftwide {
  float: left;
  width: 42%;
  padding-left: 8%;
}

.authenticatorContainer .collapsable {
  padding-top: 1em;
}


.bottomline_data .leftsmall {
  width: 30%;
}

.bottomline_data .leftwide {
  width: 60%;
}

.bottomline .collapseLinks {
  float: left;
  width: 3em;
}

.bottomline h2 {
  font-size: 100%;
  margin: 0;
}

.bottomline .organisationName {
  font-weight: bold;
}

.bottomline .relationship {
  font-weight: normal;
}

.bottomline_data .element {
  clear: both;
  padding: 1em;
}

.bottomline_data .address {
  margin: 0;
}

.bottomline .element:nth-child(2n+1) {
  background-color: #eeeeee;
}
.bottomline .leftsmall .date {
  color: #666666;
}

/* tooltip */
.tooltipTrigger {
  position: relative;
  cursor: help;
}

.tooltip {
  display: none;
}

.tooltipTrigger:hover .tooltip,.showTooltip .tooltip {
  display: block;
  position: absolute;
  top: 2em;
  left: 2em;
  background-color: white;
  border: 0.1em solid black;
  z-index: 100;
  font-size: 70%;
  padding: 0.5em;
  color: black;
}

.tooltipentry {
  display: block;
}
/* end tooltip */

.footer_logo {
  float: right;
  height: 40px;
  width: 40px;
  padding-bottom: 1em;
}

/*
*	hide/show collapse triggers and collapseable
* by default (no javascript) triggers are hidden and content is shown
*/
.hide_all,.show_all, .print, .show_tableofcontents, .hide_tableofcontents {
  display: none;
}
.hide_all,.show_all, .show_tableofcontents, .hide_tableofcontents {
  padding-right: 1em;
}

.collapseLinks {
  display: none;
}

.hideCreatedByTo .leftwide p,.hideCreatedByTo .leftwide div {
  display: none;
}

html .hideCreatedByTo .leftwide p.organisationName {
  display: block;
}

.hideBottomlineCollapseable .leftwide div,.hideBottomlineCollapseable .leftwide p.telecom,.hideBottomlineCollapseable .leftsmall p
  {
  display: none;
}

.responsibleContact {
  border: 0.2em solid black;
  width: 40%;
  background-color: #dddddd;
  padding: 1em 1em 1em 4em;
  margin-bottom: 1em;
}

.responsibleContact .organisationName {
  font-weight: bold;
}

.submitLink {
    background-color: transparent;
    border: medium none;
    color: #004A8D;
    cursor: pointer;
    text-decoration: underline;
  font-size: 100%;
}
.submitLink:hover {
    text-decoration: none;
}

/* warncontainer */
.warncontainer {
  background-color: #DDDDDD;
    border: 0.2em solid black;
    margin-bottom: 1em;
    padding: 0.5em;
}

.warncontainer a, .warncontainer .info {
  padding-left: 0.5em;
}
.warncontainer img {
  vertical-align: top;
}

.country,
.uppercase {
  text-transform: uppercase;
}

.nonbreaking {
  white-space: nowrap;
}
        </style>
        <style type="text/css" media="print">
html body {
  font-size: 12pt;
}

html .bodyContentContainer {
  width: 100%;
  margin: 0;
}

html .hide_all,.show_all, .print, .collapseShow, .collapseHide,
.show_tableofcontents, .hide_tableofcontents, .backlink {
  display: none !important;
}

html .section_text, html .section_indent {
  padding: 0;
}

html .hideCreatedByTo .leftsmall, html .hideCreatedByTo .leftwide,
html .createdbyto .leftsmall, html .createdbyto .leftwide {
  float: none;
  text-align: left;
}
html .hideCreatedByTo .leftwide,
html .createdbyto .leftwide {
  padding-left: 5em;
}

html .patientContainer .leftwide, html .patientContainer .leftsmall,
html .stayContainer .leftwide, html .stayContainer .leftsmall {
  float: none;
  padding-left: 10%;
  width: 100%;
}

a {
  text-decoration: none;
}

.footer_logo {
  height: 1cm;
  width: 1cm;
}

        </style>
        <script type="text/javascript">
<xsl:variable name="javascript">
<![CDATA[

var HIDE_SPECIAL_CONTAINER_CLASS = "hideCreatedByTo";
var SPECIAL_CONTAINER_CLASS = "createdbyto";
var COLLAPSEABLE_CONTAINER_CLASS = "collapsable";
var COLLAPSE_TRIGGER_CONTAINER_CLASS = "collapseTrigger";
var TABLE_OF_CONTENTS_CLASS = "tableofcontents";
var COLLAPSE_LINKS_CONTAINER_CLASS = "collapseLinks";
var HIDE_TRIGGER_CLASS = "collapseHide";
var SHOW_TRIGGER_CLASS = "collapseShow";
var HIDE_ALL_TRIGGER_CLASS = "hide_all";
var SHOW_ALL_TRIGGER_CLASS = "show_all";
var HIDE_TABLE_OF_CONTENTS_CLASS = "hide_tableofcontents";
var SHOW_TABLE_OF_CONTENTS_CLASS = "show_tableofcontents";
var PRINT_BUTTON_CLASS = "print";
var SHOW_BOTTOMLINE_CLASS = "bottomlineCollapseable";
var HIDE_BOTTOMLINE_CLASS = "hideBottomlineCollapseable";



function getElementsByClassFromNode(searchClass, node) {
    "use strict";
    var classElements = [],
        els,
        elsLen,
        pattern,
        i = 0,
        j = 0,
        tag = '*';

    els = node.getElementsByTagName(tag);
    elsLen = els.length;
    pattern = new RegExp("(^|\\s)" + searchClass + "(\\s|$)");
    for (i = 0; i < elsLen; i++) {
        if (pattern.test(els[i].className)) {
            classElements[j] = els[i];
            j++;
        }
    }
    return classElements;
}

function getElementsByClass(searchClass) {
    "use strict";
    return getElementsByClassFromNode(searchClass, window.document);
}

function updateStyleDisplay(node, value) {
    "use strict";
    var i = 0;
    for (i = 0; i < node.length; i++) {
        node[i].style.display = value;
    }
}

function setCollapseContainer(node, hide) {
    "use strict";
    if (node.tagName === "BODY") {
        return false;//error
    }
    if (node.className === SPECIAL_CONTAINER_CLASS || node.className === HIDE_SPECIAL_CONTAINER_CLASS) {
        if (hide === true) {
            node.className = HIDE_SPECIAL_CONTAINER_CLASS;
        } else {
            node.className = SPECIAL_CONTAINER_CLASS;
        }
        return true;
    }
    if (node.className === COLLAPSE_TRIGGER_CONTAINER_CLASS) {
        if (hide === true) {
            if (node.nextSibling.nodeType === 3) {
                node.nextSibling.nextSibling.style.display = "none";
            } else {
                node.nextSibling.style.display = "none"; //IE
            }
        } else {
            if (node.nextSibling.nodeType === 3) {
                node.nextSibling.nextSibling.style.display = "";
            } else {
                node.nextSibling.style.display = ""; //IE
            }
        }
        return true;
    }
    if (node.className === SHOW_BOTTOMLINE_CLASS || node.className === HIDE_BOTTOMLINE_CLASS) {
        if (hide === true) {
            node.className = HIDE_BOTTOMLINE_CLASS;
        } else {
            node.className = SHOW_BOTTOMLINE_CLASS;
        }
        return true;
    }
    setCollapseContainer(node.parentNode, hide);
}

/* all dynamic hideables in arrays */
var hideTriggerElements = null;
var showTriggerElements = null;
var collapseLinkContainerElements = null;
var showAllElements = null;
var hideAllElements = null;
var printElement = null;
var collapseAllElements = null;
var createdByToElements = null;
var bottomlineElements = null;
var tableofcontentsElement = null;
var hideTableofcontens = null;
var showTableofcontens = null;

function showCollapsed(node) {
    "use strict";
    setCollapseContainer(node, false); //false = show
    node.previousSibling.style.display = "inline";
    node.style.display = "none";
    return false;
}

function hideCollapseable(node) {
    "use strict";
    setCollapseContainer(node, true); //true = hide
    node.nextSibling.style.display = "inline";
    node.style.display = "none";
    return false;
}


function showAll() {
    "use strict";
    var i = 0;
    updateStyleDisplay(collapseAllElements, "");
    updateStyleDisplay(hideAllElements, "inline");
    updateStyleDisplay(showAllElements, "");
    updateStyleDisplay(hideTriggerElements, "inline");
    updateStyleDisplay(showTriggerElements, "none");
    for (i = 0; i < createdByToElements.length; i++) {
        createdByToElements[i].className = SPECIAL_CONTAINER_CLASS;
    }
    for (i = 0; i < bottomlineElements.length; i++) {
        bottomlineElements[i].className = SHOW_BOTTOMLINE_CLASS;
    }
    return false;
}

function hideAll() {
    "use strict";
    var i = 0;
    updateStyleDisplay(collapseAllElements, "none");
    updateStyleDisplay(hideAllElements, "");
    updateStyleDisplay(showAllElements, "inline");
    updateStyleDisplay(hideTriggerElements, "none");
    updateStyleDisplay(showTriggerElements, "inline");
    for (i = 0; i < createdByToElements.length; i++) {
        createdByToElements[i].className = HIDE_SPECIAL_CONTAINER_CLASS;
    }
    for (i = 0; i < bottomlineElements.length; i++) {
        bottomlineElements[i].className = HIDE_BOTTOMLINE_CLASS;
    }
    return false;
}

function showTableOfContents() {
    "use strict";
    updateStyleDisplay(hideTableofcontens, "inline");
    updateStyleDisplay(showTableofcontens, "");
    updateStyleDisplay(tableofcontentsElement, "");
    return false;
}

function hideTableOfContents() {
    "use strict";
    updateStyleDisplay(hideTableofcontens, "");
    updateStyleDisplay(showTableofcontens, "inline");
    updateStyleDisplay(tableofcontentsElement, "none");
    return false;
}

function toggleCollapseable(node) {
    "use strict";
    var collapseLinksContainer,
        collapseLinks,
        i;
    collapseLinksContainer = getElementsByClassFromNode("collapseLinks", node);
    if(collapseLinksContainer && collapseLinksContainer.length > 0) {
        collapseLinks = collapseLinksContainer[0].getElementsByTagName("A");
        for (i = 0; i < collapseLinks.length; i++) {
            if(collapseLinks[i].style.display === "inline" || collapseLinks[i].style.display === "") {
                if(collapseLinks[i].className === SHOW_TRIGGER_CLASS) {
                    showCollapsed(collapseLinks[i]);
                } else {
                    hideCollapseable(collapseLinks[i]);
                }
                break;
            }
        }
    }
}

function jump(elementID) {
    "use strict";
    var collapseLinksContainer,
        collapseLinks,
        i,
        node;
    node = window.document.getElementById(elementID);
    collapseLinksContainer = getElementsByClassFromNode("collapseLinks", node);
    if(collapseLinksContainer && collapseLinksContainer.length > 0) {
        collapseLinks = collapseLinksContainer[0].getElementsByTagName("A");
        for (i = 0; i < collapseLinks.length; i++) {
            if(collapseLinks[i].style.display === "inline" || collapseLinks[i].style.display === "") {
                if(collapseLinks[i].className === SHOW_TRIGGER_CLASS) {
                    showCollapsed(collapseLinks[i]);
                }
                break;
            }
        }
    }
}

/* init document */
window.onload = function () {
    "use strict";
    var i = 0;
    //(javascript works) setup triggers, hide content

    // hide [-]
    hideTriggerElements = getElementsByClass(HIDE_TRIGGER_CLASS);
    updateStyleDisplay(hideTriggerElements, "none");

    showTriggerElements = getElementsByClass(SHOW_TRIGGER_CLASS);
    // show collapse triggers
    collapseLinkContainerElements = getElementsByClass(COLLAPSE_LINKS_CONTAINER_CLASS);
    updateStyleDisplay(collapseLinkContainerElements, "block");

    showAllElements = getElementsByClass(SHOW_ALL_TRIGGER_CLASS);
    updateStyleDisplay(showAllElements, "inline");

    // show print button
    printElement = getElementsByClass(PRINT_BUTTON_CLASS);
    updateStyleDisplay(printElement, "inline");

    // show table of contents button
    showTableofcontens = getElementsByClass(SHOW_TABLE_OF_CONTENTS_CLASS);
    updateStyleDisplay(showTableofcontens, "inline");

    hideAllElements = getElementsByClass(HIDE_ALL_TRIGGER_CLASS);
    hideTableofcontens = getElementsByClass(HIDE_TABLE_OF_CONTENTS_CLASS);

    /* hide all collapseable elements */
    collapseAllElements = getElementsByClass(COLLAPSEABLE_CONTAINER_CLASS);
    updateStyleDisplay(collapseAllElements, "none");

    createdByToElements = getElementsByClass(SPECIAL_CONTAINER_CLASS);
    for (i = 0; i < createdByToElements.length; i++) {
        createdByToElements[i].className = HIDE_SPECIAL_CONTAINER_CLASS;
    }

    bottomlineElements = getElementsByClass(SHOW_BOTTOMLINE_CLASS);
    for (i = 0; i < bottomlineElements.length; i++) {
        bottomlineElements[i].className = HIDE_BOTTOMLINE_CLASS;
    }

    tableofcontentsElement = getElementsByClass(TABLE_OF_CONTENTS_CLASS);
    updateStyleDisplay(tableofcontentsElement, "none");
};
]]>
</xsl:variable>
    <!-- Beginning of CDATA section -->
      <xsl:text disable-output-escaping="yes"><![CDATA[//<]]></xsl:text><xsl:text disable-output-escaping="yes">![CDATA[</xsl:text>

      <!-- original javascript -->
      <xsl:value-of  select="$javascript" disable-output-escaping="yes"/>

      <!-- End of CDATA section -->
      <xsl:text>//]]</xsl:text><xsl:text disable-output-escaping="yes"><![CDATA[>]]></xsl:text>

        </script>
      </head>

      <!--
        HTML Body
      -->
      <body>
      <div class="outerContainer" id="elgadocument">
        <div class="bodyContentContainer">
        <!-- document header -->
        <div class="header">
        <xsl:if test="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section[n1:code/@code = 'BRIEFT']/n1:entry/n1:observationMedia">
        <div class="logo">
          <xsl:call-template name="renderLogo">
          <xsl:with-param name="logo" select="/n1:ClinicalDocument/n1:component/n1:structuredBody/n1:component/n1:section/n1:entry/n1:observationMedia" />
          </xsl:call-template>
        </div>
        </xsl:if>
          <h1 class="tooltipTrigger">
          <xsl:value-of select="$title"/>
          <span class="tooltip">
            <xsl:call-template name="getTitel">
              <xsl:with-param name="titel" select="/n1:ClinicalDocument/n1:code" />
            </xsl:call-template>
          </span>
          </h1>
          <p class="subtitle_create">
            <xsl:text>Erzeugt am </xsl:text>
            <xsl:call-template name="formatDate">
              <xsl:with-param name="date" select="/n1:ClinicalDocument/n1:effectiveTime/@value" />
            </xsl:call-template>
            <xsl:text> Uhr | Version: </xsl:text><xsl:value-of select="/n1:ClinicalDocument/n1:versionNumber/@value" />
          </p>
          <div class="clearer" ></div>
          <hr />
          <a class="show_tableofcontents" href="#" onclick="showTableOfContents(); return false;">[+] Inhaltsverzeichnis ausklappen</a>
          <a class="hide_tableofcontents" href="#" onclick="hideTableOfContents(); return false;">[-] Inhaltsverzeichnis einklappen</a>
          <a class="show_all" href="#" onclick="showAll(); return false;">[+] Alle Inhalte ausklappen</a>
          <a class="hide_all" href="#" onclick="hideAll(); return false;">[-] Alle Inhalte einklappen</a>
          <a class="print" href="#" onclick="javascript:window.print()"><img alt="drucken" src="data:image/gif;base64,R0lGODlhFAAUAKIEAENFRcHCwoKDgwQHB////wAAAAAAAAAAACH5BAEAAAQALAAAAAAUABQAAANb
SDrcrjCSAYK9TcYh9CDAp02dJIYj5zmBFJbjJEIMnM5ByAB87+8dh3DoEBCPRUosxlEuPUaADMlo
NaWUixZjNQ4CqiUHLNCFmRmazdMyrU3tDbWqEdjv+Hs8AQA7" /></a>
        </div><!-- END document header -->

        <!--
          table of contents
          if there is no javascript enabled it is shown as default
          else it is hidden and can be shown
          on click jump to the element (if needed opens the elemnt before)
        -->
        <div class="tableofcontents">
          <div class="left">
            <div class="container">
              <p><a href="#IDPatientContainer" onclick="jump('IDPatientContainer');"><xsl:value-of select="$genderedpatient" /></a>
              <xsl:if test="/n1:ClinicalDocument/n1:componentOf">
                <xsl:text> / </xsl:text><a href="#IDCollapseableStay" onclick="jump('IDPatientContainer');">Aufenthalt</a>
              </xsl:if>
              </p>
              <xsl:if test="/n1:ClinicalDocument/n1:inFulfillmentOf">
                <p><a href="#IDfulfillmentof" onclick="jump('IDfulfillmentof');">Auftraggeber(in)</a></p>
              </xsl:if>
              <p><a href="#IDCreatedbyto" onclick="jump('IDCreatedbyto');">Erstellt von / An</a></p>
              <xsl:text>-----</xsl:text>
              <xsl:choose>
                <xsl:when test="n1:component/n1:structuredBody">
                  <xsl:for-each select="//n1:section" >
                    <xsl:variable name="indent" select="count(ancestor::*/n1:section)-1" />
                    <xsl:choose>
                    <!-- do not show following titel -->
                    <xsl:when test="n1:code/@code = 'BRIEFT' "/>
                    <xsl:when test="n1:code/@code = 'ABBEM' "/>
                    <xsl:otherwise>
                    <p style="padding-left: {$indent}em;"><a href="#id{n1:code/@code}"><xsl:value-of select="n1:title" /></a></p>
                    </xsl:otherwise>
                    </xsl:choose>
                  </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                  <p><a href="#IDBody"><xsl:text>Unstrukturierter Inhalt</xsl:text></a></p>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:text>-----</xsl:text>
              <p><a href="#IDResponsibleContact">Kontaktperson für Fragen</a></p>
              <p><a href="#IDAuthenticatorContainer" onclick="jump('IDAuthenticatorContainer');">Unterzeichnet von</a></p>
              <p><a href="#IDBottomline" onclick="jump('IDBottomline');">Zusätzliche Informationen über das Dokument</a></p>
            </div>
          </div>
          <div class="right">
            <div class="container">
              <p class="information">Dokumentinformation</p>
                  <p class="subtitle_create">
                <xsl:text>Dokument erzeugt am </xsl:text>
                <xsl:call-template name="formatDate">
                  <xsl:with-param name="date" select="/n1:ClinicalDocument/n1:effectiveTime/@value" />
                </xsl:call-template>
                <xsl:text> Uhr</xsl:text>
                </p>
                <xsl:choose>
                <xsl:when test="*/n1:serviceEvent/n1:effectiveTime/n1:low/@value != '' and */n1:serviceEvent/n1:effectiveTime/n1:high/@value != ''">
                  <p class="subtitle_create">
                  <xsl:text>Leistungszeitraum von </xsl:text>
                  <xsl:call-template name="formatDate">
                    <xsl:with-param name="date" select="*/n1:serviceEvent/n1:effectiveTime/n1:low/@value" />
                  </xsl:call-template><xsl:text> Uhr bis </xsl:text>
                  <xsl:call-template name="formatDate">
                    <xsl:with-param name="date" select="*/n1:serviceEvent/n1:effectiveTime/n1:high/@value" />
                  </xsl:call-template><xsl:text> Uhr</xsl:text>
                  </p>
                </xsl:when>
                <xsl:when test="*/n1:serviceEvent/n1:effectiveTime/n1:low/@value != ''">
                  <p class="subtitle_create">
                  <xsl:text>Begin der Leistung: </xsl:text>
                  <xsl:call-template name="formatDate">
                    <xsl:with-param name="date" select="*/n1:serviceEvent/n1:effectiveTime/n1:low/@value" />
                  </xsl:call-template><xsl:text> Uhr</xsl:text>
                  </p>
                </xsl:when>
                <xsl:when test="*/n1:serviceEvent/n1:effectiveTime/n1:high/@value != ''">
                  <p class="subtitle_create">
                  <xsl:text>Ende der Leistung: </xsl:text>
                  <xsl:call-template name="formatDate">
                    <xsl:with-param name="date" select="*/n1:serviceEvent/n1:effectiveTime/n1:high/@value" />
                  </xsl:call-template><xsl:text> Uhr</xsl:text>
                  </p>
                </xsl:when>
                </xsl:choose>
                <p class="subtitle_create"><xsl:text>Dokument-ID: </xsl:text>{<xsl:value-of select="/n1:ClinicalDocument/n1:id/@root" />}&#160;<xsl:value-of select="/n1:ClinicalDocument/n1:id/@extension" /></p>
                <p class="subtitle_create"><xsl:text>Dokumentversion: </xsl:text><xsl:value-of select="/n1:ClinicalDocument/n1:versionNumber/@value" /></p>
            </div>
          </div>
          <div class="clearer"></div>
        </div><!-- END table of contents -->


        <!--
          Patient element collapseable includes information about the stay
        -->
        <div class="patientContainer">
          <xsl:variable name="sex" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:administrativeGenderCode/@code"/>
          <xsl:variable name="sexName">
            <xsl:choose>
              <xsl:when test="$sex='M'">männlich</xsl:when>
              <xsl:when test="$sex='F'">weiblich</xsl:when>
              <xsl:otherwise>unbekannt</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:variable name="birthdate">
          <xsl:choose>
            <xsl:when test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:birthTime/@value">
              <xsl:call-template name="formatDate">
                <xsl:with-param name="date" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:birthTime/@value"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise><xsl:text>nicht angegeben</xsl:text></xsl:otherwise>
          </xsl:choose>
          </xsl:variable>
          <xsl:variable name="svnnumber">
          <xsl:choose>
            <xsl:when test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:id[@root='1.2.40.0.10.1.4.3.1']/@extension">
              <xsl:value-of select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:id[@root='1.2.40.0.10.1.4.3.1']/@extension"/>
            </xsl:when>
            <xsl:otherwise>nicht angegeben</xsl:otherwise>
          </xsl:choose>
          </xsl:variable>

          <div class="collapseTrigger" onclick="toggleCollapseable(this);" id="IDPatientContainer">
            <div class="patientTitle">
              <xsl:call-template name="collapseTrigger"/>
              <h1><xsl:value-of select="$genderedpatient" />:</h1>
            </div>
            <div class="patientShortInfo">
              <p class="name">
                <xsl:call-template name="getName">
                  <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name"/>
                </xsl:call-template>
              </p>
              <p>
                <xsl:text>Geschlecht: </xsl:text><xsl:value-of select="$sexName" />
                <xsl:text> | </xsl:text>
                <xsl:text>geboren am: </xsl:text>
                <xsl:value-of select="$birthdate" />
                <xsl:text> | </xsl:text>
                <xsl:text>SVN: </xsl:text><xsl:value-of select="$svnnumber"/>
                <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:guardian">
                  <xsl:text> | </xsl:text>
                  <xsl:text>Sachwalter vorhanden</xsl:text>
                </xsl:if>
              </p>
              <xsl:if test="/n1:ClinicalDocument/n1:componentOf">
                <div class="stayShortInfo">
                  <h1 class="stayheader"><xsl:text>Aufenthalt:</xsl:text></h1>
                  <p class="name">
                    <xsl:call-template name="getName">
                    <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:location/n1:healthCareFacility/n1:serviceProviderOrganization/n1:name"/>
                    </xsl:call-template>
                  </p>
                  <p>
                    <xsl:call-template name="getAmbulatory">
                    <xsl:with-param name="code" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:code" />
                    <xsl:with-param name="effectiveTime" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:effectiveTime" />
                    </xsl:call-template>
                    <xsl:if test="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:id/@extension != ''">
                      <xsl:text> | </xsl:text>
                      <span class="nonbreaking"><xsl:text>Aufenthaltszahl: </xsl:text>
                      <xsl:apply-templates select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:id/@extension"/></span>
                    </xsl:if>
                  </p>
                </div>
              </xsl:if><!-- END stayShortInfo -->
            </div>
            <div class="clearer"></div>
          </div>
          <div class="collapsable">
            <div class="data">
              <div class="leftsmall">
                <h2><xsl:text>Allgemeine Daten</xsl:text></h2>
              </div>
              <div class="leftwide">
                <table cellpadding="0" cellspacing="0">
                  <tr>
                    <td class="firstrow"><xsl:text>Geschlecht:</xsl:text></td>
                    <td><xsl:value-of select="$sexName" /></td>
                  </tr>

                  <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name/n1:family[@qualifier='SP']">
                  <tr>
                    <td class="firstrow"><xsl:text>Name vor Heirat:</xsl:text></td>
                    <td>
                      <xsl:call-template name="renderListItems">
                        <xsl:with-param name="list" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name/n1:family[@qualifier='SP']" />
                      </xsl:call-template>
                    </td>
                  </tr>
                  </xsl:if>
                  <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name/n1:family[@qualifier='AD']">
                  <tr>
                    <td class="firstrow"><xsl:text>Name vor Adoption:</xsl:text></td>
                    <td>
                      <xsl:call-template name="renderListItems">
                        <xsl:with-param name="list" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name/n1:family[@qualifier='AD']" />
                      </xsl:call-template>
                    </td>
                  </tr>
                  </xsl:if>
                  <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name/n1:family[@qualifier='BR']">
                  <tr>
                    <td class="firstrow"><xsl:text>Geburtsname:</xsl:text></td>
                    <td>
                      <xsl:call-template name="renderListItems">
                        <xsl:with-param name="list" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name/n1:family[@qualifier='BR']" />
                      </xsl:call-template>
                    </td>
                  </tr>
                  </xsl:if>

                  <tr>
                    <td class="firstrow"><xsl:text>Geburtsdatum:</xsl:text></td>
                    <td><xsl:value-of select="$birthdate" /></td>
                  </tr>
                  <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:birthplace/n1:place/n1:addr">
                  <tr>
                    <td class="firstrow"><xsl:text>Geburtsort: </xsl:text></td>
                    <td>
                      <xsl:call-template name="getAddress">
                        <xsl:with-param name="addr" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:birthplace/n1:place/n1:addr"/>
                      </xsl:call-template>
                    </td>
                  </tr>
                  </xsl:if>
                  <tr>
                    <td class="firstrow"><xsl:text>SV-Nr: </xsl:text></td>
                    <td><xsl:value-of select="$svnnumber"/></td>
                  </tr>
                  <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:maritalStatusCode">
                  <tr>
                    <td class="firstrow"><xsl:text>Familienstand: </xsl:text></td>
                    <td>
                      <xsl:call-template name="getMaritalStatus">
                        <xsl:with-param name="maritalStatus" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:maritalStatusCode" />
                      </xsl:call-template>
                    </td>
                  </tr>
                  </xsl:if>
                  <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:religiousAffiliationCode">
                  <tr class="spacer">
                  <td class="firstrow"><xsl:text>Religionsgemeinschaft: </xsl:text></td>
                  <td>
                    <xsl:call-template name="getReligiousAffiliation">
                      <xsl:with-param name="religiousAffiliation" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:religiousAffiliationCode" />
                    </xsl:call-template>
                  </td>
                  </tr>
                  </xsl:if>
                  <xsl:call-template name="getContactTelecomTable">
                    <xsl:with-param name="contact" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole"/>
                  </xsl:call-template>
                </table>
              </div>
              <div class="clearer"></div>
            </div>
            <hr />
            <div class="addresses">
              <div class="leftsmall">
                <h2><xsl:text>Bekannte Adresse(n)</xsl:text></h2>
              </div>
              <div class="leftwide">
                <xsl:call-template name="getContactAddress">
                  <xsl:with-param name="contact" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole"/>
                </xsl:call-template>
              </div>
              <div class="clearer"></div>
            </div>
            <xsl:if test="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:guardian">
            <hr />
            <div class="guardian">
              <div class="leftsmall">
                <h2><xsl:text>Sachwalter / Vormund</xsl:text></h2>
              </div>
              <div class="leftwide">
                <xsl:apply-templates select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:guardian"/>
              </div>
              <div class="clearer"></div>
            </div>
            </xsl:if>
            <xsl:if test="/n1:ClinicalDocument/n1:componentOf">
            <hr />
            <div class="collapsableStay" id="IDCollapseableStay">
            <h2><xsl:text>Aufenthalt</xsl:text></h2>
            <xsl:if test="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:id/@extension != ''">
              <div class="az">
                <p>
                  <xsl:call-template name="getAmbulatory">
                  <xsl:with-param name="code" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:code" />
                  <xsl:with-param name="effectiveTime" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:effectiveTime" />
                  </xsl:call-template>
                </p>
                <p>
                  <xsl:text>Aufenthaltszahl: </xsl:text>
                  <xsl:apply-templates select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:id/@extension"/>
                </p>
              </div>
              </xsl:if>
              <div class="leftsmall">
                <xsl:call-template name="getOrganization">
                  <xsl:with-param name="organization" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:location/n1:healthCareFacility/n1:serviceProviderOrganization "/>
                </xsl:call-template>
              </div>
              <div class="leftwide">
                <p class="medic"><xsl:text>Verantwortliche(r) Mediziner(in)</xsl:text></p>
                <p class="medicName">
                  <xsl:call-template name="getName">
                    <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:responsibleParty/n1:assignedEntity/n1:assignedPerson/n1:name"/>
                  </xsl:call-template>
                </p>
                <xsl:call-template name="getContactInfo">
                  <xsl:with-param name="contact" select="/n1:ClinicalDocument/n1:componentOf/n1:encompassingEncounter/n1:location/n1:healthCareFacility/n1:serviceProviderOrganization"/>
                </xsl:call-template>
              </div>
              <div class="clearer"></div>
            </div>
            </xsl:if><!-- END collapseableStay -->
          </div>
        </div><!-- END patient element -->

        <!--
          fulfillment of collapseable (labor document)
        -->
        <xsl:if test="/n1:ClinicalDocument/n1:inFulfillmentOf">
        <div class="clientContainer">
          <div class="collapseTrigger" onclick="toggleCollapseable(this);" id="IDfulfillmentof">
            <xsl:call-template name="collapseTrigger"/>
            <h1><xsl:text>Auftraggeber(in):</xsl:text></h1>
            <div class="clientShortInfo">
              <p class="name">
                <xsl:call-template name="getName">
                  <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:participant[@typeCode='REF']/n1:associatedEntity/n1:scopingOrganization/n1:name"/>
                </xsl:call-template>
              </p>
            </div>
            <div class="clearer"></div>
          </div>
          <div class="collapsable">
            <div class="leftsmall">
              <p class="name">
                <xsl:call-template name="getName">
                  <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:participant[@typeCode='REF']/n1:associatedEntity/n1:scopingOrganization/n1:name"/>
                </xsl:call-template>
              </p>
              <xsl:call-template name="getContactInfo">
                <xsl:with-param name="contact" select="/n1:ClinicalDocument/n1:participant[@typeCode='REF']/n1:associatedEntity"/>
              </xsl:call-template>
            </div>
            <div class="leftwide">
              <p class="clientdata"><xsl:text>Auftragsdaten: </xsl:text></p>
              <p>Auftragsnummer: <xsl:apply-templates select="/n1:ClinicalDocument/n1:inFulfillmentOf/n1:order/n1:id/@extension"/></p>
              <p class="date">Auftragsdatum:
              <xsl:call-template name="formatDate">
                <xsl:with-param name="date" select="/n1:ClinicalDocument/n1:participant[@typeCode='REF']/n1:time/@value"/>
              </xsl:call-template>
              </p>
            </div>
            <div class="clearer"></div>
          </div>
        </div>
        </xsl:if>

        <!--
          FromTo element collapseable
        -->
        <div class="createdbyto" onclick="toggleCollapseable(this);" id="IDCreatedbyto">
            <xsl:call-template name="collapseTrigger"/>
            <div class="leftsmall">
              <xsl:choose>
                <xsl:when test="/n1:ClinicalDocument/n1:author/n1:assignedAuthor">
                  <span class="created">Erstellt von: </span>
                </xsl:when>
                <xsl:otherwise>
                  <span class="created error">Erstellt von: (nicht vorhanden)</span>
                </xsl:otherwise>
              </xsl:choose>
            </div>
            <div class="leftwide">
              <xsl:for-each select="/n1:ClinicalDocument/n1:author/n1:assignedAuthor">
                <xsl:if test="/n1:ClinicalDocument/n1:author/n1:assignedAuthor/n1:representedOrganization">
                  <xsl:call-template name="getOrganization">
                    <xsl:with-param name="organization" select="/n1:ClinicalDocument/n1:author/n1:assignedAuthor/n1:representedOrganization"/>
                  </xsl:call-template>
                </xsl:if>
              </xsl:for-each>
            </div>
            <div class="leftsmall">
              <xsl:choose>
                <xsl:when test="/n1:ClinicalDocument/n1:informationRecipient[not(@typeCode) or @typeCode != 'TRC'][1]/n1:intendedRecipient/n1:receivedOrganization">
                  <span class="to">An: </span>
                </xsl:when>
                <xsl:when test="/n1:ClinicalDocument/n1:informationRecipient[not(@typeCode) or @typeCode != 'TRC'][1]/n1:intendedRecipient/n1:informationRecipient">
                  <span class="to">Ergeht an: </span>
                </xsl:when>
                <xsl:otherwise>-</xsl:otherwise>
              </xsl:choose>
            </div>
            <div class="leftwide">
            <xsl:choose>
              <xsl:when test="/n1:ClinicalDocument/n1:informationRecipient[not(@typeCode) or @typeCode != 'TRC'][1]/n1:intendedRecipient/n1:receivedOrganization">
              <xsl:call-template name="getOrganization">
                <xsl:with-param name="organization" select="/n1:ClinicalDocument/n1:informationRecipient[not(@typeCode) or @typeCode != 'TRC'][1]/n1:intendedRecipient/n1:receivedOrganization"/>
              </xsl:call-template>
              </xsl:when>
              <xsl:when test="/n1:ClinicalDocument/n1:informationRecipient[not(@typeCode) or @typeCode != 'TRC'][1]/n1:intendedRecipient/n1:informationRecipient">
              <xsl:call-template name="getIntendedRecipient">
                <xsl:with-param name="recipient" select="/n1:ClinicalDocument/n1:informationRecipient[not(@typeCode) or @typeCode != 'TRC'][1]/n1:intendedRecipient"/>
              </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>-</xsl:otherwise>
            </xsl:choose>
            </div>
            <div class="clearer"></div>
        </div><!-- END FromTo element -->

        <!--
          Warn container
          displays urgent information like risk or alternative denial if the document is well structured with [!]
          if the document is not well structured, there may be such information [?]
          also important law information (living will) is displayed [§]
        -->
        <div class="warncontainer" id="IDWarnContainer">
          <div class="warnconatiner_content">
            <!-- check if structured document -->
            <xsl:variable name="structuredDoc">
              <xsl:for-each select="/n1:ClinicalDocument/n1:templateId" >
                <xsl:if test="@root ='1.2.40.0.34.11.2.0.2' or @root ='1.2.40.0.34.11.2.0.3' or @root ='1.2.40.0.34.11.3.0.2' or @root ='1.2.40.0.34.11.3.0.3' ">found</xsl:if>
              </xsl:for-each>
            </xsl:variable>
            <!-- if structured display warnings otherwise info that the document is not structured-->
            <xsl:choose>
              <xsl:when test="$structuredDoc = 'found' ">
                <xsl:if test="//*/n1:code/@code = '51898-5' and //*/n1:code/@codeSystem ='2.16.840.1.113883.6.1' ">
                  <p class="warning_icon">
                    <xsl:call-template name="getWarningIcon" />
                    <a href="#id51898-5"><xsl:text>Risiko</xsl:text></a>
                  </p>
                </xsl:if>
                <xsl:if test="//*/n1:code/@code = '48765-2' and //*/n1:code/@codeSystem ='2.16.840.1.113883.6.1' ">
                  <p class="warning_icon">
                    <xsl:call-template name="getWarningIcon" />
                    <a href="#id48765-2"><xsl:text>Allergien oder Medikamentenunverträglichkeiten</xsl:text></a>
                  </p>
                </xsl:if>
                <xsl:if test="not(//*/n1:code/@code = '51898-5' and //*/n1:code/@codeSystem ='2.16.840.1.113883.6.1') and not(//*/n1:code/@code = '48765-2' and //*/n1:code/@codeSystem ='2.16.840.1.113883.6.1')" >
                  <p class="warning_icon">
                    <xsl:call-template name="getWarningIcon" />
                    <xsl:text>Keine Warnungen</xsl:text>
                  </p>
                </xsl:if>
              </xsl:when>
              <xsl:otherwise>
                <p class="question_icon">
                  <xsl:call-template name="getQuestionIcon" />
                  <span class="info">
                  <xsl:text>Keine automatischen Warnungen enthalten, bitte manuell überprüfen!</xsl:text>
                  </span>
                </p>
              </xsl:otherwise>
            </xsl:choose>
            <!-- display law info -->
            <xsl:if test="//*/n1:code/@code = '42348-3' and //*/n1:code/@codeSystem ='2.16.840.1.113883.6.1' ">
              <p class="law_icon">
                <xsl:call-template name="getLawIcon" />
                <a href="#id42348-3"><xsl:text>Patientenverfügung vorhanden</xsl:text></a>
              </p>
            </xsl:if>
          </div>
        </div>

        <!--
          BODY
        -->
        <div class="body_section" id="IDBody">
          <xsl:apply-templates select="n1:component/n1:structuredBody|n1:component/n1:nonXMLBody"/>
          <br />
          <br />
        </div><!-- END body section -->

        <!--
            FOOTER
        -->
        <xsl:call-template name="bottomline"/>
        <div class="clearer"></div>

        <hr />
        <div class="footer">
          <a href="http://www.elga.gv.at" target="_blank">
            <img class="footer_logo" alt="elga logo" src="data:image/png;base64,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" />
          </a>
          <p>Öffentliches Gesundheitsportal Österreichs <a href="http://www.gesundheit.gv.at" target="_blank">www.gesundheit.gv.at</a></p>
        </div>
      </div>
      </div></body>
    </html>
  </xsl:template>

  <!-- Print elements as separated list -->
  <xsl:template name="renderListItems">
    <xsl:param name="list" />

    <xsl:for-each select="$list">
      <xsl:if test="position()>1"><xsl:text>, </xsl:text></xsl:if>
      <xsl:value-of select="." />
    </xsl:for-each>
  </xsl:template>

  <!-- Get a Name -->
  <xsl:template name="getName">
    <xsl:param name="name"/>
    <xsl:choose>
      <xsl:when test="$name/n1:family">
        <xsl:if test="$name/n1:prefix">
          <xsl:for-each select="$name/n1:prefix">
            <xsl:value-of select="."/>
            <xsl:text> </xsl:text>
          </xsl:for-each>
        </xsl:if>
        <xsl:for-each select="$name/n1:given">
          <xsl:value-of select="."/>
          <xsl:text> </xsl:text>
        </xsl:for-each>
        <xsl:for-each select="$name/n1:family">
          <xsl:if test="not(@qualifier)">
            <xsl:value-of select="."/>
          </xsl:if>
        </xsl:for-each>
        <xsl:if test="$name/n1:suffix">
          <xsl:for-each select="$name/n1:suffix">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="."/>
          </xsl:for-each>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- guardian -->
  <xsl:template match="n1:guardian">
    <div class="guardianContact">
      <p class="guardianName"><xsl:apply-templates select="n1:guardianPerson/n1:name | n1:guardianOrganization/n1:name"/></p>
      <xsl:call-template name="getContactInfo">
        <xsl:with-param name="contact" select="."/>
      </xsl:call-template>
      <xsl:if test="n1:guardianOrganization/n1:asOrganizationPartOf/n1:wholeOrganization">
        <xsl:call-template name="getOrganization">
          <xsl:with-param name="organization" select="n1:guardianOrganization/n1:asOrganizationPartOf/n1:wholeOrganization"/>
        </xsl:call-template>
      </xsl:if>
    </div>
  </xsl:template>

  <!--  Format Date
    outputs a date in day.month.year form
    e.g., 19991207  ==>  7. Dezember 1999
  -->
  <xsl:template name="formatDate">
    <xsl:param name="date"/>
    <xsl:choose>
      <xsl:when test="substring ($date, 7, 1)='0'">
        <xsl:value-of select="substring ($date, 8, 1)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="substring ($date, 7, 2)"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>. </xsl:text>
    <xsl:variable name="month" select="substring ($date, 5, 2)"/>
    <xsl:choose>
      <xsl:when test="$month='01'">
        <xsl:text>Januar </xsl:text>
      </xsl:when>
      <xsl:when test="$month='02'">
        <xsl:text>Februar </xsl:text>
      </xsl:when>
      <xsl:when test="$month='03'">
        <xsl:text>März </xsl:text>
      </xsl:when>
      <xsl:when test="$month='04'">
        <xsl:text>April </xsl:text>
      </xsl:when>
      <xsl:when test="$month='05'">
        <xsl:text>Mai </xsl:text>
      </xsl:when>
      <xsl:when test="$month='06'">
        <xsl:text>Juni </xsl:text>
      </xsl:when>
      <xsl:when test="$month='07'">
        <xsl:text>Juli </xsl:text>
      </xsl:when>
      <xsl:when test="$month='08'">
        <xsl:text>August </xsl:text>
      </xsl:when>
      <xsl:when test="$month='09'">
        <xsl:text>September </xsl:text>
      </xsl:when>
      <xsl:when test="$month='10'">
        <xsl:text>Oktober </xsl:text>
      </xsl:when>
      <xsl:when test="$month='11'">
        <xsl:text>November </xsl:text>
      </xsl:when>
      <xsl:when test="$month='12'">
        <xsl:text>Dezember </xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:value-of select="substring ($date, 1, 4)"/>
    <xsl:variable name="hour" select="substring ($date, 9, 2)"/>
    <xsl:if test="$hour != ''">
      <xsl:text> um </xsl:text>
      <xsl:choose>
        <xsl:when test="$hour!='00'">
          <xsl:text> </xsl:text>
          <xsl:value-of select="substring ($date, 9, 2)"/>
          <xsl:text>:</xsl:text>
          <xsl:value-of select="substring ($date, 11, 2)"/>
        </xsl:when>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <!-- nonXMLBody -->
  <xsl:template match="n1:component/n1:nonXMLBody">
    <hr />
    <xsl:choose>
      <!-- if there is a reference, use that in an IFRAME -->
      <xsl:when test="n1:text/n1:reference">
        <IFRAME name="nonXMLBody" id="nonXMLBody" WIDTH="100%" HEIGHT="66%" src="{n1:text/n1:reference/@value}"/>
      </xsl:when>
      <xsl:when test="n1:text/@mediaType='text/plain'">
        <pre>
          <xsl:value-of select="n1:text/text()"/>
        </pre>
      </xsl:when>
      <!-- create PDF link -->
      <xsl:when test="n1:text/@mediaType='application/pdf'">
        <xsl:call-template name="generatePDFDownloadLink">
          <xsl:with-param name="text" select="n1:text" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <CENTER>Cannot display the text</CENTER>
      </xsl:otherwise>
    </xsl:choose>
    <hr />
  </xsl:template>

  <!-- Generate PDF download link -->
  <xsl:template name="generatePDFDownloadLink">
    <xsl:param name="text" select="n1:text" />
    <xsl:variable name="base64EncodeServiceURL" ><![CDATA[http://vserver40.local.netconomy.net/elga/base64/xsltBase64Encoder]]></xsl:variable>
    <form method="post" action="{$base64EncodeServiceURL}">
      <input type="hidden" name="mediaType" value="application/pdf" />
      <!-- optional: defines the filename, otherwise extracted from pdf -->
      <input type="hidden" name="filename" value="" />
      <xsl:element name="input">
        <xsl:attribute name="type">hidden</xsl:attribute>
        <xsl:attribute name="name">data</xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select='$text' /></xsl:attribute>
      </xsl:element>
      <input class="submitLink" type="submit" value="PDF herunterladen" />
    </form>
  </xsl:template>

  <!-- StructuredBody -->
  <xsl:template match="n1:component/n1:structuredBody">
    <xsl:apply-templates select="n1:component/n1:section"/>
  </xsl:template>


  <!--
    Component/Section
  -->
  <xsl:template match="n1:component/n1:section">
    <!-- zeige TITEL der Sektion -->
    <xsl:choose>
      <!-- Briefkopf: zeige keinen Titel -->
      <xsl:when test="n1:code/@code = 'BRIEFT' "/>
      <!-- Abschließende Bemerkungen: zeige keinen Titel, füge 4 BRs voran-->
      <xsl:when test="n1:code/@code = 'ABBEM' ">
        <br/>
        <br/>
        <br/>
        <br/>
      </xsl:when>
      <!-- do not show section risk here -->
      <xsl:when test="n1:code/@code = '51898-5' and n1:code/@codeSystem ='2.16.840.1.113883.6.1' "/>
      <xsl:otherwise>
        <xsl:apply-templates select="n1:title">
          <xsl:with-param name="code" select="n1:code"/>
        </xsl:apply-templates>
      </xsl:otherwise>
    </xsl:choose>

    <!-- text of section -->
    <xsl:choose>
      <!-- salutation (Briefkopf: eigene Formatierung / BRIEFT ABBEM) -->
      <xsl:when test="n1:code/@code = 'ABBEM' or n1:code/@code = 'BRIEFT' ">
        <div class="salutation"><xsl:apply-templates select="n1:text"/></div>
      </xsl:when>
      <!-- rendering for risk -->
      <xsl:when test="n1:code/@code = '51898-5' and n1:code/@codeSystem ='2.16.840.1.113883.6.1' ">
        <div class="risk">
          <xsl:apply-templates select="n1:title">
            <xsl:with-param name="code" select="n1:code"/>
          </xsl:apply-templates>
          <xsl:apply-templates select="n1:text"/>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="n1:text"/>
      </xsl:otherwise>
    </xsl:choose>

    <!-- section is intended -->
    <xsl:if test="n1:component/n1:section">
      <div class="section_indent">
        <xsl:apply-templates select="n1:component/n1:section"/>
      </div>
    </xsl:if>
    <xsl:if test="n1:code/@code = 'ABBEM' ">
      <hr/>
    </xsl:if>
  </xsl:template>

  <!--   Title within a section from h2 to h4 -->
  <xsl:template match="n1:title">
    <xsl:param name="code" select="''"/>
    <xsl:variable name="header">
    <xsl:choose>
      <xsl:when test="count(ancestor::*/n1:section) > 1">h3</xsl:when>
      <xsl:when test="count(ancestor::*/n1:section) > 2">h4</xsl:when>
      <xsl:otherwise>h2</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:element name="{$header}">
    <xsl:attribute name="id">id<xsl:value-of select="$code/@code"/></xsl:attribute>
    <xsl:attribute name="class"></xsl:attribute> <!-- enter class 'tooltipTrigger' to enable title tooltip -->
        <xsl:value-of select="."/>
        <xsl:call-template name="titleextra" >
      <xsl:with-param name="code" select="$code" />
        </xsl:call-template>
    </xsl:element>
  </xsl:template>

  <!--
  Title backlink to document top and tooltip
  -->
  <xsl:template name="titleextra">
  <xsl:param name="code" />
  <a class="backlink" href="#elgadocument">[↑]</a>
    <span class="tooltip">
        <span class="tooltipentry"><xsl:value-of select="$code/@code"/></span>
        <span class="tooltipentry"><xsl:value-of select="$code/@codeSystemName"/></span>
        <span class="tooltipentry"><xsl:value-of select="$code/@displayName"/></span>
    </span>
  </xsl:template>

  <!--   footnoteref -->
  <xsl:template match="n1:footnoteref">
    <sup>
      <i>
        <xsl:apply-templates/>
      </i>
    </sup>
  </xsl:template>

  <!--   remark -->
  <xsl:template match="n1:remark">
    <tr>
      <td/>
      <td colspan="6" bgcolor="#ffff66" style="font-size:80%">
        <i>
          <xsl:apply-templates/>
        </i>
      </td>
    </tr>
  </xsl:template>

  <!--   Text   -->
  <xsl:template match="n1:text">
    <div class="section_text"><xsl:apply-templates/></div>
  </xsl:template>

  <!--   paragraph  -->
  <xsl:template match="n1:paragraph">
    <p class="paragraph"><xsl:apply-templates/></p>
  </xsl:template>

  <!--   line break  -->
  <xsl:template match="n1:br">
    <xsl:apply-templates/>
    <br />
  </xsl:template>

  <!--     Content w/ deleted text is hidden -->
  <xsl:template match="n1:content[@revised='delete']"/>

  <!--   content  -->
  <xsl:template match="n1:content">
    <xsl:apply-templates/>
  </xsl:template>

  <!--   list  -->
  <xsl:template match="n1:list">
    <!-- caption -->
    <xsl:if test="n1:caption">
      <span style="font-weight:bold; ">
        <xsl:apply-templates select="n1:caption"/>
      </span>
    </xsl:if>
    <!-- item -->
    <xsl:choose>
      <xsl:when test="@listType='ordered'">
        <ol>
          <xsl:for-each select="n1:item">
            <li>
              <!-- list element-->
              <xsl:apply-templates/>
            </li>
          </xsl:for-each>
        </ol>
      </xsl:when>
      <xsl:otherwise>
        <!-- list is unordered -->
        <ul>
          <xsl:for-each select="n1:item">
            <li>
              <!-- list element-->
              <xsl:apply-templates/>
            </li>
          </xsl:for-each>
        </ul>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--   caption  -->
  <xsl:template match="n1:caption">
    <div class="caption">
      <xsl:apply-templates/>
      <xsl:text>: </xsl:text>
    </div>
  </xsl:template>
  <xsl:template match="n1:paragraph/n1:caption">
    <span class="caption">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!--
  table
  tfoot with colspan over rows
  even/odd rendering done with css3 because of new xELGA_red class on <tr>
   -->
  <xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
    <xsl:copy>
    <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="n1:table">
  <xsl:variable name="numColumns">
        <xsl:value-of select="count(n1:thead/n1:tr/n1:th)"/>
    </xsl:variable>
    <table class="section_table" cellspacing="0" cellpadding="0"><!--  numColumns="{$numColumns}" -->
    <xsl:apply-templates>
      <xsl:with-param name="numColumns" select="$numColumns" />
    </xsl:apply-templates>
    </table>
  </xsl:template>
  <xsl:template match="n1:thead">
    <thead>
      <xsl:apply-templates/>
    </thead>
  </xsl:template>
  <xsl:template match="n1:tfoot">
  <xsl:param name="numColumns"/>
    <tfoot>
        <xsl:apply-templates>
      <xsl:with-param name="numColumns" select="$numColumns" />
    </xsl:apply-templates>
    </tfoot>
  </xsl:template>
  <xsl:template match="n1:tbody">
    <tbody>
      <xsl:apply-templates/>
    </tbody>
  </xsl:template>
  <xsl:template match="n1:colgroup">
    <colgroup>
      <xsl:apply-templates/>
    </colgroup>
  </xsl:template>
  <xsl:template match="n1:col">
    <col>
      <xsl:apply-templates/>
    </col>
  </xsl:template>
  <xsl:template match="n1:tr[position() mod 2 = 1]">
  <xsl:param name="numColumns"/>
    <tr class="odd">
    <xsl:apply-templates>
      <xsl:with-param name="numColumns" select="$numColumns" />
    </xsl:apply-templates>
    </tr>
  </xsl:template>
  <xsl:template match="n1:tr">
    <xsl:param name="numColumns"/>
    <tr class="even">
    <xsl:apply-templates>
      <xsl:with-param name="numColumns" select="$numColumns" />
    </xsl:apply-templates>
    </tr>
  </xsl:template>
  <xsl:template match="n1:th">
    <th>
      <xsl:apply-templates/>
    </th>
  </xsl:template>
  <xsl:template match="n1:td">
    <td>
      <xsl:apply-templates/>
    </td>
  </xsl:template>
  <xsl:template match="n1:tfoot/*/n1:td">
  <xsl:param name="numColumns"/>
    <td colspan="{$numColumns}">
      <xsl:apply-templates/>
    </td>
  </xsl:template>
  <xsl:template match="n1:table/n1:caption">
    <span class="caption">
      <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!--   RenderMultiMedia
    this currently only handles GIF's and JPEG's.  It could, however,
    be extended by including other image MIME types in the predicate
    and/or by generating <object> or <applet> tag with the correct
    params depending on the media type  @ID  =$imageRef  referencedObject
    -->
  <xsl:template match="n1:renderMultiMedia">
    <xsl:variable name="imageRef" select="@referencedObject"/>
    <xsl:choose>
      <xsl:when test="//n1:regionOfInterest[@ID=$imageRef]">
        <!-- Here is where the Region of Interest image referencing goes -->
        <xsl:if test="//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value[@mediaType='image/gif' or
          @mediaType='image/jpeg']">
          <br class="clearer" ></br>
          <xsl:element name="img">
            <xsl:attribute name="src"><xsl:value-of select="//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value/n1:reference/@value"/></xsl:attribute>
          </xsl:element>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <!-- Here is where the direct MultiMedia image referencing goes -->
        <xsl:if test="//n1:observationMedia[@ID=$imageRef]/n1:value/@mediaType='application/pdf'">
          <xsl:variable name="doctitle" select="//n1:observationMedia[@ID=$imageRef]/@ID"></xsl:variable>
          <xsl:call-template name="generatePDFDownloadLink">
            <xsl:with-param name="text" select="//n1:observationMedia[@ID=$imageRef]/n1:value" />
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="//n1:observationMedia[@ID=$imageRef]/n1:value[@mediaType='image/gif' or @mediaType='image/jpeg']">
          <xsl:choose>
            <!-- image data inline B64 coded -->
            <xsl:when test="//n1:observationMedia[@ID=$imageRef]/n1:value[@representation='B64']">
              <br class="clearer" ></br>
              <xsl:element name="img">
                <xsl:attribute name="src">data:
                  <xsl:value-of select="//n1:observationMedia[@ID=$imageRef]/n1:value/@mediaType"/>;base64,
                  <xsl:value-of select="//n1:observationMedia[@ID=$imageRef]/n1:value"/></xsl:attribute>
              </xsl:element>
            </xsl:when>
            <!-- image ref -->
            <xsl:otherwise>
              <br class="clearer" ></br>
              <xsl:element name="img">
                <xsl:attribute name="src"><xsl:value-of select="//n1:observationMedia[@ID=$imageRef]/n1:value/n1:reference/@value"/></xsl:attribute>
              </xsl:element>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--   RenderLogo
    only handles PNG's and JPEG's.  It could, however,
  media type  @ID  =$imageRef  referencedObject
    -->
  <xsl:template name="renderLogo">
    <xsl:param name="logo"/>
    <xsl:if test="$logo/n1:value[@mediaType='image/png' or @mediaType='image/jpg' or @mediaType='image/jpeg']">
        <!-- image data inline B64 coded -->
        <xsl:if test="$logo/n1:value/@representation='B64'">
          <xsl:element name="img">
            <xsl:attribute name="src">data:
              <xsl:value-of select="$logo/n1:value/@mediaType"/>;base64,
              <xsl:value-of select="$logo/n1:value"/></xsl:attribute>
            <xsl:attribute name="alt"><xsl:value-of select="$logo/@ID"/></xsl:attribute>
          </xsl:element>
        </xsl:if>
    </xsl:if>
  </xsl:template>

  <!--    Stylecode processing
    Supports Bold, Underline, Italics and xELGA_* display
    It also additionally supports Heading1 to Heading3
    -->
  <xsl:template match="//n1:*[@styleCode]">
    <xsl:if test="contains(@styleCode,'Comment')">
      <xsl:if test="contains(@styleCode,'ReportComment')">
        <table width="100%" cellspacing="0" cellpadding="0">
          <tbody>
            <tr>
              <td>Befundkommentar: </td>
              <td>
                <xsl:apply-templates/>
              </td>
            </tr>
          </tbody>
        </table>
      </xsl:if>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Heading')">
      <xsl:if test="contains(@styleCode,'Heading1')">
        <xsl:element name="h1">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="contains(@styleCode,'Heading2')">
        <xsl:element name="h2">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="contains(@styleCode,'Heading3')">
        <xsl:element name="h3">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'xELGA_h')">
      <xsl:if test="contains(@styleCode,'xELGA_h1')">
        <xsl:element name="h1">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="contains(@styleCode,'xELGA_h2')">
        <xsl:element name="h2">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
      <xsl:if test="contains(@styleCode,'xELGA_h3')">
        <xsl:element name="h3">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
    </xsl:if>
    <xsl:if test="@styleCode='Bold'">
      <xsl:element name="strong">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
    <xsl:if test="@styleCode='Italics'">
      <xsl:element name="i">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
    <xsl:if test="@styleCode='Underline'">
      <xsl:element name="u">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Italics') and not (contains(@styleCode, 'Underline'))">
      <xsl:element name="strong">
        <xsl:element name="i">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Italics'))">
      <xsl:element name="strong">
        <xsl:element name="u">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Bold'))">
      <xsl:element name="i">
        <xsl:element name="u">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and contains(@styleCode, 'Bold')">
      <xsl:element name="strong">
        <xsl:element name="i">
          <xsl:element name="u">
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'xELGA_red')">
    <xsl:element name="{local-name()}">
      <xsl:attribute name="class">xred</xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
    </xsl:if>
    <!-- need this, because the <tr> will otherwise be omitted (as long as the xred on <tr> exists)  -->
    <xsl:if test="contains(@styleCode,'xRed')">
    <xsl:element name="{local-name()}">
      <xsl:apply-templates/>
    </xsl:element>
    </xsl:if>
    <xsl:if test="not (contains(@styleCode,'Italics') or contains(@styleCode,'Underline') or contains(@styleCode, 'Bold') or contains(@styleCode, 'Heading')) and not(contains(@styleCode, 'xELGA_h') or contains(@styleCode,'xELGA_red') or contains(@styleCode,'xRed'))">
      <xsl:apply-templates/>
    </xsl:if>
  </xsl:template>

  <!--    Superscript or Subscript   -->
  <xsl:template match="n1:sup">
    <xsl:element name="sup">
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="n1:sub">
    <xsl:element name="sub">
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>

  <!--
    Contact Information
  different rendering for telecom and addresses
  -->
  <xsl:template name="getContactInfo">
    <xsl:param name="contact"/>
    <xsl:apply-templates select="$contact/n1:addr"/>
    <xsl:apply-templates select="$contact/n1:telecom"/>
  </xsl:template>

  <xsl:template name="getContactAddress">
    <xsl:param name="contact"/>
    <div class="contactAddress">
      <xsl:apply-templates select="$contact/n1:addr"/>
    </div>
  </xsl:template>

  <xsl:template name="getContactTelecom">
    <xsl:param name="contact"/>
    <xsl:apply-templates select="$contact/n1:telecom">
        <xsl:with-param name="asTable" select="false()" />
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template name="getContactTelecomTable">
    <xsl:param name="contact"/>
    <xsl:apply-templates select="$contact/n1:telecom">
        <xsl:with-param name="asTable" select="true()" />
    </xsl:apply-templates>
  </xsl:template>

  <!--
  get address
  -->
  <xsl:template match="n1:addr">
    <div class="address">
    <p class="addressRegion">
    <xsl:if test="@use">
      <!-- Wohnadresse etc. -->
      <xsl:call-template name="translateCode">
        <xsl:with-param name="code" select="@use"/>
      </xsl:call-template>
    </xsl:if>
    </p>
    <xsl:for-each select="n1:streetAddressLine">
      <p class="streetAddress"><xsl:value-of select="."/></p>
    </xsl:for-each>
    <p class="street">
    <xsl:if test="n1:streetName">
      <xsl:value-of select="n1:streetName"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="n1:houseNumber"/>
    </xsl:if>
    </p>
    <p class="city">
    <xsl:value-of select="n1:postalCode"/>
    <xsl:text> </xsl:text>
    <xsl:variable name="uppercase" >
    <xsl:if test="n1:country != 'Österreich' and n1:country != 'A' and n1:country != 'Austria' and n1:country != 'Oesterreich' " >
      uppercase
    </xsl:if>
    </xsl:variable>
    <span class="{$uppercase}"><xsl:value-of select="n1:city"/></span>
    <xsl:if test="n1:state">
      <xsl:text>, </xsl:text>
      <xsl:value-of select="n1:state"/>
    </xsl:if>
    </p>
    <xsl:if test="n1:country != 'Österreich' and n1:country != 'A' and n1:country != 'Austria' and n1:country != 'Oesterreich' ">
    <p class="country">
      <xsl:value-of select="n1:country"/>
    </p>
    </xsl:if>
    <xsl:value-of select="text()"/>
    </div>
  </xsl:template>

  <!--
    get telecom information (tel, www, ...)
  -->
  <xsl:template match="n1:telecom">
    <xsl:param name="asTable" />
    <xsl:variable name="type" select="substring-before(@value, ':')"/>
    <xsl:variable name="value" select="substring-after(@value, ':')"/>
    <xsl:if test="$type and not($asTable)">
      <p class="telecom">
        <xsl:call-template name="translateCode">
          <xsl:with-param name="code" select="$type"/>
        </xsl:call-template>
        <xsl:if test="@use">
          <span class="lighter"><xsl:text> (</xsl:text>
          <xsl:call-template name="translateCode">
            <xsl:with-param name="code" select="@use"/>
          </xsl:call-template>
          <xsl:text>)</xsl:text></span>
        </xsl:if>
        <xsl:text>: </xsl:text>
        <xsl:text> </xsl:text>
        <xsl:choose>
          <!-- is url -->
          <xsl:when test="$type='http'"><a href="{@value}"><xsl:value-of select="@value"/></a></xsl:when>
          <!-- is mail -->
          <xsl:when test="$type='mailto'"><a href="{@value}"><xsl:value-of select="$value"/></a></xsl:when>
          <xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
        </xsl:choose>
      </p>
    </xsl:if>
    <xsl:if test="$type and $asTable">
      <tr class="telecom">
        <td class="firstrow">
        <xsl:call-template name="translateCode">
          <xsl:with-param name="code" select="$type"/>
        </xsl:call-template>
        <xsl:if test="@use">
          <span class="lighter"><xsl:text> (</xsl:text>
          <xsl:call-template name="translateCode">
            <xsl:with-param name="code" select="@use"/>
          </xsl:call-template>
          <xsl:text>)</xsl:text></span>
        </xsl:if>
        <xsl:text>: </xsl:text>
        </td>
        <td>
        <xsl:choose>
          <!-- is url -->
          <xsl:when test="$type='http'"><a href="{@value}"><xsl:value-of select="@value"/></a></xsl:when>
          <!-- is mail -->
          <xsl:when test="$type='mailto'"><a href="{@value}"><xsl:value-of select="$value"/></a></xsl:when>
          <xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
        </xsl:choose>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template name="getAddress">
    <xsl:param name="addr"/>
    <div class="address">
    <xsl:if test="$addr/n1:additionalLocator">
      <p class="locator"><xsl:value-of select="$addr/n1:additionalLocator"/></p>
    </xsl:if>
    <xsl:if test="$addr/n1:streetAddressLine">
      <p class="streetAddress"><xsl:value-of select="$addr/n1:streetAddressLine"/></p>
    </xsl:if>
    <p class="street">
    <xsl:if test="$addr/n1:streetName">
      <xsl:value-of select="$addr/n1:streetName"/>
    </xsl:if>
    <xsl:if test="$addr/n1:houseNumber">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$addr/n1:houseNumber"/>
    </xsl:if>
    </p>
    <xsl:if test="$addr/n1:postalCode or $addr/n1:city">
      <p class="city">
      <xsl:value-of select="$addr/n1:postalCode"/>
      <xsl:text> </xsl:text>
    <xsl:variable name="uppercase" >
      <xsl:if test="$addr/n1:country != 'Österreich' and $addr/n1:country != 'A' and $addr/n1:country != 'Austria' and $addr/n1:country != 'Oesterreich' " >
      uppercase
      </xsl:if>
      </xsl:variable>
      <span class="{$uppercase}"><xsl:value-of select="$addr/n1:city"/></span>
      <xsl:if test="$addr/n1:state">
        <xsl:text>, </xsl:text>
        <xsl:value-of select="$addr/n1:state"/>
      </xsl:if>
      </p>
      <xsl:if test="$addr/n1:country != 'Österreich' and $addr/n1:country != 'A' and $addr/n1:country != 'Austria' and $addr/n1:country != 'Oesterreich' ">
      <p class="country">
        <xsl:value-of select="$addr/n1:country"/>
      </p>
      </xsl:if>
    </xsl:if>
    </div>
  </xsl:template>

  <xsl:template name="getAuthor">
    <xsl:param name="author"/>
    <xsl:if test="$author/n1:assignedPerson/n1:name">
      <xsl:call-template name="getName">
        <xsl:with-param name="name" select="$author/n1:assignedPerson/n1:name"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="$author/../n1:time/@value">
        (am
        <xsl:call-template name="formatDate">
        <xsl:with-param name="date" select="$author/../n1:time/@value"/>
      </xsl:call-template>)
      </xsl:if>
    <xsl:if test="$author/n1:addr">
      <xsl:call-template name="getAddress">
        <xsl:with-param name="addr" select="$author/n1:addr"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="$author/n1:telecom">
      <xsl:apply-templates select="$author/n1:telecom"/>
    </xsl:if>
    <br/>
  </xsl:template>

  <xsl:template name="getOrganization">
    <xsl:param name="organization"/>
      <xsl:if test="$organization/n1:name">
        <p class="organisationName"><xsl:value-of select="$organization/n1:name"/></p>
      </xsl:if>
      <xsl:if test="$organization/n1:addr">
        <xsl:call-template name="getAddress">
          <xsl:with-param name="addr" select="$organization/n1:addr"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:if test="$organization/n1:telecom">
        <xsl:apply-templates select="$organization/n1:telecom"/>
      </xsl:if>
      <xsl:if test="$organization/n1:asOrganizationPartOf/n1:wholeOrganization">
        <xsl:call-template name="getOrganization">
          <xsl:with-param name="organization" select="$organization/n1:asOrganizationPartOf/n1:wholeOrganization"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>

  <xsl:template name="getIntendedRecipient">
    <xsl:param name="recipient"/>
    <div class="recipient">
      <xsl:text>z.H.: </xsl:text>
      <xsl:if test="$recipient/n1:informationRecipient/n1:name">
        <xsl:call-template name="getName">
          <xsl:with-param name="name" select="$recipient/n1:informationRecipient/n1:name"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:if test="$recipient/n1:addr">
        <xsl:call-template name="getAddress">
          <xsl:with-param name="addr" select="$recipient/n1:addr"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:if test="$recipient/n1:telecom">
        <xsl:apply-templates select="$recipient/n1:telecom"/>
      </xsl:if>
    </div>
  </xsl:template>

  <!--
    code translations for ambulantory description
  -->
  <xsl:template name="getAmbulatory">
    <xsl:param name="effectiveTime" />
    <xsl:param name="code" />
    <xsl:variable name="codeName" select="$code/@code" />
    <xsl:variable name="codeSys" select="$code/@codeSystem" />
    <xsl:variable name="prefix">
      <xsl:choose>
        <xsl:when test="$codeName = 'AMB' and $codeSys = '2.16.840.1.113883.5.4' ">Ambulant</xsl:when>
        <xsl:when test="$codeName = 'EMER' and $codeSys = '2.16.840.1.113883.5.4' ">Akutbeandlung</xsl:when>
        <xsl:when test="$codeName = 'HH' and $codeSys = '2.16.840.1.113883.5.4' ">Hausbesuch</xsl:when>
        <xsl:when test="$codeName = 'IMP' and $codeSys = '2.16.840.1.113883.5.4' ">Stationär</xsl:when>
        <xsl:when test="$codeName = 'ACUTE' and $codeSys = '2.16.840.1.113883.5.4' ">Stationär</xsl:when>
        <xsl:when test="$codeName = 'NONAC' and $codeSys = '2.16.840.1.113883.5.4' ">Stationär</xsl:when>
        <xsl:when test="$codeName = 'VR' and $codeSys = '2.16.840.1.113883.5.4' ">Behandlung</xsl:when>
        <xsl:otherwise> </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="$prefix"/><xsl:text> von: </xsl:text>
        <xsl:call-template name="formatDate">
            <xsl:with-param name="date" select="$effectiveTime/n1:low/@value"/>
        </xsl:call-template>
        <xsl:text> bis: </xsl:text>
        <xsl:call-template name="formatDate">
            <xsl:with-param name="date" select="$effectiveTime/n1:high/@value"/>
        </xsl:call-template>
  </xsl:template>

  <!--
    code translations for marital status
  -->
  <xsl:template name="getMaritalStatus">
    <xsl:param name="maritalStatus" />
    <xsl:variable name="code" select="$maritalStatus/@code" />
    <xsl:variable name="codeSys" select="$maritalStatus/@codeSystem" />
    <xsl:choose>
      <xsl:when test="$code = 'D' and $codeSys = '2.16.840.1.113883.5.2' ">Geschieden</xsl:when>
      <xsl:when test="$code = 'M' and $codeSys = '2.16.840.1.113883.5.2' ">Verheiratet</xsl:when>
      <xsl:when test="$code = 'S' and $codeSys = '2.16.840.1.113883.5.2' ">Ledig</xsl:when>
      <xsl:when test="$code = 'T' and $codeSys = '2.16.840.1.113883.5.2' ">Lebenspartnerschaft</xsl:when>
      <xsl:when test="$code = 'W' and $codeSys = '2.16.840.1.113883.5.2' ">Verwitwet</xsl:when>
    </xsl:choose>
  </xsl:template>

   <!--
    code translations for title tooltip
  -->
  <xsl:template name="getTitel">
    <xsl:param name="titel" />
    <xsl:variable name="code" select="$titel/@code" />
    <xsl:variable name="codeSys" select="$titel/@codeSystem" />
    <xsl:choose>
      <xsl:when test="$code = '18842-5' and $codeSys = '2.16.840.1.113883.6.1' ">Entlassungsbrief</xsl:when>
      <xsl:when test="$code = '11490-0' and $codeSys = '2.16.840.1.113883.6.1' ">Entlassungsbrief aus stationärer Behandlung (Arzt)</xsl:when>
      <xsl:when test="$code = '34745-0' and $codeSys = '2.16.840.1.113883.6.1' ">Entlassungsbrief aus stationärer Behandlung (Pflege)</xsl:when>
      <xsl:when test="$code = '11502-2' and $codeSys = '2.16.840.1.113883.6.1' ">Laborbefund</xsl:when>
      <xsl:when test="$code = '18748-4' and $codeSys = '2.16.840.1.113883.6.1' ">Befund bildgebende Diagnostik</xsl:when>
      <xsl:when test="$code = '18747-6' and $codeSys = '2.16.840.1.113883.6.1' ">Computertomographie-Befund</xsl:when>
      <xsl:when test="$code = '18755-9' and $codeSys = '2.16.840.1.113883.6.1' ">Magnetresonanztomographie-Befund</xsl:when>
      <xsl:when test="$code = '18760-9' and $codeSys = '2.16.840.1.113883.6.1' ">Ultraschall-Befund</xsl:when>
      <xsl:when test="$code = '18757-5' and $codeSys = '2.16.840.1.113883.6.1' ">Nuklearmedizinischer Befund</xsl:when>
      <xsl:when test="$code = '18758-3' and $codeSys = '2.16.840.1.113883.6.1' ">Positronen-Emissions-Tomographie-Befund</xsl:when>
      <xsl:when test="$code = '18745-0' and $codeSys = '2.16.840.1.113883.6.1' ">Herzkatheter-Befund</xsl:when>
      <xsl:when test="$code = '11522-0' and $codeSys = '2.16.840.1.113883.6.1' ">Echokardiographie-Befund</xsl:when>
      <xsl:when test="$code = '18782-3' and $codeSys = '2.16.840.1.113883.6.1' ">Radiologie-Befund</xsl:when>
      <xsl:when test="$code = '18746-8' and $codeSys = '2.16.840.1.113883.6.1' ">Kolonoskopie-Befund</xsl:when>
      <xsl:when test="$code = '18751-8' and $codeSys = '2.16.840.1.113883.6.1' ">Endoskopie-Befund</xsl:when>
      <xsl:when test="$code = '11525-3' and $codeSys = '2.16.840.1.113883.6.1' ">Geburtshilfliche Ultraschalluntersuchung</xsl:when>
      <xsl:when test="$code = '55113-5' and $codeSys = '2.16.840.1.113883.6.1' ">KOS Objekte</xsl:when>
    </xsl:choose>
  </xsl:template>

   <!--
    code translations for religious affilitaion
    fallback is displayname
  -->
  <xsl:template name="getReligiousAffiliation">
    <xsl:param name="religiousAffiliation" />
    <xsl:variable name="code" select="$religiousAffiliation/@code" />
    <xsl:variable name="codeSys" select="$religiousAffiliation/@codeSystem" />
    <xsl:choose>
      <xsl:when test="$code = '100' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Katholische Kirche (o.n.A.)</xsl:when>
      <xsl:when test="$code = '101' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Römisch-Katholisch</xsl:when>
      <xsl:when test="$code = '102' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Griechisch-Katholische Kirche</xsl:when>
      <xsl:when test="$code = '103' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Armenisch-Katholische Kirche</xsl:when>
      <xsl:when test="$code = '104' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Bulgarisch-Katholische Kirche</xsl:when>
      <xsl:when test="$code = '105' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Rumänische griechisch-katholische Kirche</xsl:when>
      <xsl:when test="$code = '106' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Russisch-Katholische Kirche</xsl:when>
      <xsl:when test="$code = '107' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Syrisch-Katholische Kirche</xsl:when>
      <xsl:when test="$code = '108' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Ukrainische Griechisch-Katholische Kirche</xsl:when>
      <xsl:when test="$code = '109' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Katholische Ostkirche (ohne nähere Angabe)</xsl:when>
      <xsl:when test="$code = '110' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Griechisch-Orientalische Kirchen</xsl:when>
      <xsl:when test="$code = '111' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Orthodoxe Kirchen (o.n.A.)</xsl:when>
      <xsl:when test="$code = '112' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Griechisch-Orthodoxe Kirche (Hl.Dreifaltigkeit)</xsl:when>
      <xsl:when test="$code = '113' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Griechisch-Orthodoxe Kirche (Hl.Georg)</xsl:when>
      <xsl:when test="$code = '114' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Bulgarisch-Orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '115' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Rumänisch-griechisch-orientalische Kirche</xsl:when>
      <xsl:when test="$code = '116' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Russisch-Orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '117' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Serbisch-griechisch-Orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '118' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Ukrainisch-Orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '119' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Orientalisch-Orthodoxe Kirchen</xsl:when>
      <xsl:when test="$code = '120' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Armenisch-apostolische Kirche</xsl:when>
      <xsl:when test="$code = '121' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Syrisch-orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '122' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Syrisch-orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '123' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Koptisch-orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '124' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Armenisch-apostolische Kirche</xsl:when>
      <xsl:when test="$code = '125' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Äthiopisch-Orthodoxe Kirche</xsl:when>
      <xsl:when test="$code = '126' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Evangelische Kirchen Österreich</xsl:when>
      <xsl:when test="$code = '127' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Evangelische Kirche (o.n.A.)</xsl:when>
      <xsl:when test="$code = '128' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Evangelische Kirche A.B.</xsl:when>
      <xsl:when test="$code = '129' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Evangelische Kirche H.B.</xsl:when>
      <xsl:when test="$code = '130' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Andere Christliche Kirchen</xsl:when>
      <xsl:when test="$code = '131' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Altkatholische Kirche Österreichs</xsl:when>
      <xsl:when test="$code = '132' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Anglikanische Kirche</xsl:when>
      <xsl:when test="$code = '133' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Evangelisch-methodistische Kirche (EmK)</xsl:when>
      <xsl:when test="$code = '134' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Sonstige Christliche Gemeinschaften</xsl:when>
      <xsl:when test="$code = '135' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Baptisten</xsl:when>
      <xsl:when test="$code = '136' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Bund evangelikaler Gemeinden in Österreich </xsl:when>
      <xsl:when test="$code = '137' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Freie Christengemeinde/Pfingstgemeinde </xsl:when>
      <xsl:when test="$code = '138' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Mennonitische Freikirche</xsl:when>
      <xsl:when test="$code = '139' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Kirche der Siebenten-Tags-Adventisten </xsl:when>
      <xsl:when test="$code = '140' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Christengemeinschaft</xsl:when>
      <xsl:when test="$code = '141' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Jehovas Zeugen</xsl:when>
      <xsl:when test="$code = '142' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Neuapostolische Kirche</xsl:when>
      <xsl:when test="$code = '143' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Mormonen</xsl:when>
      <xsl:when test="$code = '144' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Sonstige Christliche Gemeinschaften (O.n.A.)</xsl:when>
      <xsl:when test="$code = '145' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">ELAIA Christengemeinden</xsl:when>
      <xsl:when test="$code = '146' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Pfingstkirche Gemeinde Gottes</xsl:when>
      <!--xsl:when test="$code = '147' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' "></xsl:when-->
      <xsl:when test="$code = '148' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Nicht-christliche Gemeinschaften</xsl:when>
      <xsl:when test="$code = '149' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Israelitische Religionsgesellschaft</xsl:when>
      <xsl:when test="$code = '150' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Islamische Glaubensgemeinschaft </xsl:when>
      <xsl:when test="$code = '151' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Alevitische Religionsgesellschaft</xsl:when>
      <xsl:when test="$code = '152' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Buddhistische Religionsgesellschaft</xsl:when>
      <xsl:when test="$code = '153' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Baha‘ i </xsl:when>
      <xsl:when test="$code = '154' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Hinduistische Religionsgesellschaft</xsl:when>
      <xsl:when test="$code = '155' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Sikh</xsl:when>
      <xsl:when test="$code = '156' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Shintoismus</xsl:when>
      <xsl:when test="$code = '157' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Vereinigungskirche</xsl:when>
      <xsl:when test="$code = '158' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Andere religiöse Bekenntnisgemeinschaften</xsl:when>
      <xsl:when test="$code = '159' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Konfessionslos; ohne Angabe</xsl:when>
      <xsl:when test="$code = '160' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Konfessionslos</xsl:when>
      <xsl:when test="$code = '161' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Ohne Angabe</xsl:when>
      <xsl:when test="$code = '162' and $codeSys = '2.16.840.1.113883.2.16.1.4.1' ">Pastafarianismus</xsl:when>
      <xsl:otherwise><xsl:value-of select="$religiousAffiliation/@displayName" /></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--  Bottomline (additional information to the document)  -->
  <xsl:template name="bottomline">

  <!-- responsible contact (Fachlicher Ansprechpartner) -->
  <xsl:for-each select="/n1:ClinicalDocument/n1:participant">
    <xsl:if test="@typeCode = 'CALLBCK' and not(n1:functionCode/@code) and n1:associatedEntity/@classCode= 'PROV' ">
        <xsl:call-template name="participantIdentification">
          <xsl:with-param name="typecode" select="@typeCode"/>
          <xsl:with-param name="functioncode" select="n1:functionCode/@code"/>
          <xsl:with-param name="classcode" select="n1:associatedEntity/@classCode"/>
          <xsl:with-param name="participant" select="." />
        </xsl:call-template>
      <div class="responsibleContact" id="IDResponsibleContact">
        <div class="ContactAddress">
          <p class="organisationName">
            <xsl:call-template name="getName">
              <xsl:with-param name="name" select="n1:associatedEntity/n1:associatedPerson/n1:name"/>
            </xsl:call-template>
          </p>
      <xsl:call-template name="getContactInfo">
            <xsl:with-param name="contact" select="n1:associatedEntity"/>
          </xsl:call-template>
          <xsl:call-template name="getOrganization">
            <xsl:with-param name="organization" select="n1:associatedEntity/n1:scopingOrganization"/>
          </xsl:call-template>
        </div>
      </div>
    </xsl:if>
  </xsl:for-each>

  <!-- signee (Unterzeichnet von) -->
  <div class="authenticatorContainer" >
    <div class="collapseTrigger" onclick="toggleCollapseable(this);" id="IDAuthenticatorContainer">
      <xsl:call-template name="collapseTrigger"/>
      <h1><xsl:text>Unterzeichnet von:</xsl:text></h1>
      <div class="authenticatorShortInfo">
        <p class="name">
          <xsl:call-template name="getName">
            <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity/n1:assignedPerson/n1:name"/>
          </xsl:call-template>
        </p>
        <p>
          <xsl:text>Unterzeichnet am: </xsl:text>
          <xsl:call-template name="formatDate">
            <xsl:with-param name="date" select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:time/@value" />
          </xsl:call-template>
        </p>
      </div>
      <div class="clearer"></div>
    </div>
    <div class="collapsable">
      <div class="leftsmall">
        <p class="name">
        <xsl:call-template name="getName">
          <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity/n1:assignedPerson/n1:name"/>
        </xsl:call-template>
        </p>
        <xsl:call-template name="getContactInfo">
          <xsl:with-param name="contact" select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity"/>
        </xsl:call-template>
    </div>
    <div class="leftwide">
    <p class="organisationName">
        <xsl:call-template name="getName">
          <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity/n1:representedOrganization/n1:name"/>
        </xsl:call-template>
        </p>
        <xsl:call-template name="getContactInfo">
          <xsl:with-param name="contact" select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity/n1:representedOrganization"/>
        </xsl:call-template>
      </div>
      <div class="clearer"></div>
    </div>
  </div><!-- END authenticatorContainer -->

  <!--
  additional information about the document
  -->
  <div class="bottomline">
    <div class="collapseTrigger" onclick="toggleCollapseable(this);" id="IDBottomline">
      <xsl:call-template name="collapseTrigger"/>
      <h1><xsl:text>Zusätzliche Informationen über dieses Dokument</xsl:text></h1>
      <div class="clearer"></div>
    </div>
    <div class="bottomline_data collapsable">
      <xsl:for-each select="/n1:ClinicalDocument/n1:author">
        <div class="element" onclick="toggleCollapseable(this);">
        <div class="bottomlineCollapseable">
          <xsl:call-template name="collapseTrigger"/>
          <div class="leftsmall">
            <h2><xsl:text>Dokumentverfasser(in)</xsl:text></h2>
            <p class="date">
              <xsl:call-template name="formatDate">
                <xsl:with-param name="date" select="n1:time/@value"/>
              </xsl:call-template>
            </p>
          </div>
          <div class="leftwide">
            <p class="organisationName">
              <xsl:if test="n1:assignedAuthor/n1:assignedPerson/n1:name">
                <xsl:call-template name="getName">
                  <xsl:with-param name="name" select="n1:assignedAuthor/n1:assignedPerson/n1:name"/>
                </xsl:call-template>
              </xsl:if>
              <xsl:if test="n1:assignedAuthoringDevice">
                <xsl:value-of select="n1:assignedAuthoringDevice/n1:softwareName"/>
              </xsl:if>
            </p>
            <p class="organisationName">
              <xsl:call-template name="getName">
                <xsl:with-param name="name" select="n1:assignedAuthor/n1:representedOrganization/n1:name"/>
              </xsl:call-template>
            </p>
            <xsl:call-template name="getContactInfo">
              <xsl:with-param name="contact" select="n1:assignedAuthor/n1:representedOrganization"/>
            </xsl:call-template>
          </div>
        </div>
        <div class="clearer"></div>
        </div>
      </xsl:for-each>
      <xsl:for-each select="/n1:ClinicalDocument/n1:informant">
        <div class="element" onclick="toggleCollapseable(this);">
        <div class="bottomlineCollapseable">
          <xsl:call-template name="collapseTrigger"/>
          <div class="leftsmall">
            <h2><xsl:text>Informiert</xsl:text></h2>
          </div>
          <div class="leftwide">
            <xsl:if test="n1:assignedEntity/n1:assignedPerson|n1:relatedEntity/n1:relatedPerson">
              <p class="organisationName">
              <xsl:call-template name="getName">
                <xsl:with-param name="name" select="n1:assignedEntity/n1:assignedPerson/n1:name|n1:relatedEntity/n1:relatedPerson/n1:name"/>
              </xsl:call-template>
              <xsl:if test="n1:relatedEntity/n1:code">
                <xsl:text> (</xsl:text>
                <xsl:call-template name="translateCode">
                  <xsl:with-param name="code" select="n1:relatedEntity/n1:code"/>
                </xsl:call-template>
                <xsl:text>)</xsl:text>
              </xsl:if>
              </p>
            </xsl:if>
            <xsl:call-template name="getContactInfo">
              <xsl:with-param name="contact" select="n1:assignedEntity|n1:relatedEntity"/>
            </xsl:call-template>
          </div>
        </div>
        <div class="clearer"></div>
        </div>
      </xsl:for-each>
      <xsl:for-each select="/n1:ClinicalDocument/n1:authenticator">
        <div class="element" onclick="toggleCollapseable(this);">
        <div class="bottomlineCollapseable">
          <xsl:call-template name="collapseTrigger"/>
          <div class="leftsmall">
            <h2><xsl:text>Validiert durch</xsl:text></h2>
            <p class="date">
              <xsl:call-template name="formatDate">
                <xsl:with-param name="date" select="n1:time/@value"/>
              </xsl:call-template>
            </p>
          </div>
          <div class="leftwide">
            <p class="organisationName">
              <xsl:call-template name="getName">
                <xsl:with-param name="name" select="n1:assignedEntity/n1:assignedPerson/n1:name"/>
              </xsl:call-template>
            </p>
            <xsl:call-template name="getContactInfo">
              <xsl:with-param name="contact" select="n1:assignedEntity"/>
            </xsl:call-template>
            <xsl:if test="n1:assignedEntity/n1:representedOrganization">
            <br/>
            <xsl:call-template name="getOrganization">
              <xsl:with-param name="organization" select="n1:assignedEntity/n1:representedOrganization"/>
            </xsl:call-template>
            </xsl:if>
          </div>
        </div>
        <div class="clearer"></div>
        </div>
      </xsl:for-each>

      <xsl:for-each select="/n1:ClinicalDocument/n1:dataEnterer">
        <div class="element" onclick="toggleCollapseable(this);">
        <div class="bottomlineCollapseable">
          <xsl:call-template name="collapseTrigger"/>
          <div class="leftsmall">
            <h2><xsl:text>Eingegeben</xsl:text></h2>
            <p class="date">
              <xsl:call-template name="formatDate">
                <xsl:with-param name="date" select="n1:time/@value"/>
              </xsl:call-template>
            </p>
          </div>
          <div class="leftwide">
            <p class="organisationName">
              <xsl:call-template name="getName">
                <xsl:with-param name="name" select="n1:assignedEntity/n1:assignedPerson/n1:name"/>
              </xsl:call-template>
            </p>
            <xsl:call-template name="getContactInfo">
              <xsl:with-param name="contact" select="n1:assignedEntity"/>
            </xsl:call-template>
            <xsl:if test="n1:assignedEntity/n1:representedOrganization">
            <br/>
            <xsl:call-template name="getOrganization">
              <xsl:with-param name="organization" select="n1:assignedEntity/n1:representedOrganization"/>
            </xsl:call-template>
            </xsl:if>
          </div>
        </div>
        <div class="clearer"></div>
        </div>
      </xsl:for-each>
      <xsl:for-each select="/n1:ClinicalDocument/n1:informationRecipient">
        <div class="element" onclick="toggleCollapseable(this);">
        <div class="bottomlineCollapseable">
          <xsl:call-template name="collapseTrigger"/>
          <div class="leftsmall">
            <h2><xsl:text>Kopie an </xsl:text>
              <xsl:choose>
                <xsl:when test="not(@typeCode) or @typeCode != 'TRC'">
                  <span class="lighter">(primär)</span>
                </xsl:when>
                <xsl:otherwise>
                  <span class="lighter">(sekundär)</span>
                </xsl:otherwise>
              </xsl:choose>
            </h2>
          </div>
          <div class="leftwide">
            <p class="organisationName">
            <xsl:if test="n1:intendedRecipient/n1:informationRecipient">
              <xsl:call-template name="getName">
                <xsl:with-param name="name" select="n1:intendedRecipient/n1:informationRecipient/n1:name"/>
              </xsl:call-template>
              <xsl:if test="n1:intendedRecipient/n1:receivedOrganization">
                <br/>
                <xsl:value-of select="n1:intendedRecipient/n1:receivedOrganization/n1:name"/>
              </xsl:if>
            </xsl:if>
            </p>
            <xsl:call-template name="getContactInfo">
              <xsl:with-param name="contact" select="n1:intendedRecipient/n1:receivedOrganization"/>
            </xsl:call-template>
          </div>
        </div>
        <div class="clearer"></div>
        </div>
      </xsl:for-each>

      <xsl:for-each select="/n1:ClinicalDocument/n1:participant">
        <!-- do not show signee and responsible contact again -->
        <xsl:if test="not(@typeCode = 'CALLBCK' and not(n1:functionCode/@code) and n1:associatedEntity/@classCode= 'PROV') ">
          <xsl:call-template name="bottomlineElement" >
            <xsl:with-param name="participant" select="." />
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>

      <div class="element" onclick="toggleCollapseable(this);">
      <div class="bottomlineCollapseable">
          <xsl:call-template name="collapseTrigger"/>
          <div class="leftsmall">
              <h2><xsl:text>Erstellende Organisation</xsl:text></h2>
          </div>
          <div class="leftwide">
            <p class="organisationName">
              <xsl:call-template name="getName">
                <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization/n1:name"/>
              </xsl:call-template>
            </p>
            <xsl:call-template name="getContactInfo">
              <xsl:with-param name="contact" select="/n1:ClinicalDocument/n1:custodian/n1:assignedCustodian/n1:representedCustodianOrganization"/>
            </xsl:call-template>
          </div>
      </div>
      <div class="clearer"></div>
      </div>
    </div>
  </div>
  </xsl:template>

  <!--
  Element for participants shown in additional information of document
  -->
  <xsl:template name="bottomlineElement">
    <xsl:param name="participant" />
    <div class="element" onclick="toggleCollapseable(this);">
      <div class="bottomlineCollapseable">
        <xsl:call-template name="collapseTrigger"/>
        <div class="leftsmall">
          <xsl:call-template name="participantIdentification">
            <xsl:with-param name="participant" select="$participant" />
          </xsl:call-template>
        </div>
        <div class="leftwide">
          <p class="organisationName">
          <!-- different insurance person -->
          <xsl:if test="n1:associatedEntity/n1:code/@code = 'FAMDEP' ">
            <xsl:text>Mitversichert bei: </xsl:text>
          </xsl:if>
          <xsl:call-template name="getName">
            <xsl:with-param name="name" select="n1:associatedEntity/n1:associatedPerson/n1:name"/>
          </xsl:call-template>
          <!-- if urgency contact display relationship -->
          <xsl:if test="@typeCode = 'IND' and not(n1:functionCode/@code) and n1:associatedEntity/@classCode= 'ECON' ">
            <span class="relationship"><xsl:text> (</xsl:text>
            <xsl:call-template name="personalRelationship" >
              <xsl:with-param name="participant" select="$participant" />
            </xsl:call-template>
            <xsl:text>)</xsl:text></span>
            </xsl:if>
          </p>
          <xsl:call-template name="getContactInfo">
            <xsl:with-param name="contact" select="n1:associatedEntity"/>
          </xsl:call-template>
          <xsl:if test="n1:associatedEntity/n1:scopingOrganization">
            <xsl:call-template name="getOrganization">
            <xsl:with-param name="organization" select="n1:associatedEntity/n1:scopingOrganization"/>
          </xsl:call-template>
          </xsl:if>
        </div>
        <div class="clearer"></div>
      </div>
    </div>
  </xsl:template>

  <!--
  collapse triggers [+] [-] for document
  -->
  <xsl:template name="collapseTrigger">
    <span class="collapseLinks tooltipTrigger">
      <!--a class="collapseHide" href="#" onclick="hideCollapseable(this);return false;">[-]</a>
      <a class="collapseShow" href="#" onclick="showCollapsed(this);return false;">[+]</a-->
      <a class="collapseHide" href="#" onclick="return false;">[-]<span class="tooltip">einklappen</span></a>
      <a class="collapseShow" href="#" onclick="return false;">[+]<span class="tooltip">ausklappen</span></a>
    </span>
  </xsl:template>

 <!--
  code translations for participants
    most common used in bottom section of document for additional information
  includes tooltips
  -->
  <xsl:template name="participantIdentification">
    <xsl:param name="participant" />
    <xsl:param name="tag" />
    <xsl:variable name="typecode" select="$participant/@typeCode" />
    <xsl:variable name="functioncode" select="$participant/n1:functionCode/@code" />
    <xsl:variable name="classcode" select="$participant/n1:associatedEntity/@classCode" />
    <xsl:variable name="signaturecode" select="$participant/*/n1:signatureCode/@code" />
    <xsl:choose>
    <xsl:when test="not($tag)"><xsl:variable name="tagname">h2</xsl:variable></xsl:when>
    <xsl:otherwise><xsl:variable name="tagname"><xsl:value-of select="$tag"/></xsl:variable></xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
    <xsl:when test="$typecode = 'RCT'"><h2 class="tooltipTrigger"><xsl:value-of select="$genderedpatient"/><span class="tooltip"><xsl:value-of select="$genderedpatient"/></span></h2></xsl:when>
    <xsl:when test="$typecode = 'AUT'"><h2 class="tooltipTrigger">Verfasser des Dokuments<span class="tooltip">Autor</span></h2></xsl:when>
    <xsl:when test="$typecode = 'ENT'"><h2 class="tooltipTrigger">Schreibkraft<span class="tooltip">Schreibkraft</span></h2></xsl:when>
    <xsl:when test="$typecode = 'CST'"><h2 class="tooltipTrigger">Originaldokument ist verfügbar bei<span class="tooltip">Gibt die Organisation an, die das originale Befunddokument verwahrt.</span></h2></xsl:when>
    <xsl:when test="$typecode = 'INF'"><h2 class="tooltipTrigger">Auskunftsperson zum Patienten<span class="tooltip">Person, die weitere Informationen über den Patienten geben kann</span></h2></xsl:when>
    <xsl:when test="$typecode = 'PRCP'"><h2 class="tooltipTrigger">An:<span class="tooltip">Empfänger des Dokuments</span></h2></xsl:when>
    <xsl:when test="$typecode = 'TRC'"><h2 class="tooltipTrigger">In Kopie an:<span class="tooltip">Weitere Empfänger des Dokuments</span></h2></xsl:when>
    <xsl:when test="$typecode = 'LA'"><h2 class="tooltipTrigger">Unterzeichner(in)<span class="tooltip">Person, die das Dokument unterzeichnet hat</span></h2></xsl:when>
    <xsl:when test="$typecode = 'LA' and $signaturecode='S'"><h2>Unterzeichner(in)</h2></xsl:when>
    <xsl:when test="$typecode = 'AUTHEN'"><h2 class="tooltipTrigger">Weitere Unterzeichner<span class="tooltip">Weitere Personen, die das Dokument unterzeichnet haben.</span></h2></xsl:when>
    <xsl:when test="$typecode = 'AUTHEN' and $signaturecode='S'"><h2>Weitere Unterzeichner</h2></xsl:when>
    <xsl:when test="$typecode = 'CALLBCK'"><h2 class="tooltipTrigger">Für Fragen kontaktieren Sie bitte:<span class="tooltip">Fachliche(r) Ansprechpartner(in)</span></h2></xsl:when>
    <xsl:when test="$typecode = 'REF'"><h2>Auftraggeber(in)</h2></xsl:when>
    <xsl:when test="$typecode = 'REF' and $functioncode='ADMPHYS'"><h2>Einweisende(r)/Zuweisende(r) Arzt/Ärztin</h2></xsl:when>
    <xsl:when test="$typecode = 'IND' and $functioncode = 'PCP' and $classcode= 'PROV'"><h2>Hausarzt/Hausärztin</h2></xsl:when>
    <xsl:when test="$typecode = 'IND' and not($functioncode) and $classcode= 'ECON'"><h2>Notfall-Kontakt</h2></xsl:when>
    <xsl:when test="$typecode = 'IND' and not($functioncode) and $classcode= 'CAREGIVER'"><h2>Betreuende Organisation</h2></xsl:when>
    <xsl:when test="$typecode = 'IND' and not($functioncode) and $classcode= 'PRS'"><h2>
    <xsl:call-template name="personalRelationship" >
      <xsl:with-param name="participant" select="$participant" />
    </xsl:call-template>
    </h2></xsl:when>
    <xsl:when test="$typecode = 'HLD'"><h2>Versicherungsgesellschaft und Versicherungsinhaber</h2></xsl:when>
    <xsl:otherwise>-</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--
  code translations for personal relationship to patient
  -->
  <xsl:template name="personalRelationship">
    <xsl:param name="participant" />
    <xsl:variable name="code"><xsl:value-of select="$participant/*/n1:code/@code"/></xsl:variable>
    <xsl:choose>
      <xsl:when test="$code = 'AUNT' ">Tante</xsl:when>
      <xsl:when test="$code = 'CHILD' ">Kind</xsl:when>
      <xsl:when test="$code = 'CHLDADOPT' ">Adoptivkind</xsl:when>
      <xsl:when test="$code = 'CHLDFOST' ">Pflegekind</xsl:when>
      <xsl:when test="$code = 'CHLDINLAW' ">Schwiegerkind</xsl:when>
      <xsl:when test="$code = 'COUSN' ">Cousin</xsl:when>
      <xsl:when test="$code = 'DAU' ">leibliche Tochter</xsl:when>
      <xsl:when test="$code = 'DAUADOPT' ">Adoptivtocher</xsl:when>
      <xsl:when test="$code = 'DAUC' ">Tochter</xsl:when>
      <xsl:when test="$code = 'DAUFOST' ">Pflegetochter</xsl:when>
      <xsl:when test="$code = 'DAUINLAW' ">Schwiegertochter</xsl:when>
      <xsl:when test="$code = 'DOMPART' ">Lebenspartner(in)</xsl:when>
      <xsl:when test="$code = 'FAMMEMB' ">Familienmitglied</xsl:when>
      <xsl:when test="$code = 'FRND' ">Bekannte(r)</xsl:when>
      <xsl:when test="$code = 'FTH' ">Vater</xsl:when>
      <xsl:when test="$code = 'FTHINLAW' ">Schwiegervater</xsl:when>
      <xsl:when test="$code = 'GGRPRN' ">Urgroßelternteil</xsl:when>
      <xsl:when test="$code = 'GRNDCHILD' ">Enkelkind</xsl:when>
      <xsl:when test="$code = 'GRPRN' ">Großelternteil</xsl:when>
      <xsl:when test="$code = 'HUSB' ">Ehemann</xsl:when>
      <xsl:when test="$code = 'MTH' ">Mutter</xsl:when>
      <xsl:when test="$code = 'MTHINLAW' ">Schwiegermutter</xsl:when>
      <xsl:when test="$code = 'NBOR' ">Nachbar(in)</xsl:when>
      <xsl:when test="$code = 'NCHILD' ">leibliches Kind</xsl:when>
      <xsl:when test="$code = 'NIENEPH' ">Nichte/Neffe</xsl:when>
      <xsl:when test="$code = 'PRN' ">Elternteil</xsl:when>
      <xsl:when test="$code = 'PRNINLAW' ">Schwiegereltern</xsl:when>
      <xsl:when test="$code = 'ROOM' ">Mitbewohner(in)</xsl:when>
      <xsl:when test="$code = 'SIB' ">Geschwister</xsl:when>
      <xsl:when test="$code = 'SIGOTHR' ">Lebensgefährte/wichtige Bezugsperson</xsl:when>
      <xsl:when test="$code = 'SON' ">leiblicher Sohn</xsl:when>
      <xsl:when test="$code = 'SONADOPT' ">Adoptivsohn</xsl:when>
      <xsl:when test="$code = 'SONC' ">Sohn</xsl:when>
      <xsl:when test="$code = 'SONFOST' ">Pflegesohn</xsl:when>
      <xsl:when test="$code = 'SONINLAW' ">Schwiegersohn</xsl:when>
      <xsl:when test="$code = 'SPS' ">Ehepartner</xsl:when>
      <xsl:when test="$code = 'STPCHLD' ">Stiefkind</xsl:when>
      <xsl:when test="$code = 'STPDAU' ">Stieftochter</xsl:when>
      <xsl:when test="$code = 'STPSON' ">Stiefsohn</xsl:when>
      <xsl:when test="$code = 'UNCLE' ">Onkel</xsl:when>
      <xsl:when test="$code = 'WIFE' ">Ehefrau</xsl:when>
    </xsl:choose>
  </xsl:template>

  <!--
  code translations for telecom
  also found in addr tags
  -->
  <xsl:template name="translateCode">
    <xsl:param name="code"/>
    <xsl:choose>
      <!-- lookup table Telecom URI -->
      <xsl:when test="$code='fax'"><xsl:text>Fax</xsl:text></xsl:when>
      <xsl:when test="$code='file'"><xsl:text>Datei</xsl:text></xsl:when>
      <xsl:when test="$code='ftp'"><xsl:text>FTP</xsl:text></xsl:when>
      <xsl:when test="$code='http'"><xsl:text>www</xsl:text></xsl:when>
      <xsl:when test="$code='mailto'"><xsl:text>Email</xsl:text></xsl:when>
      <xsl:when test="$code='me'"><xsl:text>ME-Nummer</xsl:text></xsl:when>
      <xsl:when test="$code='mllp'"><xsl:text>MLLP</xsl:text></xsl:when>
      <xsl:when test="$code='modem'"><xsl:text>Modem</xsl:text></xsl:when>
      <xsl:when test="$code='nfs'"><xsl:text>NFS</xsl:text></xsl:when>
      <xsl:when test="$code='tel'"><xsl:text>Telefon</xsl:text></xsl:when>
      <xsl:when test="$code='telnet'"><xsl:text>Telnet</xsl:text></xsl:when>
      <!-- addr oder telecom use -->
      <xsl:when test="$code='AS'"><xsl:text>Anrufbeantworter</xsl:text></xsl:when>
      <xsl:when test="$code='EC'"><xsl:text>Im Notfall erreichbar unter</xsl:text></xsl:when>
      <xsl:when test="$code='H'"><xsl:text>Wohnort</xsl:text></xsl:when>
      <xsl:when test="$code='HP'"><xsl:text>Hauptwohnsitz</xsl:text></xsl:when>
      <xsl:when test="$code='HV'"><xsl:text>Ferienwohnort</xsl:text></xsl:when>
      <xsl:when test="$code='MC'"><xsl:text>Mobiltelefon</xsl:text></xsl:when>
      <xsl:when test="$code='PG'"><xsl:text>Pager</xsl:text></xsl:when>
      <xsl:when test="$code='WP'"><xsl:text>Geschäftlich</xsl:text></xsl:when>
      <xsl:when test="$code='PUB'"><xsl:text>Geschäftlich</xsl:text></xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- base64 encoded images which are used more often -->
  <xsl:template name="getWarningIcon">
    <img alt="warning icon" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAMAAAC6V+0/AAAABGdBTUEAAK/INwWK6QAAABl0RVh0
U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAKFUExURdBLE81DENtiHdRTF99qIddaGtzW
1N3b29nLx8k8DcVWOONrIeNxJNa5sdvU0tvS0NhbGtrOy8MvBsY2Cv3179RSFte/uNfAuuF/Pta4
sNNpNtnLxtSwptWwpL8nAsE9GtvRz70jAPG5lMU/GNzX1tGfj+d3JcJHJsxfP+JsJdzX1eV1LeNz
KdnFwPOKMONyJOOagdKklumHQNlaEux3KeeGRcNEIcApAvjh191oMMIzC8k7C/aKLtCQetRRFNSm
l8Q0CthqLMhULdvT0dOqnuN7OuhrH+FkH9NTF+JpGNxeHtOXgt5mHN1jHdrMyNJLE93c29nMyOKJ
W74sB93b2trPzM1EEO6viNdwRdKIcOt1KdGfkcxKIOy4p9+Qe/F/JP759eGWf9JKFsyAZ8hhQPnp
4Pzw6dvSz8w/C9VSD9dYF9WJaMMrANxVGMg8Dda7tfKILdFaMvGyhc9FC70lANxUGN1iFel7J/OJ
Lc6PfsyFcdKondOnm85SLMg4CNOMcN5vMOd3Jsw9C9zb2uJtHdVYGs+Vhd1mJt15StzY2PWHK8RC
G85DEO+ELNhgI8QvBdKjltVfLtW0q8QwA9Kkl9KYhdBvRf76+Nt5Remdcsl0Xda7s+RwHNVNE849
DNKejNBLEtVlO78zDdza2dfAudWvpP3079NWGsx/aOZ4J+V3J/GGMM2HcNFVJ+RzJN5vKfO2heVp
H9jFv9e9ttRpRr4sCPB9H+ewoOVzIuuHOvz18s9HDcQ5D+p4K8s+CfCiZPCDKdvV08x7Y8U+FsU3
DMNKKfLMvcIrAdJMDeB+P9SvpcQ6ENpfGMxSL9a7tMo/Ed54Pt9wL8+SgtVMFdzZ2P///93d3ewS
vc8AAAFHSURBVHjaYriGBTBAaen57H62B5EF2WQ7p+rVZ6924VsaAhc8p3Pygk38tq4ZEhcFoYL8
S6rXF/SW79+w80CFY/6mK2BBVc29Jqt2GIlcLZqzMkq7fTZYUEFKTZ+nxTThqpInz7rGaYuBglq6
3pbcLCw+rsuuhpexsHBH2PNfY+A95L6RiYnpTEPa1ZnGTEy+bl5TQNqTWwVYWbP6Uq8GZbKyCixf
AzKTY0uuBzOzqJ3F1Y4TzMzMpZFAQbEVl/0ZGBgWFB+bPnE3kDE3aQJQpbOhUw8jI2PG2oX7gFRY
Sg0byEyOmCZOTuvzBrGFdZx58zSawe5sO919RHhy7a6riTnCew4rbwYL8oWeshIScojbfvZ4v5l4
IDs0QHgXcamblyjKcR2VT4eHkorktcrgqllbZdgmsSMHMkd0gOAlNrSQRwEAAQYARCLRk05qRi0A
AAAASUVORK5CYII=" />
  </xsl:template>

  <xsl:template name="getLawIcon">
    <img alt="law icon" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAMAAAC6V+0/AAAABGdBTUEAAK/INwWK6QAAABl0RVh0
U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJ/UExURRqCoyCXvRd7mxuJrNPX2PH4+yKe
xcXO0dvb3NfZ2h6QtdHW1xZ1k8/U1trb2ym65R6RtjqAlhd5mA5hfCSkzbri7xJphRNtiimy3M7U
1omrtZGvuFqQoQ5ger7Kzr3JzS+ix5CuuCOdxCCYviy/7CSiyq2/xSCawCObwRZtiSm64fD2+BJp
hvH3+R9thhuHqvH4+mCSozJ2jNDV1rDBxxmBohqBohh9naC5wCm55F2briq65iGhxcnR0ySlzyar
0qK5wCWo0ZHR5SWp0yVuhhJohC+OrKnT4Cu03jF+mYq8zB+bwbbFyj2SrePx9Rlyj9XY2R+KrM7T
1cfj7Dyat4u8zD+IoBd8nK/Bx9vc3MfP0lCWrRhmgDOt1bPDyB2DpBRvjXCwxLjc6ClxiCu/7hh2
lIurtWCkuhduiCeu2ZaxunXD2xFng9Tp7yWavBZ1lCiIpyaq1Q9ifcnQ0xqJrLfFynXC2hh7myen
ysTO0ZGuuCaDoBpthxRtihyLr8bf6GmZqNna22CVpcrR0z2PqCat2Im2xcnq9CaStajN2SzA7tLW
2Cev2x6SthBohBFkfxyRtePz+H6jr5vK2SOYvZ+3vuLu8V+gtIWrtrHBxtbv90uqyDemwKfL1ias
1iix3SWexZeyumigsIm3xay/xRBmgnmfrCp5kyq+5a6/xSF3k6C4wHKhrjeoxGuXpRFlgHyntTN3
jRNrh9bY2Q9geySkzEikwlasyE+73RuDpSuSs9Xr8hVqhRdvjBuKrWmbqiKgyMbP0XuhrRuGqbXE
yRyNsVmMnZmzvCOhyTadvH+ntBRqhp/X6Sar1qa7wizA8CGRtU201ZKxu////93d3dk6vRoAAAFK
SURBVHjaYriCBTBA6coZHFFrupEFWSw4T61YNF3rOPdqPrigic2ck+f5+VNC1uYVQwV5fRZqqFj2
zPeQsO7qmCnPCRaU8rafV7hj1uXL7bFnnSt6I8CCQW6tdiKil53OiF7c6pjZ0ggUDJDbsOsEG1vZ
5YnZCkoL2A74XuK9wrBSRl2VkZFxNyvrZdbZUxiVRSZIg7Q31Qlwbb/sty3pcvAFLgH9BpCZ7GFH
mZmZcy8buF+eHMi8r2Q/UPCIoelOBgYGs8T6y7oF8QwMh8MVgSqNq5abMzGlh1Z3XvYqZ2ISzGIB
mcm+SoiHZ+7ladqXo1PzhQT5wO6c1FcjniButbjNc69/bcaeOLAgd/PUpZvEcnTEXE9r6pUe5IAG
iJrwRpf1RcL9RskxkvBQ2rzkyrIt647JOrCc40AOZPa0SNtDLGghjwIAAgwAu17T+cemQ54AAAAA
SUVORK5CYII=" />
  </xsl:template>

  <xsl:template name="getQuestionIcon">
    <img alt="question icon" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAMAAAC6V+0/AAAABGdBTUEAAK/INwWK6QAAABl0RVh0
U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAH7UExURRl+nxyMr83T1RZ4lx+TuBNsiBFn
g9zc3drb2xVxjyGawRBmgSax3BNsiX6jryZuhszT1R2OssfQ0kSBlBmRtxd6mkWAlHyirhd5mSOj
yxh+n4CotI6styySsyev2yOx4Y6uuGCQoBBjfRBifRl/oEeKn32lshRvjWGYqCvA7SvB6EF+kSCW
vE2Yrg9hfEiLoSGcw5e0vCCcxBVykCzE5S7K8jeowl+TpMfP0kmVrEyisRN5mimav0OozB2MsBBm
ggReeyeXvi7M9SW35xePth2bxSix3Ja8yxJngwZgfRifzNXu+Nbp8GC42Nzv9u/2+SiHpxBohSye
xi7E8SSt2jmOrCV2j2WkshV6m8Pj7+v1+SV8mQ9ujTSYuhOHrB2hzRaDpjeYuhhsiC7M9Cew3Bmc
x3LH5h2w4bja55axuhWPthh2lb7k9A9/oxmdx6bY7L7Z5NTm7Se140y221Cz1vb4+hFriGWZqySn
0BiWvjB8l9Dk7RNriCR2j////malsgpriizE8SGo1R2Yvx6Xv97y+iKhyfj8/RV3lrLb61600lOO
oiGx4VSsyh6ZwLvX4sTh7SSizXmrvh+q1j213haFqv/+/3aqvpTU7Cq24xidx+f0+R+05RuMryaL
rYCvwBN2llKQph2jzpWxujmhxB+t2xuFp////93d3SDV4w4AAAFBSURBVHjaYliBBTBAKCbDeiur
cEMmJEF2aTMTU6dkUxMzaXaYoIWuVrBzurx8z5xGLV0LiCCHpebMpVNmeLfmpIUUaVpygAXVeNwm
F89eHuW3fHl+UwqPGkiQSVauIj5yeedEL9/25SWL5GSZgIIKRpJtrhOm2c7KC/Jf3pUqaaQAFNQw
4OJqXtLbUumYsdzHpo/LQAMoqK/DwsIikiUSW728MNGFhUVHHyioKsgIBHOnFizvnxdnx8goqAoU
NF8GAgkBpctDc8FMc6CgjKgKAwODVMT0SdZSQIaKqAzISWESzMzMHdnz3aMXABkStQIgx4urG3Ny
xlTVLV/YwMlprC4O8aYwKy9rTWB3eVIZkCEM8eYKITFuNjY2Twd7DzZuMSF40PHx6ykrKSnr8fOx
IwdypqK2tuJiAZSQRwUAAQYAekGbrEQGRVwAAAAASUVORK5CYII=" />
  </xsl:template>

</xsl:stylesheet>
